/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface CloseableIterator<T>
extends Iterator<T>,
AutoCloseable {
    @Override
    public void close();

    public static <E> List<E> asList(CloseableIterator<E> iterator) {
        try (CloseableIterator<E> closeableIterator = iterator;){
            List list = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).collect(Collectors.toList());
            return list;
        }
    }

    public static <E> CloseableIterator<E> of(Iterator<E> iterator) {
        return CloseableIterator.of(iterator, () -> {});
    }

    public static <E> CloseableIterator<E> of(CloseableIterator<E> iterator) {
        return CloseableIterator.of(iterator, iterator);
    }

    public static <E> CloseableIterator<E> of(final Iterator<E> iterator, final AutoCloseable closeable) {
        return new CloseableIterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }

            @Override
            public void close() {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <E> List<E> asList(Iterator<E> iterator) {
        return CloseableIterator.asList(CloseableIterator.of(iterator));
    }
}

