/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScreencapService;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class DeleteScreencapAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(DeleteScreencapAction.class.getName());

    public DeleteScreencapAction() {
        Image image = ImageUtilities.loadImage((String)"icons.silk/camera.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons/Erase.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedNodes = 0;
        ArrayList<Movie> movies = new ArrayList<Movie>();
        ArrayList<Scene> scenes = new ArrayList<Scene>();
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("movie") != null && (object = n.getValue("movie")) instanceof Movie) {
                Movie movie = (Movie)object;
                movies.add(movie);
                ++selectedNodes;
            }
            if (n.getValue("scene") == null || !((object = n.getValue("scene")) instanceof Scene)) continue;
            Scene scene = (Scene)object;
            scenes.add(scene);
            ++selectedNodes;
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Should the screencaps (if available) of the " + selectedNodes + " selected nodes really get deleted?", "Delete screencap?", 0)) {
            for (Movie movie : movies) {
                LOG.info("Delete screencaps");
                boolean found = false;
                try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxScreencapDir, new String[0]), new FileVisitOption[0]);){
                    for (Path filePath : paths.collect(Collectors.toList())) {
                        if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                        try {
                            LOG.finest("Possible screencap: " + filePath.toString());
                            if (!filePath.getFileName().toString().startsWith(movie.getId() + "_")) continue;
                            found = true;
                            if (new File(filePath.toString()).delete()) {
                                LOG.info("Deleted screencap: " + filePath.toString());
                                AbstractTopComponent.notifyInfo("Deleted screencap: " + filePath.toString());
                                continue;
                            }
                            LOG.info("Error while deleteing screencap: " + filePath.toString());
                            AbstractTopComponent.notifyError("An error occured . Could not delete screencap for file '" + filePath.toString() + "'");
                        }
                        catch (Exception ex) {
                            LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
                        }
                    }
                }
                catch (IOException ex) {
                    LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
                }
                if (found) continue;
                AbstractTopComponent.notifyError("No screencap found for movie '" + movie.getNameOfPlayable() + "'");
            }
            ScreencapService.deleteSceneScreencaps(scenes);
            LOG.info("Finished deleting screencaps");
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Delete screencap";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

