/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.service.MediumFileService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.ScreencapService;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;

public class RecreateScreencapAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(RecreateScreencapAction.class.getName());
    private static NumberFormat formatter = new DecimalFormat("0000");
    private DB db = DB.getInstance();

    public RecreateScreencapAction() {
        Image image = ImageUtilities.loadImage((String)"icons.silk/camera.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedNodes = 0;
        ArrayList<Movie> movies = new ArrayList<Movie>();
        ArrayList<Scene> scenes = new ArrayList<Scene>();
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("movie") != null && (object = n.getValue("movie")) instanceof Movie) {
                Movie movie = (Movie)object;
                movies.add(movie);
                ++selectedNodes;
            }
            if (n.getValue("scene") == null || !((object = n.getValue("scene")) instanceof Scene)) continue;
            Scene sc = (Scene)object;
            scenes.add(sc);
            ++selectedNodes;
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Should the screencaps (if available) of the " + selectedNodes + " selected nodes really get re-created?", "Recreate screencap?", 0)) {
            new RecreateScreencapWorker(movies, scenes).execute();
        }
    }

    private void generateMovieScreencaps(List<Movie> movies) {
        ScenerixxSettings settings = this.db.getScenerixxSettings();
        for (Movie movie : movies) {
            LOG.fine("Check if we need to create screencaps for movie  '" + movie.getTitle() + "' (ID: " + movie.getId() + ")");
            LOG.finest("Create screencaps for movie '" + movie.getTitle());
            int i = 1;
            List mfs = this.db.getMediumFiles(movie, Scenerixx.unlocked);
            for (MediumFile mf : mfs) {
                if (!MediumFileService.isMovie((MediumFile)mf)) continue;
                if (!Files.exists(Paths.get(Scenerixx.scenerixxScreencapDir + File.separator + movie.getId() + "_" + formatter.format(i) + ".png", new String[0]), new LinkOption[0]) && !Files.exists(Paths.get(Scenerixx.scenerixxScreencapDir + File.separator + movie.getId() + "_" + i + ".png", new String[0]), new LinkOption[0])) {
                    String errorMessage;
                    LOG.fine("Create screencap for medium file: " + mf.getFileCompletePath() + "(Movie-ID: " + mf.getMovie().getId() + ") - " + ScenerixxCommon.readableFileSize(mf.getFileSize()) + " - " + ScenerixxCommon.readableDuration(mf.getDuration()));
                    if (mf.getTotalRuntime() == 0) {
                        errorMessage = "Cannot create screencap for " + mf.getFileCompletePath() + " since the runtime is not known! Either update the media information or provide the runtime manually.";
                        AbstractTopComponent.notifyError(errorMessage);
                        LOG.fine(errorMessage);
                        break;
                    }
                    if (!Files.exists(Paths.get(mf.getFileCompletePath(), new String[0]), new LinkOption[0])) {
                        errorMessage = "Cannot create screencap for " + mf.getFileCompletePath() + " since the file is not available.";
                        AbstractTopComponent.notifyError(errorMessage);
                        LOG.fine(errorMessage);
                        break;
                    }
                    try {
                        ScreencapService.createMovieScreencap(movie, i, settings.getScreencapPicsPerCol() * settings.getScreencapPicsPerRow() / mfs.size());
                    }
                    catch (IOException ex) {
                        LOG.severe("io-error during stitching");
                    }
                    break;
                }
                LOG.fine("Screencap for mediumfile " + mf.getFileCompletePath() + " already exists.");
                break;
            }
            if (!settings.isScreencapGenerateScenes() || movie.getScenes().size() <= 1) continue;
            LOG.fine("Generate screencaps for scenes for movie '" + movie.getTitle() + "' if needed");
            this.generateSceneScreencaps(movie.getScenes());
        }
    }

    private void deleteMovieScreencaps(List<Movie> movies) {
        for (Movie movie : movies) {
            LOG.info("Delete screencaps (if available)");
            try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxScreencapDir, new String[0]), new FileVisitOption[0]);){
                for (Path filePath : paths.collect(Collectors.toList())) {
                    if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                    try {
                        LOG.finest("Possible screencap: " + filePath.toString());
                        if (!filePath.getFileName().toString().startsWith(movie.getId() + "_")) continue;
                        if (new File(filePath.toString()).delete()) {
                            LOG.info("Deleted screencap: " + filePath.toString());
                            continue;
                        }
                        LOG.info("Error while deleting screencap: " + filePath.toString());
                    }
                    catch (Exception ex) {
                        LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
                    }
                }
            }
            catch (IOException ex) {
                LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
            }
            for (Scene s : movie.getScenes()) {
                File f = new File(Scenerixx.scenerixxScreencapDir + File.separator + "scene" + File.separator + s.getId() + "_" + s.getPosition() + ".png");
                if (f.delete()) {
                    LOG.fine("Deleted screencap for scene: " + s.getNameOfPlayable());
                    continue;
                }
                LOG.fine("Could not delete screencap for scene: " + s.getNameOfPlayable() + ". Maybe no screencap exists.");
            }
        }
        LOG.info("Finished deleting screencaps");
    }

    private void generateSceneScreencaps(List<Scene> scenes) {
        ScreencapService.deleteSceneScreencaps(scenes);
        for (Scene s : scenes) {
            ScreencapService.generateSceneScreencaps(s);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Re-create screencap(s)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    public class RecreateScreencapWorker
    extends SwingWorker<String, String> {
        List<Movie> movies;
        List<Scene> scenes;

        public RecreateScreencapWorker(List<Movie> movies, List<Scene> scenes) {
            this.movies = movies;
            this.scenes = scenes;
        }

        @Override
        protected String doInBackground() throws Exception {
            RecreateScreencapAction.this.deleteMovieScreencaps(this.movies);
            RecreateScreencapAction.this.generateMovieScreencaps(this.movies);
            RecreateScreencapAction.this.generateSceneScreencaps(this.scenes);
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                ((DetailsTopComponent)details).updateScreencaps();
            }
            AbstractTopComponent.notifyInfo("Finished re-creating screencaps");
            return null;
        }
    }
}

