/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.playlist;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.MovieChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.DeleteMovieFromDiscAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.MoveItemDownAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.MoveItemUpAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.OpenAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.OpenSeveralInstancesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.RemoveItemFromPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.StartPlaylistFromHereAction;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.StartPlaylistFromHereReverseAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.SceneChildFactory;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class PlaylistEntryChildFactory
extends ChildFactory.Detachable<PlaylistEntry>
implements LookupListener {
    public static final Logger LOG = Logger.getLogger(PlaylistEntryChildFactory.class.getName());
    private List<PlaylistEntry> resultList;
    private DB db = DB.getInstance();
    private boolean showPosition = false;
    private DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private Lookup.Result<PlaylistEntry> results;

    public PlaylistEntryChildFactory(List<PlaylistEntry> resultList, boolean showPosition) {
        this.resultList = resultList;
        this.showPosition = showPosition;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in PlayableChildFactory: " + String.valueOf(node));
    }

    protected boolean createKeys(List<PlaylistEntry> list) {
        for (PlaylistEntry p : this.resultList) {
            list.add(p);
            LOG.finest("Create keys. Playable: " + p.getNameOfPlayable());
        }
        return true;
    }

    protected Node createNodeForKey(PlaylistEntry p) {
        String coloredStar;
        LOG.finest("create new node for key. IPlayable: " + p.getNameOfPlayable());
        PlaylistEntryBeanNode result = null;
        try {
            if (p.getStudio() == null && p.getPerson() == null || p.getPerson() != null && p.getPerson().getScenes(Scenerixx.unlocked).isEmpty() || p.getStudio() != null && p.getStudio().getMovies(Scenerixx.unlocked).isEmpty()) {
                result = new PlaylistEntryBeanNode(p);
            } else if (p.getStudio() != null) {
                List movies = p.getStudio().getMovies(Scenerixx.unlocked);
                ArrayList<INode> tmpList = new ArrayList<INode>();
                tmpList.addAll(movies);
                result = new PlaylistEntryBeanNode(p, Children.create((ChildFactory)new MovieChildFactory(tmpList, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, false, false, true, false, false, false, false, false), (boolean)true));
            } else if (p.getPerson() != null) {
                result = new PlaylistEntryBeanNode(p, Children.create((ChildFactory)new SceneChildFactory(p.getPerson().getScenesAsINode(Scenerixx.unlocked), false, true, true, false, false, true, true, true, true, true), (boolean)true));
            }
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("Could not create playlist entry node. An error occured: " + ex.getMessage());
        }
        result.setName("" + p.getId());
        String displayName = p.getNameOfPlayable() + " [Runtime: " + p.getRuntime() + "]";
        Integer rating = 0;
        if (p.getPerson() != null) {
            rating = p.getPerson().getRating();
        }
        if (p.getScene() != null) {
            rating = p.getScene().getRating();
        }
        if (p.getMovie() != null) {
            rating = p.getMovie().getRating();
        }
        if (p.getBookmark() != null) {
            rating = p.getBookmark().getRating();
        }
        if (rating == null) {
            rating = -1;
        }
        if (!(coloredStar = ScenerixxCommon.getColoredStar(rating, p.getRatingDifferentiator())).startsWith("??")) {
            displayName = "[" + coloredStar + "] " + displayName;
        }
        if (this.showPosition) {
            displayName = p.getPlaylist().getPositionInList() + "." + p.getPositionInList() + " " + displayName;
        }
        result.setDisplayName("<html>" + displayName + "</html>");
        result.setValue("entry", p);
        String createdOn = "???";
        if (p.getDateOfCreation() != null) {
            createdOn = this.df.format(p.getDateOfCreation());
        }
        String tooltip = p.getNameOfPlayable() + " was added on " + createdOn;
        result.setShortDescription("<html>" + tooltip + "</html>");
        return result;
    }

    protected void addNotify() {
        super.addNotify();
        LOG.fine("PlaylistEntryChildFactory ADD NOTIFY");
        this.results = Utilities.actionsGlobalContext().lookupResult(PlaylistEntry.class);
        this.results.addLookupListener((LookupListener)this);
    }

    protected void removeNotify() {
        super.removeNotify();
        LOG.info("PlaylistEntryChildFactory REMOVE NOTIFY " + this.results.allItems().size());
        this.results.removeLookupListener((LookupListener)this);
        this.results = null;
    }

    public void resultChanged(LookupEvent le) {
        int selectedPe = this.results.allInstances().size();
        LOG.info("Refresh (resultChanged) - selected playlistentries: " + selectedPe);
    }

    public class PlaylistEntryBeanNode
    extends BeanNode {
        public Action getPreferredAction() {
            PlaylistEntry pe = (PlaylistEntry)this.getLookup().lookup(PlaylistEntry.class);
            LOG.info("open " + pe.getNameOfPlayable());
            StartPlaylistFromHereAction get = (StartPlaylistFromHereAction)SystemAction.get(StartPlaylistFromHereAction.class);
            get.execute((Node)this);
            return null;
        }

        public String getHtmlDisplayName() {
            return this.getDisplayName();
        }

        public PlaylistEntryBeanNode(PlaylistEntry bean) throws IntrospectionException {
            super((Object)bean, Children.LEAF, Lookups.singleton((Object)bean));
        }

        public PlaylistEntryBeanNode(PlaylistEntry bean, Children children) throws IntrospectionException {
            super((Object)bean, children, Lookups.singleton((Object)bean));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Image getIcon(int type) {
            PlaylistEntry pe = (PlaylistEntry)this.getLookup().lookup(PlaylistEntry.class);
            Image result = ImageUtilities.loadImage((String)"icons/yellowbookmark.png");
            boolean isVr = false;
            if (pe.getScene() != null) {
                result = ImageUtilities.loadImage((String)"icons/bluebookmark.png");
                isVr = pe.getScene().getMovieAssociated().isVr();
            } else if (pe.getMovie() != null) {
                if (pe.getMovie().getScenes().size() == 1) {
                    result = ImageUtilities.loadImage((String)"icons/bluebookmark.png");
                    isVr = pe.getMovie().isVr();
                } else {
                    result = ImageUtilities.loadImage((String)"icons/film.png");
                }
            } else if (pe.getBookmark() != null) {
                result = ImageUtilities.loadImage((String)"icons/greenbookmark.png");
                isVr = pe.getBookmark().getMovieAssociated().isVr();
            } else if (pe.getStudio() != null) {
                result = ImageUtilities.loadImage((String)"icons/record.png");
            } else if (pe.getPerson() != null) {
                if (Gender.MALE.equals((Object)pe.getPerson().getGender())) {
                    result = ImageUtilities.loadImage((String)"icons/male.png");
                }
                if (Gender.FEMALE.equals((Object)pe.getPerson().getGender())) {
                    result = ImageUtilities.loadImage((String)"icons/female.png");
                }
                if (Gender.TS.equals((Object)pe.getPerson().getGender())) {
                    result = ImageUtilities.loadImage((String)"icons2/transgender.png");
                }
            }
            result = ImageUtilities.mergeImages((Image)result, (Image)ImageUtilities.loadImage((String)"icons/yellowbookmark.png"), (int)-1, (int)4);
            if (isVr) {
                result = ImageUtilities.mergeImages((Image)result, (Image)ImageUtilities.loadImage((String)"icons8/microsoft-hololens.png"), (int)-1, (int)4);
            }
            return result;
        }

        public PasteType createPasteType(final Transferable t, final int action, final AbstractNode nodeToSelectAfterReload) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    Node[] nodes;
                    for (Node node : nodes = NodeTransfer.nodes((Transferable)t, (int)action)) {
                        if (node instanceof PlaylistEntryBeanNode) {
                            PlaylistEntry source = (PlaylistEntry)node.getValue("entry");
                            PlaylistEntry target = (PlaylistEntry)PlaylistEntryBeanNode.this.getValue("entry");
                            LOG.info("source: " + source.getNameOfPlayable());
                            LOG.info("target: " + target.getNameOfPlayable());
                            if (source.getPlaylist().equals(target.getPlaylist())) {
                                PlaylistEntry tmp = (PlaylistEntry)source.getPlaylist().getEntries(Scenerixx.unlocked).remove(source.getPos());
                                LOG.info("removed entry: " + tmp.getNameOfPlayable());
                                source.getPlaylist().getEntries(Scenerixx.unlocked).add(target.getPos(), tmp);
                                int i = 0;
                                for (PlaylistEntry entry : source.getPlaylist().getEntries(Scenerixx.unlocked)) {
                                    LOG.info("new position for " + entry.getNameOfPlayable() + " " + i);
                                    entry.setPos(i);
                                    ++i;
                                    entry = (PlaylistEntry)PlaylistEntryChildFactory.this.db.getEntityService().save((AbstractEntity)entry);
                                }
                                PlaylistEntryChildFactory.this.db.evictCache();
                                PlaylistTopComponent.reloadPlaylist(source.getPlaylist().getName());
                                continue;
                            }
                            source = (PlaylistEntry)PlaylistEntryChildFactory.this.db.getEntityService().load(PlaylistEntry.class, source.getId().longValue());
                            String sourcePlaylistName = source.getPlaylist().getName();
                            Long sourcePlaylistId = source.getPlaylist().getId();
                            LOG.info("Source: " + source.getNameOfPlayable());
                            LOG.info("Target: " + target.getNameOfPlayable());
                            LOG.info("Move " + source.getNameOfPlayable() + " from playlist " + source.getPlaylist().getName() + " to " + target.getPlaylist().getName());
                            source.setPlaylist(target.getPlaylist());
                            source.setPos(target.getPos());
                            source = (PlaylistEntry)PlaylistEntryChildFactory.this.db.getEntityService().save((AbstractEntity)source);
                            PlaylistEntryChildFactory.this.db.getEntityService().getEntityManager().getEntityManagerFactory().getCache().evict(PlaylistEntry.class);
                            PlaylistEntryChildFactory.this.db.getEntityService().getEntityManager().getEntityManagerFactory().getCache().evict(Playlist.class);
                            PlaylistService playlistService = new PlaylistService();
                            playlistService.correctAllPositions((Playlist)PlaylistEntryChildFactory.this.db.getEntityService().load(Playlist.class, sourcePlaylistId.longValue()), Scenerixx.unlocked);
                            playlistService.correctAllPositions((Playlist)PlaylistEntryChildFactory.this.db.getEntityService().load(Playlist.class, target.getPlaylist().getId().longValue()), Scenerixx.unlocked);
                            target = (PlaylistEntry)PlaylistEntryChildFactory.this.db.getEntityService().load(PlaylistEntry.class, target.getId().longValue());
                            PlaylistEntryBeanNode.this.setValue("entry", target);
                            AbstractTopComponent.notifyInfo("Moved '" + source.getNameOfPlayable() + "' from playlist '" + sourcePlaylistName + "' to '" + target.getPlaylist().getName() + "'");
                            continue;
                        }
                        LOG.fine("Something pasted to a playlist entry but not a PlaylistEntryBeanNode: " + node.getDisplayName());
                    }
                    LOG.info("refresh after drop");
                    PlaylistEntryChildFactory.this.refresh(true);
                    if (nodes != null && nodes.length > 0) {
                        LOG.fine("Reload now");
                        PlaylistEntryChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                    }
                    return null;
                }
            };
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            return this.createPasteType(t, action, (AbstractNode)this);
        }

        public Action[] getActions(boolean context) {
            PlaylistEntry pe = (PlaylistEntry)this.getLookup().lookup(PlaylistEntry.class);
            ArrayList<SystemAction> list = new ArrayList<SystemAction>();
            list.add(SystemAction.get(StartPlaylistFromHereAction.class));
            list.add(SystemAction.get(StartPlaylistFromHereReverseAction.class));
            list.add(SystemAction.get(OpenAction.class));
            list.add(SystemAction.get(OpenSeveralInstancesAction.class));
            list.add(null);
            if (pe.getPos() > 0) {
                list.add(SystemAction.get(MoveItemUpAction.class));
            }
            if (pe.getPos() < pe.getPlaylist().getEntries(Scenerixx.unlocked).size() - 1) {
                list.add(SystemAction.get(MoveItemDownAction.class));
            }
            list.add(null);
            list.add(SystemAction.get(AddToPlaylistAction.class));
            list.add(null);
            list.add(SystemAction.get(RemoveItemFromPlaylistAction.class));
            list.add(null);
            list.add(SystemAction.get(DeleteMovieFromDiscAction.class));
            Action[] actions = new Action[list.size()];
            actions = list.toArray(actions);
            return actions;
        }
    }
}

