/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.playlist.action;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class CopyPlaylistItemsAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(CopyPlaylistItemsAction.class.getName());
    private JFileChooser jFileChooser2 = new JFileChooser();

    public CopyPlaylistItemsAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/move_to_folder.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        SwingUtilities.invokeLater(() -> {
            int n = 0;
            Node[] nodeArray = activatedNodes;
            int n2 = nodeArray.length;
            if (n < n2) {
                Object patt0$temp;
                Node n3 = nodeArray[n];
                if (n3.getValue("playlist") != null && (patt0$temp = n3.getValue("playlist")) instanceof Playlist) {
                    Playlist playlist = (Playlist)patt0$temp;
                    JOptionPane.showMessageDialog(null, "<html><br>You can copy with this feature the files that are associated to the playables of the playlist to a specified directory.<br><br>Useful e.g. if you want to copy VR movies to your mobiile phone.<br><br>WARNING: Once started you cannot abort the copy process (which runs in the background) anymore. </html>");
                    this.jFileChooser2.setFileSelectionMode(2);
                    int ret = this.jFileChooser2.showOpenDialog(null);
                    if (ret == 0) {
                        if (!this.jFileChooser2.getSelectedFile().isDirectory()) {
                            JOptionPane.showMessageDialog(null, "You need to select a directory.", "Nothing to do here", 2);
                        } else {
                            new CopyFilesWorker(playlist).execute();
                        }
                    } else {
                        LOG.finest("User decided to cancel");
                    }
                }
                return;
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1;
    }

    public String getName() {
        return "Copy files";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    public class CopyFilesWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        private Playlist playlist;

        public CopyFilesWorker(Playlist playlist) {
            this.playlist = playlist;
        }

        @Override
        protected String doInBackground() throws Exception {
            LOG.fine("Copy playlist '" + this.playlist.getName() + "' to '" + String.valueOf(CopyPlaylistItemsAction.this.jFileChooser2.getSelectedFile()) + "' (" + this.playlist.getEntries(Scenerixx.unlocked).size() + " items).");
            List playables = this.playlist.getPlayables(Scenerixx.unlocked);
            int i = 0;
            for (IPlayablePlaylistItems p : playables) {
                String fileName;
                List mediumFiles;
                int tmpI = ++i;
                if (p instanceof Movie) {
                    Movie mov = (Movie)p;
                    mediumFiles = DB.getInstance().getMediumFiles(mov, Scenerixx.unlocked);
                    for (MediumFile mf : mediumFiles) {
                        fileName = mf.getFileName();
                        LOG.fine(mov.getPositionInList() + ". [movie] Copying " + fileName);
                        try {
                            Files.copy(Path.of(mf.getFileCompletePath(), new String[0]), Path.of(CopyPlaylistItemsAction.this.jFileChooser2.getSelectedFile().getAbsolutePath() + File.separator + fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            this.publish("Copied " + tmpI + "/" + playables.size() + " [movie] : " + mov.getTitle());
                        }
                        catch (IOException ex) {
                            this.publish("Error: " + ex.getMessage());
                            throw new RuntimeException(ex.getMessage(), ex);
                        }
                    }
                    continue;
                }
                if (p instanceof Scene) {
                    Scene scene = (Scene)p;
                    this.publish(tmpI + "/" + playables.size() + " [scene] : " + scene.getMovieAssociated().getTitle());
                    mediumFiles = DB.getInstance().getMediumFiles(scene.getMovieAssociated(), Scenerixx.unlocked);
                    for (MediumFile mf : mediumFiles) {
                        fileName = mf.getFileName();
                        LOG.fine(scene.getPositionInList() + ". [scene]  Copying " + fileName);
                        try {
                            Files.copy(Path.of(mf.getFileCompletePath(), new String[0]), Path.of(CopyPlaylistItemsAction.this.jFileChooser2.getSelectedFile().getAbsolutePath() + File.separator + fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ex) {
                            this.publish("Error: " + ex.getMessage());
                            throw new RuntimeException(ex.getMessage(), ex);
                        }
                    }
                    continue;
                }
                if (p instanceof Bookmark) {
                    Bookmark bookmark = (Bookmark)p;
                    this.publish(tmpI + "/" + playables.size() + " [bookmark] : " + bookmark.getMovieAssociated().getTitle());
                    mediumFiles = DB.getInstance().getMediumFiles(bookmark.getMovieAssociated(), Scenerixx.unlocked);
                    for (MediumFile mf : mediumFiles) {
                        fileName = mf.getFileName();
                        LOG.fine(bookmark.getPositionInList() + ". [bookmark]  Copying " + fileName);
                        try {
                            Files.copy(Path.of(mf.getFileCompletePath(), new String[0]), Path.of(CopyPlaylistItemsAction.this.jFileChooser2.getSelectedFile().getAbsolutePath() + File.separator + fileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException ex) {
                            this.publish("Error: " + ex.getMessage());
                            throw new RuntimeException(ex.getMessage(), ex);
                        }
                    }
                    continue;
                }
                LOG.info(p.getId() + " was not a movie or scene. Don't copy.");
                this.publish("Cannot copy entry with ID " + p.getId() + ". Only movies, scenes and bookmarks are supported.");
            }
            this.publish("Finished copying files.");
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                if (s.toLowerCase().startsWith("error")) {
                    AbstractTopComponent.notifyError("[" + this.df.format(LocalDateTime.now()) + "] " + s);
                    continue;
                }
                AbstractTopComponent.notifyInfo("[" + this.df.format(LocalDateTime.now()) + "] " + s);
            }
        }

        @Override
        protected void done() {
            super.done();
        }
    }
}

