/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.scene.action;

import java.awt.Image;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.SceneChildFactory;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class AddSeveralBookmarksAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(AddSeveralBookmarksAction.class.getName());
    private final DB db = DB.getInstance();
    private SceneChildFactory scf = this.scf;
    private Image image = ImageUtilities.mergeImages((Image)this.image, (Image)ImageUtilities.loadImage((String)"icons.fatcow/paginator.png"), (int)7, (int)7);

    public AddSeveralBookmarksAction() {
        this.putValue("SmallIcon", this.image);
    }

    protected void performAction(Node[] activatedNodes) {
        ArrayList<CallSite> scenesModel = new ArrayList<CallSite>();
        scenesModel.add(0, null);
        for (int i = 0; i <= 100; ++i) {
            scenesModel.add((CallSite)((Object)("" + i)));
        }
        Object[] toArray = scenesModel.toArray(new String[scenesModel.size()]);
        String showInputDialog = (String)JOptionPane.showInputDialog(null, "Bookmarks to create", "How many bookmarks should be created?", 3, ImageUtilities.image2Icon((Image)this.image), toArray, toArray[0]);
        int cnt = ScenerixxCommon.parseInt(showInputDialog);
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("scene") == null || !((object = n.getValue("scene")) instanceof Scene)) continue;
            Scene scene = (Scene)object;
            scene = (Scene)this.db.getEntityService().load(Scene.class, scene.getId().longValue());
            int newPos = -1;
            for (Bookmark b : scene.getBookmarks(true)) {
                if (newPos >= b.getPosition()) continue;
                newPos = b.getPosition();
            }
            for (int i = 1; i <= cnt; ++i) {
                Bookmark newBookmark = new Bookmark();
                newBookmark.setDateOfCreation(LocalDateTime.now());
                newBookmark.setPosition(++newPos);
                newBookmark.setScene(scene);
                scene.getBookmarks(true).add(newBookmark);
            }
            LOG.fine("Created " + cnt + " bookmarks");
            scene = (Scene)this.db.getEntityService().save((AbstractEntity)scene);
            int tmpCnt = cnt;
            int tmpNewPos = newPos;
            Scene tmpScene = scene;
            SwingUtilities.invokeLater(() -> {
                AbstractTopComponent.notifyInfo("Added " + tmpCnt + " bookmarks to " + tmpScene.toString());
                TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                if (movieList != null) {
                    ((MovieListTopComponent)movieList).reloadList();
                    int index = tmpNewPos - tmpCnt + 1;
                    if (!tmpScene.getBookmarks(true).isEmpty() && index < tmpScene.getBookmarks(true).size()) {
                        ((MovieListTopComponent)movieList).selectBookmarkNode((Bookmark)tmpScene.getBookmarks(true).get(index));
                        ((MovieListTopComponent)movieList).refocus();
                    } else {
                        LOG.warning("Could not find index " + index + " to select bookmark");
                    }
                }
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Add n bookmarks to scene";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

