/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.scene.action;

import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.PersonSwapPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;

public class SwapPersonAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(SwapPersonAction.class.getName());
    private DB db = DB.getInstance();

    public SwapPersonAction() {
        Image image = ImageUtilities.loadImage((String)"icons/persons.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons.fugue/arrow-switch.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        Scene selectedScene = (Scene)activatedNodes[0].getValue("scene");
        final PersonSwapPanel panel = new PersonSwapPanel(selectedScene);
        JOptionPane op = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
                panel.getComboPerson();
            }
        };
        JDialog dlg = op.createDialog("Switch person");
        dlg.setVisible(true);
        dlg.addWindowFocusListener(new WindowAdapter(this){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                panel.gainedFocus();
            }
        });
        if (op.getValue() != null && op.getValue().equals(0)) {
            Person existingPerson = panel.getExistingPerson();
            Person newPerson = panel.getTargetPerson();
            SceneDetails details = selectedScene.getDetails(existingPerson);
            details.setPerson(newPerson);
            this.db.getEntityService().save((AbstractEntity)details);
            SwingUtilities.invokeLater(() -> {
                DetailsTopComponent detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (detailTC != null) {
                    detailTC.updateDisplayNameOfSelectedNode(false, false);
                }
                AbstractTopComponent.dirtyPersonList();
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        Object object;
        if (activatedNodes.length == 1 && activatedNodes[0].getValue("scene") != null && (object = activatedNodes[0].getValue("scene")) instanceof Scene) {
            Scene s = (Scene)object;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Switch person";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

