/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.enums.Appearance;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxmodule.childfactories.person.PersonChildFactory;

public class AppearanceChildFactory
extends ChildFactory<Appearance> {
    public static final Logger LOG = Logger.getLogger(AppearanceChildFactory.class.getName());
    private List<Appearance> appearanceList;
    private DB db = DB.getInstance();
    private Gender gender = null;
    private boolean showCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showPosition = false;

    public AppearanceChildFactory(Gender gender, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showSecret, boolean showPosition) {
        this.appearanceList = new ArrayList<Appearance>(Arrays.asList(Appearance.values()));
        this.gender = gender;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSecret = showSecret;
        this.showPosition = showPosition;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in BodyTypeChildFactory");
    }

    protected boolean createKeys(List<Appearance> list) {
        for (Appearance appearance : this.appearanceList) {
            list.add(appearance);
        }
        return true;
    }

    protected Node createNodeForKey(Appearance appearance) {
        LOG.finest("create new node for Appearance: " + appearance.toString());
        List personsByAppearance = null;
        personsByAppearance = this.db.getPersonsByAppearance(this.gender, appearance, this.showSecret);
        AbstractNode result = new AbstractNode(this, Children.create((ChildFactory)new PersonChildFactory(personsByAppearance, this.showCounter, this.showBirthyear, this.showRating, this.showLikeCounter, this.showRuntime, false, this.showPosition), (boolean)true)){

            public Image getOpenedIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/Folder.png");
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }
        };
        String app = " [" + this.db.getPersonsByAppearanceCount(this.gender, appearance, this.showSecret) + "]";
        result.setDisplayName(appearance.getTitle() + app);
        result.setValue("appearance", (Object)appearance);
        result.setName(appearance.getTitle());
        return result;
    }
}

