/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.enums.Ethnicity;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxmodule.childfactories.person.PersonChildFactory;

public class EthnicityChildFactory
extends ChildFactory<Ethnicity> {
    public static final Logger LOG = Logger.getLogger(EthnicityChildFactory.class.getName());
    private List<Ethnicity> ethnicityList;
    private DB db = DB.getInstance();
    private Gender gender = null;
    private boolean showCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showPosition = false;

    public EthnicityChildFactory(Gender gender, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showSecret, boolean showPosition) {
        this.ethnicityList = new ArrayList<Ethnicity>(Arrays.asList(Ethnicity.values()));
        this.gender = gender;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSecret = showSecret;
        this.showPosition = showPosition;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in EthnicityChildFactory");
    }

    protected boolean createKeys(List<Ethnicity> list) {
        for (Ethnicity eth : this.ethnicityList) {
            list.add(eth);
        }
        return true;
    }

    protected Node createNodeForKey(Ethnicity eth) {
        LOG.finest("create new node for Ethnicity: " + eth.toString());
        AbstractNode result = new AbstractNode(this, Children.create((ChildFactory)new PersonChildFactory(this.db.getPersonsByEthnicity(this.gender, eth, this.showSecret), this.showCounter, this.showBirthyear, this.showRating, this.showLikeCounter, this.showRuntime, false, this.showPosition), (boolean)true)){

            public Image getOpenedIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/Folder.png");
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }
        };
        String app = " [" + this.db.getPersonsByEthnicityCount(this.gender, eth, this.showSecret) + "]";
        result.setDisplayName(eth.getTitle() + app);
        result.setValue("ethnicity", (Object)eth);
        result.setName(eth.getTitle());
        return result;
    }
}

