/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.studio;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.INode;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.CallableMovieChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.MovieChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToDefaultPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.CallableStudioChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.action.CreatePlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.action.DeleteStudioAction;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.action.ExportStudioAction;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.action.ImportStudioAction;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.studio.StudioListTopComponent;

public class StudioChildFactory
extends ChildFactory<INode> {
    public static final Logger LOG = Logger.getLogger(StudioChildFactory.class.getName());
    public static String unknown_studios = "[Unknown studios]";
    private DB db = DB.getInstance();
    private List<INode> resultList;
    private String suffix = "";
    private boolean showImportMenu = false;
    private boolean showPosition = false;

    public StudioChildFactory(List<INode> resultList) {
        this.resultList = resultList;
    }

    public StudioChildFactory(List<INode> resultList, String suffix, boolean showImportMenu, boolean showPosition) {
        this.resultList = resultList;
        this.showImportMenu = showImportMenu;
        if (!((String)suffix).isEmpty() && !((String)suffix).startsWith(" ")) {
            suffix = " " + (String)suffix;
        }
        this.suffix = suffix;
        this.showPosition = showPosition;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in StudioChildFactory");
    }

    protected boolean createKeys(List<INode> list) {
        int i = 1;
        for (INode s : this.resultList) {
            if (s instanceof AbstractEntity) {
                AbstractEntity entity = (AbstractEntity)s;
                entity.setPositionInList(i++);
            }
            list.add(s);
        }
        return true;
    }

    protected Node createNodeForKey(INode node) {
        StudioEntryBeanNode result = null;
        if (node instanceof Studio) {
            Studio studio = (Studio)node;
            LOG.finest("create new node for key. Studio: " + String.valueOf(studio));
            List movies = null;
            if (!studio.getName().equalsIgnoreCase(unknown_studios)) {
                movies = this.db.getMovies(studio, Scenerixx.unlocked);
            } else {
                movies = this.db.getMoviesWithoutStudio(Scenerixx.unlocked);
                studio.setPublicDescription("Placeholder for movies that are not associated to a studio yet");
            }
            try {
                if (studio.getChildren().isEmpty()) {
                    LOG.finer(studio.getName() + " has no children");
                    result = new StudioEntryBeanNode(studio, Children.createLazy((Callable)new CallableMovieChildFactory(movies, false, false, true, false, this.showPosition, false)));
                } else {
                    LOG.finer(studio.getName() + " has " + studio.getChildren().size() + " children");
                    List children = studio.getMoviesAsINode(Scenerixx.unlocked);
                    children.addAll(studio.getChildrenAsINode());
                    Children studioChildren = Children.createLazy((Callable)new CallableStudioChildFactory(children, this.showImportMenu, this.showPosition));
                    result = new StudioEntryBeanNode(studio, studioChildren);
                }
            }
            catch (IntrospectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!studio.getName().equalsIgnoreCase(unknown_studios)) {
                int studiosSize;
                displayName = "";
                displayName = this.suffix.isEmpty() ? ((studiosSize = this.db.getStudios(studio).size()) > 0 ? studio.getName() + " [" + this.db.countMovies(studio, Scenerixx.unlocked) + " + " + studiosSize + " studios]" + this.suffix : studio.getName() + " [" + this.db.countMovies(studio, Scenerixx.unlocked) + "]" + this.suffix) : studio.getName() + " [Scenerixx-file]";
                if (this.showPosition) {
                    LOG.info("studio showpos: " + studio.getPositionInList());
                    displayName = studio.getPositionInList() + ". " + (String)displayName;
                }
                result.setDisplayName((String)displayName);
                result.setValue("studio", studio);
                result.setName(studio.getName());
            } else {
                displayName = "";
                displayName = this.suffix.isEmpty() ? unknown_studios + " [" + this.db.countMoviesWithoutStudios(Scenerixx.unlocked) + "]" + this.suffix : unknown_studios;
                if (this.showPosition) {
                    displayName = studio.getPositionInList() + ". " + (String)displayName;
                }
                result.setDisplayName((String)displayName);
            }
        } else if (node instanceof Movie) {
            Movie movie = (Movie)node;
            LOG.finest("create new node for key. Movie: " + String.valueOf(movie));
            ArrayList<INode> movies = new ArrayList<INode>();
            movies.add((INode)movie);
            MovieChildFactory movieChildFactory = new MovieChildFactory(movies, false, false, false, false, false, false, false, false, false, false, false, false, true, false, this.showPosition, false, false, false, false, false, false, false, false);
            result = movieChildFactory.createNode(movie);
        }
        return result;
    }

    public Node createNode(INode node) {
        return this.createNodeForKey(node);
    }

    public class StudioEntryBeanNode
    extends BeanNode {
        Studio s;

        public StudioEntryBeanNode(Studio bean) throws IntrospectionException {
            super((Object)bean, Children.LEAF, Lookups.singleton((Object)bean));
            this.s = bean;
        }

        public StudioEntryBeanNode(Studio bean, Children children) throws IntrospectionException {
            super((Object)bean, children, Lookups.singleton((Object)bean));
            this.s = bean;
        }

        public Action getPreferredAction() {
            LOG.info("expand studio node");
            return null;
        }

        public Action[] getActions(boolean context) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (StudioChildFactory.this.showImportMenu) {
                if (StudioChildFactory.this.db.getScenerixxSettings().isShowImport()) {
                    list.add(SystemAction.get(ImportStudioAction.class));
                }
            } else {
                list.add(SystemAction.get(CreatePlaylistAction.class));
                if (StudioChildFactory.this.db.getScenerixxSettings().isShowExport()) {
                    list.add(SystemAction.get(ExportStudioAction.class));
                }
                list.add(null);
                list.add((Action)SharedClassObject.findObject(AddToDefaultPlaylistAction.class, (boolean)true));
                list.add((Action)SharedClassObject.findObject(AddToPlaylistAction.class, (boolean)true));
                list.add(null);
                list.add(SystemAction.get(DeleteStudioAction.class));
            }
            Action[] actions = new Action[list.size()];
            actions = list.toArray(actions);
            if (!this.s.getName().equalsIgnoreCase(unknown_studios)) {
                return actions;
            }
            return new Action[0];
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"icons/record.png");
        }

        public PasteType createPasteType(final Transferable t, final int action, AbstractNode nodeToSelectAfterReload) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    Node node = NodeTransfer.node((Transferable)t, (int)action);
                    Node[] nodes = NodeTransfer.nodes((Transferable)t, (int)action);
                    if (node != null && node.getValue("studio") != null && node.getValue("studio") instanceof Studio) {
                        Studio srcStudio = (Studio)node.getValue("studio");
                        LOG.info("pasted person " + srcStudio.getName() + " to " + StudioEntryBeanNode.this.s.getName());
                        if (0 == JOptionPane.showConfirmDialog(null, "Should '" + srcStudio.getName() + "' get merged into '" + StudioEntryBeanNode.this.s.getName() + "'. \n" + srcStudio.getName() + " will be deleted after the merge. This operation cannot be reverted!", "Merge persons?", 1, 2)) {
                            for (Movie m : StudioChildFactory.this.db.getMovies(srcStudio, Scenerixx.unlocked)) {
                                m.setStudio(StudioEntryBeanNode.this.s);
                                m = (Movie)StudioChildFactory.this.db.getEntityService().save((AbstractEntity)m);
                                LOG.info("re-assigend studio");
                            }
                            LOG.info("Replaced " + srcStudio.getName() + " with " + StudioEntryBeanNode.this.s.getName());
                            StudioChildFactory.this.db.getEntityService().delete((AbstractEntity)srcStudio);
                            AbstractTopComponent.notifyInfo("Merged " + srcStudio.getName() + " with " + StudioEntryBeanNode.this.s.getName() + ".");
                        }
                    }
                    StudioChildFactory.this.refresh(true);
                    TopComponent studioListTopComponent = WindowManager.getDefault().findTopComponent("StudioListTopComponent");
                    if (studioListTopComponent != null) {
                        ((StudioListTopComponent)studioListTopComponent).doReloadList(StudioEntryBeanNode.this.s.getName());
                    }
                    return null;
                }
            };
        }

        public PasteType getDropType(Transferable t, int action, int index) {
            return this.createPasteType(t, action, (AbstractNode)this);
        }
    }
}

