/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.upgrade;

import com.querydsl.core.types.dsl.EntityPathBase;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonWebsites;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.StudioWebsites;
import xxx.scenerixx.scenerixxlib.model.enums.SocialWebsites;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class Upgrader {
    private static final Logger LOG = Logger.getLogger(Upgrader.class.getName());
    private boolean internalDb = false;
    private DB db = DB.getInstance();
    final EntityManager entityManager = this.db.getEntityService().getEntityManager();

    public Upgrader() {
        EntityManagerFactory emf = this.entityManager.getEntityManagerFactory();
        Map emfProperties = emf.getProperties();
        String driverClass = (String)emfProperties.get("jakarta.persistence.jdbc.driver");
        LOG.info("Check which driver for the database is used..." + driverClass);
        if (driverClass.toLowerCase().contains("mysql")) {
            LOG.info("Looks like a MySQL / MariaDB");
            this.internalDb = false;
        } else if (driverClass.toLowerCase().contains("hsqldb")) {
            LOG.info("Looks like a HSQLDB");
            this.internalDb = true;
        }
    }

    public static void migratePersonWebsites() {
        DB db = DB.getInstance();
        List find = db.getEntityService().find((EntityPathBase)QPerson.person).find();
        for (Person p : find) {
            PersonWebsites sw;
            if (p.getInstagram() != null && !p.getInstagram().isBlank()) {
                System.out.println("insta");
                sw = new PersonWebsites();
                sw.setPerson(p);
                sw.setSocialWebsite(SocialWebsites.Instagram);
                sw.setUrl(p.getInstagram());
                p.setInstagram("");
                p.getPersonWebsites().add(sw);
            }
            if (p.getIafd() != null && !p.getIafd().isBlank()) {
                System.out.println("iafd");
                sw = new PersonWebsites();
                sw.setPerson(p);
                sw.setSocialWebsite(SocialWebsites.IAFD);
                sw.setUrl(p.getIafd());
                p.setIafd("");
                p.getPersonWebsites().add(sw);
            }
            if (p.getWikipedia() != null && !p.getWikipedia().isBlank()) {
                System.out.println("Wikipedia");
                sw = new PersonWebsites();
                sw.setPerson(p);
                sw.setSocialWebsite(SocialWebsites.Wikipedia);
                sw.setUrl(p.getWikipedia());
                p.setWikipedia("");
                p.getPersonWebsites().add(sw);
            }
            if (p.getOfficialHomepage() != null && !p.getOfficialHomepage().isBlank()) {
                System.out.println("OfficialHomepage");
                sw = new PersonWebsites();
                sw.setPerson(p);
                sw.setSocialWebsite(SocialWebsites.Official);
                sw.setUrl(p.getOfficialHomepage());
                p.setOfficialHomepage("");
                p.getPersonWebsites().add(sw);
            }
            if (p.getTwitter() != null && !p.getTwitter().isBlank()) {
                System.out.println("twitter");
                sw = new PersonWebsites();
                sw.setPerson(p);
                sw.setSocialWebsite(SocialWebsites.X);
                sw.setUrl(p.getTwitter());
                p.setTwitter("");
                p.getPersonWebsites().add(sw);
            }
            if (p.getOtherUrls() != null && !p.getOtherUrls().isBlank()) {
                String[] split;
                System.out.println("other urls");
                for (String s : split = p.getOtherUrls().split("\n")) {
                    System.out.println("--- " + s);
                    PersonWebsites sw2 = new PersonWebsites();
                    sw2.setPerson(p);
                    if (s.toLowerCase().contains("onlyfans.com")) {
                        sw2.setSocialWebsite(SocialWebsites.OnlyFans);
                    } else if (s.toLowerCase().contains("linktr.ee")) {
                        sw2.setSocialWebsite(SocialWebsites.Linktree);
                    } else if (s.toLowerCase().contains("x.com") || s.toLowerCase().contains("twitter.com")) {
                        sw2.setSocialWebsite(SocialWebsites.X);
                    } else {
                        sw2.setSocialWebsite(SocialWebsites.Other);
                    }
                    sw2.setUrl(s);
                    p.getPersonWebsites().add(sw2);
                }
                p.setOtherUrls("");
            }
            db.getEntityService().save((AbstractEntity)p);
        }
    }

    public static void migrateStudioWebsites() {
        DB db = DB.getInstance();
        List find = db.getEntityService().find((EntityPathBase)QStudio.studio).find();
        for (Studio s : find) {
            StudioWebsites sw;
            if (s.getWikipedia() != null && !s.getWikipedia().isBlank()) {
                System.out.println("Wikipedia");
                sw = new StudioWebsites();
                sw.setStudio(s);
                sw.setSocialWebsite(SocialWebsites.Wikipedia);
                sw.setUrl(s.getWikipedia());
                s.setWikipedia("");
                s.getStudioWebsites().add(sw);
            }
            if (s.getHomepage() != null && !s.getHomepage().isBlank()) {
                System.out.println("OfficialHomepage");
                sw = new StudioWebsites();
                sw.setStudio(s);
                sw.setSocialWebsite(SocialWebsites.Official);
                sw.setUrl(s.getHomepage());
                s.setHomepage("");
                s.getStudioWebsites().add(sw);
            }
            if (s.getHomepage2() != null && !s.getHomepage2().isBlank()) {
                System.out.println("OfficialHomepage2");
                sw = new StudioWebsites();
                sw.setStudio(s);
                sw.setSocialWebsite(SocialWebsites.Official);
                sw.setUrl(s.getHomepage());
                s.setHomepage2("");
                s.getStudioWebsites().add(sw);
            }
            if (s.getTwitter() != null && !s.getTwitter().isBlank()) {
                System.out.println("twitter");
                sw = new StudioWebsites();
                sw.setStudio(s);
                sw.setSocialWebsite(SocialWebsites.X);
                sw.setUrl(s.getTwitter());
                s.setTwitter("");
                s.getStudioWebsites().add(sw);
            }
            if (s.getTwitter2() != null && !s.getTwitter2().isBlank()) {
                System.out.println("twitter2");
                sw = new StudioWebsites();
                sw.setStudio(s);
                sw.setSocialWebsite(SocialWebsites.X);
                sw.setUrl(s.getTwitter2());
                s.setTwitter2("");
                s.getStudioWebsites().add(sw);
            }
            if (s.getOtherUrls() != null && !s.getOtherUrls().isBlank()) {
                String[] split;
                System.out.println("other urls");
                for (String ssplit : split = s.getOtherUrls().split("\n")) {
                    System.out.println("--- " + ssplit);
                    StudioWebsites sw2 = new StudioWebsites();
                    sw2.setStudio(s);
                    if (ssplit.toLowerCase().contains("onlyfans.com")) {
                        sw2.setSocialWebsite(SocialWebsites.OnlyFans);
                    } else if (ssplit.toLowerCase().contains("linktr.ee")) {
                        sw2.setSocialWebsite(SocialWebsites.Linktree);
                    } else if (ssplit.toLowerCase().contains("x.com") || ssplit.toLowerCase().contains("twitter.com")) {
                        sw2.setSocialWebsite(SocialWebsites.X);
                    } else {
                        sw2.setSocialWebsite(SocialWebsites.Other);
                    }
                    sw2.setUrl(ssplit);
                    s.getStudioWebsites().add(sw2);
                }
                s.setOtherUrls("");
            }
            db.getEntityService().save((AbstractEntity)s);
        }
    }

    public void moveDirectories() {
        String playlistDirOld = System.getProperty("user.home") + File.separator + "scenerixxplaylists";
        if (Files.exists(Paths.get(playlistDirOld, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            String playlistDirNew = System.getProperty("user.home") + File.separator + "scenerixx" + Scenerixx.scenerixxPlaylistsDir;
            try {
                Files.move(Paths.get(playlistDirOld, new String[0]), Paths.get(playlistDirNew, new String[0]), StandardCopyOption.ATOMIC_MOVE);
                LOG.info("moved '" + playlistDirOld + "' to '" + playlistDirNew + "'");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            LOG.info("old default playlist directory does not existing anymore");
        }
        String screencapDirOld = System.getProperty("user.home") + File.separator + "scenerixxscreencap";
        if (Files.exists(Paths.get(screencapDirOld, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            String screencapDirNew = System.getProperty("user.home") + File.separator + "scenerixx" + Scenerixx.scenerixxScreencapDirNew;
            try {
                Files.move(Paths.get(screencapDirOld, new String[0]), Paths.get(screencapDirNew, new String[0]), StandardCopyOption.ATOMIC_MOVE);
                LOG.info("moved '" + screencapDirOld + "' to '" + screencapDirNew + "'");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            LOG.info("old default screencap diretory was not existing anymore");
        }
        String dataDirOld = System.getProperty("user.home") + Scenerixx.scenerixxDataDirOld;
        if (Files.exists(Paths.get(dataDirOld, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            String dataDirNew = System.getProperty("user.home") + File.separator + "scenerixx" + Scenerixx.scenerixxDataDir;
            if (Files.exists(Paths.get(dataDirNew, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                AbstractTopComponent.notifyError("We cannot move the old data directory (" + dataDirOld + ") to the new one (" + dataDirNew + ") because the new one is not empty. We try to use the new one anyway. Consider deleting the old directory.");
            }
            try {
                Files.move(Paths.get(dataDirOld, new String[0]), Paths.get(dataDirNew, new String[0]), StandardCopyOption.ATOMIC_MOVE);
                LOG.info("moved '" + dataDirOld + "' to '" + dataDirNew + "'");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            LOG.info("old default data directory was not existing anymore");
        }
    }

    public int upgradeData() {
        int updatedRows;
        block62: {
            block61: {
                block60: {
                    block59: {
                        block58: {
                            block57: {
                                if (this.internalDb) {
                                    LOG.info("Make backup before upgrading data.");
                                    try {
                                        String formatDate = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss").format(new Date());
                                        String dest = System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + "backups" + File.separator + formatDate;
                                        Files.createDirectories(Paths.get(dest, new String[0]), new FileAttribute[0]);
                                        ScenerixxCommonLib.copyFolder((Path)Paths.get(System.getProperty("user.home") + Scenerixx.scenerixxDataDir, new String[0]), (Path)Paths.get(dest, new String[0]));
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                        LOG.severe("Could not create backup. Yolo.");
                                    }
                                }
                                LOG.info("Start upgrading data.");
                                updatedRows = 0;
                                try {
                                    if (!this.internalDb) {
                                        LOG.info("Upgrade database 3.0");
                                        updatedRows += this.migrateToVersion3();
                                    }
                                }
                                catch (Exception ex) {
                                    if (!this.entityManager.getTransaction().isActive()) break block57;
                                    LOG.info("Error during upgrading data for version 3.0. " + ex.getMessage());
                                    this.entityManager.getTransaction().rollback();
                                    LOG.info("Transaction was rolled back.");
                                }
                            }
                            try {
                                if (!this.internalDb) {
                                    LOG.info("Upgrade database 3.2");
                                    updatedRows += this.migrateToVersion3_2();
                                }
                            }
                            catch (Exception ex) {
                                if (!this.entityManager.getTransaction().isActive()) break block58;
                                LOG.info("Error during upgrading data for version 3.2. " + ex.getMessage());
                                this.entityManager.getTransaction().rollback();
                                LOG.info("Transaction was rolled back.");
                            }
                        }
                        try {
                            if (!this.internalDb) {
                                LOG.info("Upgrade database 3.3");
                                updatedRows += this.migrateToVersion3_3();
                            }
                        }
                        catch (Exception ex) {
                            if (!this.entityManager.getTransaction().isActive()) break block59;
                            LOG.info("Error during upgrading data for version 3.3. " + ex.getMessage());
                            this.entityManager.getTransaction().rollback();
                            LOG.info("Transaction was rolled back.");
                        }
                    }
                    try {
                        if (!this.internalDb) {
                            LOG.info("Upgrade database 3.5");
                            updatedRows += this.migrateToVersion3_5();
                        }
                    }
                    catch (Exception ex) {
                        if (!this.entityManager.getTransaction().isActive()) break block60;
                        LOG.info("Error during upgrading data for version 3.5. " + ex.getMessage());
                        this.entityManager.getTransaction().rollback();
                        LOG.info("Transaction was rolled back.");
                    }
                }
                try {
                    if (!this.internalDb) {
                        LOG.info("Upgrade database 4.0");
                        updatedRows += this.migrateToVersion4_0();
                    }
                }
                catch (Exception ex) {
                    if (!this.entityManager.getTransaction().isActive()) break block61;
                    LOG.info("Error during upgrading data for version 4.0. " + ex.getMessage());
                    this.entityManager.getTransaction().rollback();
                    LOG.info("Transaction was rolled back.");
                }
            }
            try {
                if (!this.internalDb) {
                    LOG.info("Upgrade database 4.1");
                    updatedRows += this.migrateToVersion4_1();
                }
            }
            catch (Exception ex) {
                if (!this.entityManager.getTransaction().isActive()) break block62;
                LOG.info("Error during upgrading data for version 4.1. " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.3");
                updatedRows += this.migrateToVersion4_3();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.3. " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.3.1");
                updatedRows += this.migrateToVersion4_3_1();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.3.1 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.4.0");
                updatedRows += this.migrateToVersion4_4_0();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.4.0 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.5.0");
                updatedRows += this.migrateToVersion4_5_0();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.5.0 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.6.0");
                updatedRows += this.migrateToVersion4_6_0();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.6.0 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.6.1");
                updatedRows += this.migrateToVersion4_6_1();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.6.1 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.7.0");
                updatedRows += this.migrateToVersion4_7_0();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.7.0 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 4.14.0");
                updatedRows += this.migrateToVersion4_14_0();
            }
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 4.14.0 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            if (!this.internalDb) {
                LOG.info("Upgrade database 5.0.0");
                updatedRows += this.migrateToVersion5_0_0();
            }
            this.migrate_websites_5_0_0();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading data for version 5.0.0 " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        LOG.info("Finished upgrading data. Updated " + updatedRows + " rows.");
        return updatedRows;
    }

    private int migrateToVersion3_2() {
        Query nativeQueryResetOldValues;
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CREAMPIESANAL TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CREAMPIESVAGINAL TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.2). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERSTART INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDEREND INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERTHRESHOLD DOUBLE(10,3)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERDIFFSECONDS INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERLASTX INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERSTARTWITHLONGEST TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERABORTDATE DATETIME");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERCURRENTSECOND INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.2). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion3_3() {
        Query nativeQueryResetOldValues;
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD GOLDENSHOWERCOLOR TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD LOADPERSONSONSTARTUP TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD LOADSTUDIOSONSTARTUP TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD LOADMEDIUMFILESONSTARTUP TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD LOADMOVIESONSTARTUP TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD STARTTIMEPRELUDE INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD ENDTIMEPRELUDE INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD STARTTIMEACTUALCUMSHOT INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD ENDTIMEACTUALCUMSHOT INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD STARTTIMEAFTERMATH INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD ENDTIMEAFTERMATH INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during cumshot fields settings table (version 3.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion3_5() {
        Query nativeQueryResetOldValues;
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENE ADD INCOMPLETE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD YEARDEFUNCT INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD HIGHLIGHT TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading bookmark table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD HIGHLIGHT TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD FAVORITE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BUTTROSE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD GAPING TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD HUMILIATE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE GOLDENSHOWER ADD COLOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE GOLDENSHOWER ADD COLORDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading goldenshower table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDMULTIFILE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDMULTIFILECHARDIFF INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDMULTIFILEMAXFILESPERDIR INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD UNDRESS TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.5). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion3() {
        Query nativeQueryResetOldValues;
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD HORROR TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD MATURE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD GRANNY TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD OLDYOUNG TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CUMWALK TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD PUBLICSEX TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD FUCKMACHINE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD SYBIAN TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD SEARCHONKEYPRESS TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD PUBLICDESCRIPTION LONGTEXT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD TYPE1 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD TYPE2 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD TYPE3 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD TYPE4 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD TYPE5 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD TYPE6 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIO ADD PARENT_ID BIGINT(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CUMSHOTGARGLE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD INTENSITY VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD PAIN VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ROUGHNESS VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD SPEED VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD GOLDENSHOWERGENDERACTIVE VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD GOLDENSHOWERGENDERPASSIVE VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD APPEARANCEUNAPPROACHABLE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD POSITION VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STATISTICINTERNAL ADD MEDIUMFILESWITHSECRETSSIZE BIGINT(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STATISTICINTERNAL ADD MEDIUMFILESWITHOUTSECRETSSIZE BIGINT(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STATISTICINTERNAL ADD BOOKMARKSWITHSECRETS INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STATISTICINTERNAL ADD BOOKMARKSWITHOUTSECRETS INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PLAYLISTENTRY ADD STUDIO_ID BIGINT(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD HIDESCREENCAPSINLOCKEDMODE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CEI TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CHALLENGE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CUMSURPRISE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ENCOURAGEMENT TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD FANTASY TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD TOOLTIPDELAY INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD TOOLTIPRESHOWDELAY INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD AGERANGE VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD MENTIONEDAGE VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ANALPILEDRIVER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ANALREVERSEPILEDRIVER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BIGCOCK TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD FOURSOMES TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ICAME TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD VAGINALPILEDRIVER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD VAGINALREVERSEPILEDRIVER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("CREATE TABLE NODUPLICATE (ID BIGINT NOT NULL AUTO_INCREMENT, CODENAME VARCHAR(255), DATEOFCREATION TIMESTAMP, DATEOFLASTMODIFICATION TIMESTAMP, EXTERNALID BIGINT, MOVIEIDONE BIGINT, MOVIEIDOTHER BIGINT, RATING INTEGER, RATINGDIFFERENTIATOR VARCHAR(255), USERID BIGINT, VERSION VARCHAR(255), PRIMARY KEY (ID))");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 3.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_0() {
        Query nativeQueryResetOldValues;
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD SCATING TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD KISSING TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD TITSTINY TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENE ADD PARTNERCOMPATIBILITYDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CHRISTMAS TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD HALLOWEEN TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD WEDDING TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD POV TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_1() {
        Query nativeQueryResetOldValues;
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ANALONLY TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ANALTOYS TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD NUMBERTSMIN TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD NUMBERTSMAX TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD AGETSMIN1 INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD AGETSMAX1 INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD AGETSMIN2 INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD AGETSMAX2 INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.1). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDAPPLYTAGSONLYWITHPREFIXEDHASH TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDALWAYSASSOCIATEPERSONS TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 4.1). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_3() {
        Query nativeQueryResetOldValues;
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CLASSY TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD MASSAGE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD NATURALTITS TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD FAKETITSMOVIETYPE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG1 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG2 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG3 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG4 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG5 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG6 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG7 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG8 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD USERDEFINEDTAG9 TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG1 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG2 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG3 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG4 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG5 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG6 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG7 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG8 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USERDEFINEDTAG9 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search, scenerixxsettings table (version 4.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE UISTATE ADD MOVIELISTYEAR TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE UISTATE ADD MOVIELISTRESOLUTION TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading uistate table (version 4.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE MOVIE ADD ALTERNATIVETITLE VARCHAR(2048)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE MOVIE ADD OFFICIALURL VARCHAR(2048)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE MOVIE ADD IAFDURL VARCHAR(2048)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading movie table (version 4.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERDATEEND TIMESTAMP");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD DUPFINDERDATESTART TIMESTAMP");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE UISTATE ADD MOVIELISTPLAYLISTTOSHOW_ID BIGINT(19)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scenerixxsettings, uistate table (version 4.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD LOCATION TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDRUNDUPLICATEFINDER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDDUPLICATEFINDERTHRESHOLD DOUBLE");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDDUPLICATEFINDERDIFFINSECONDS INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.3). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_3_1() {
        LOG.info("########## 4.3.1 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            Query nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD RATINGDRESS INTEGER");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD RATINGPERFORMANCE INTEGER");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD RATINGOVERALLAPPEARANCE INTEGER");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD SKINTONEDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD HAIRTYPEDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD PUBICHAIRDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGASSDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGTITSDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGPUSSYDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGFACEDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGSMILEDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGLAUGHDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGEYESDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGVOICEDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGCHARACTERDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGSYMPATHYDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGFEETDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGTEETHDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGDRESSDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGPERFORMANCEDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGOVERALLAPPEARANCEDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGDRESSAPPEARANCE INTEGER");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGPERFORMANCE INTEGER");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD RATINGOVERALLAPPEARANCE INTEGER");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.3.1). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_4_0() {
        Query nativeQueryResetOldValues;
        LOG.info("########## 4.4.0 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE UISTATE ADD PREFIXMETADATA TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENE ADD SHOTINCOUNTRY VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scene table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD ARMPITHAIR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD ARMPITHAIRDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD LEGHAIR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD LEGHAIRDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD BODYHAIR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD BODYHAIRDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD ACCENT VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scene table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD ACCENTDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scene table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE MOVIE ADD SHOTINCOUNTRY VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading scene table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ROW_FORMAT=DYNAMIC");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD ROUGHNESSPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD INTENSITYPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SPEEDPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD PAINPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGACTIVE1 VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD MOANINGPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SCREAMINGPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD TITSBOUNCINGPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DIRTYTALKINTENSITYPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD DOMINATINGPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SUBMISSIVEPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD CUMCOVEREDPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHCAMERAPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERACTIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERACTIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERACTIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERACTIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERACTIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERACTIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERPASSIVE1 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERPASSIVEDIFFERENTIATOR1 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERPASSIVE2 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERPASSIVEDIFFERENTIATOR2 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERPASSIVE3 VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD EYECONTACTWITHPARTNERPASSIVEDIFFERENTIATOR3 VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading bookmark table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD PERSONHEIGHT VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD PERSONHEIGHTDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD HEIGHTINCM INTEGER");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading person table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDRUNDUPLICATEFINDERONLYSELECTEDFOLDER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD WIZARDRUNDUPLICATEFINDERONLYSELECTEDFOLDER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading settings table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ACCENT VARCHAR(50)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ARMPITHAIR VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ARMPITHAIRDIFFERENTIATOR VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BODYHAIR VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BODYHAIRDIFFERENTIATOR VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD LEGHAIR VARCHAR(20)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD LEGHAIRDIFFERENTIATOR VARCHAR(5)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CUMSHOTCUMCOVEREDBLOWINGAFTER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CUMSHOTCUMCOVEREDFUCKINGAFTER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD SHOTINCOUNTRY VARCHAR(50)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD TRASHY TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("CREATE TABLE Bookmark_TOYS (Bookmark_ID bigint(20) DEFAULT NULL, TOYS varchar(255) DEFAULT NULL, KEY FK_Bookmark_TOYS_Bookmark_ID (Bookmark_ID), CONSTRAINT FK_Bookmark_TOYS_Bookmark_ID FOREIGN KEY (Bookmark_ID) REFERENCES BOOKMARK (ID)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading bookmark table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD CUMCOVEREDBLOWINGAFTER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE CUMSHOT ADD CUMCOVEREDFUCKINGAFTER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading cumshot table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("CREATE TABLE ORGASM (\n  ID bigint(20) NOT NULL AUTO_INCREMENT,\n  DATEOFCREATION datetime DEFAULT NULL,\n  DATEOFLASTMODIFICATION datetime DEFAULT NULL,\n  USERID bigint(20) DEFAULT NULL,\n  EXTERNALID bigint(20) DEFAULT NULL,\n  RATING int(11) DEFAULT NULL,\n  RATINGDIFFERENTIATOR VARCHAR(255),\n  BOOKMARK_ID bigint(20) DEFAULT NULL,\n  CODENAME varchar(255) DEFAULT NULL,\n  VERSION varchar(255) DEFAULT NULL, \n  STARTTIMEPRELUDE int(11) DEFAULT NULL,\n  ENDTIMEPRELUDE int(11) DEFAULT NULL,\n  STARTTIMEACTUALORGASM int(11) DEFAULT NULL,\n  ENDTIMEACTUALORGASM int(11) DEFAULT NULL,\n  STARTTIMEAFTERMATH int(11) DEFAULT NULL,\n  ENDTIMEAFTERMATH int(11) DEFAULT NULL,\n  PRIMARY KEY (ID),\n  KEY FK_ORGASM_BOOKMARK_ID (BOOKMARK_ID),\n  CONSTRAINT FK_ORGASM_BOOKMARK_ID FOREIGN KEY (BOOKMARK_ID) REFERENCES BOOKMARK (ID)\n) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading orgasm table (version 4.4.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_5_0() {
        Query nativeQueryResetOldValues;
        LOG.info("########## 4.5.0 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD VR TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.5.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD WIZARDGENERATED TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading person table (version 4.5.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD SLOWMOTION TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.5.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_6_0() {
        Query nativeQueryResetOldValues;
        LOG.info("########## 4.6.0 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD REGRETTABLYAWESOME TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE BOOKMARK ADD SLOWMOTION TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading bookmark table (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD EYECONTACTWITHCAMERA TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD EYECONTACTWITHPARTNER TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BEHINDTHESCENES TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BONUSSCENE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD INCOMPLETE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD SUMMARY TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD INTERCUT TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BOOKMARKPOV TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during upgrading search table (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("CREATE TABLE Movie_MOVIETYPES (Movie_ID BIGINT(20), MOVIETYPES VARCHAR(255))");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during creating table Movie_MOVIETYPES (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("CREATE TABLE Scene_MOVIETYPES (Scene_ID BIGINT(20), MOVIETYPES VARCHAR(255))");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during creating table Movie_MOVIETYPES (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD PUBICHAIRREALLENGTH VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table search (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD PUBICHAIRREALLENGTH VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENEDETAILS ADD PUBICHAIRREALLENGTHDIFFERENTIATOR VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table scenedetails (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD CUMEATING TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table search (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD DEATHYEAR INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD DEATHMONTH INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD DEATHDAY INT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD CAUSEOFDEATH VARCHAR(255)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSON ADD CAUSEOFDEATHCOMMENT LONGTEXT");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table scenedetails (version 4.6.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_6_1() {
        LOG.info("########## 4.6.1 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            Query nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD USEMONOSPACEDFONT TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table scenerixxsettings (version 4.6.1). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_7_0() {
        Query nativeQueryResetOldValues;
        LOG.info("########## 4.7.0 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD BLINDFOLD TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD ELECTRO TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SEARCH ADD FREEUSE TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table search (version 4.7.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD CREATEHISTORYENTRYWHENSTARTEDVIASCREENCAP TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table settings (version 4.7.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD RANDOMPLAYLISTENTRIES TINYINT(1)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table settings (version 4.7.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("-- scenerixx.CHARTPOSITION definition\n\nCREATE TABLE `CHARTPOSITION` (\n  `ID` bigint(20) NOT NULL AUTO_INCREMENT,\n  `CODENAME` varchar(255) DEFAULT NULL,\n  `DATEOFCREATION` datetime DEFAULT NULL,\n  `DATEOFLASTMODIFICATION` datetime DEFAULT NULL,\n  `EXTERNALID` bigint(20) DEFAULT NULL,\n  `POSITION` int(11) DEFAULT NULL,\n  `RATING` int(11) DEFAULT NULL,\n  `RATINGDIFFERENTIATOR` varchar(255) DEFAULT NULL,\n  `TYPE` varchar(255) DEFAULT NULL,\n  `USERID` bigint(20) DEFAULT NULL,\n  `VERSION` varchar(255) DEFAULT NULL,\n  `PERSON_ID` bigint(20) DEFAULT NULL,\n  PRIMARY KEY (`ID`),\n  KEY `FK_CHARTPOSITION_PERSON_ID` (`PERSON_ID`),\n  CONSTRAINT `FK_CHARTPOSITION_PERSON_ID` FOREIGN KEY (`PERSON_ID`) REFERENCES `PERSON` (`ID`)\n) ENGINE=InnoDB AUTO_INCREMENT=66745 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during creating table chartposition (version 4.7.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion4_14_0() {
        LOG.info("########## 4.14.0 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            Query nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD INITIALLIMIT VARCHAR(10)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table settings (version 4.14.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    private int migrateToVersion5_0_0() {
        Query nativeQueryResetOldValues;
        LOG.info("########## 5.0.0 ##########");
        int updatedRows = 0;
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD SCREENCAPSMERGEDWIDTH INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE SCENERIXXSETTINGS ADD SCREENCAPSMERGEDHEIGHT INT(11)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table settings (version 5.0.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("CREATE TABLE PERSONWEBSITES (ID BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1 INCREMENT BY 1) NOT NULL, CODENAME VARCHAR(255), DATEOFCREATION TIMESTAMP, DATEOFLASTMODIFICATION TIMESTAMP, EXTERNALID BIGINT, RATING INTEGER, RATINGDIFFERENTIATOR VARCHAR(255), SOCIALWEBSITE VARCHAR(255), URL VARCHAR(255), USERID BIGINT, VERSION VARCHAR(255), PERSON_ID BIGINT, PRIMARY KEY (ID))");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE PERSONWEBSITES ADD CONSTRAINT FK_PERSONWEBSITES_PERSON_ID FOREIGN KEY (PERSON_ID) REFERENCES PERSON (ID)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during alter table settings (version 5.0.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        try {
            this.entityManager.getTransaction().begin();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("CREATE TABLE STUDIOWEBSITES (ID BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1 INCREMENT BY 1) NOT NULL, CODENAME VARCHAR(255), DATEOFCREATION TIMESTAMP, DATEOFLASTMODIFICATION TIMESTAMP, EXTERNALID BIGINT, RATING INTEGER, RATINGDIFFERENTIATOR VARCHAR(255), SOCIALWEBSITE VARCHAR(255), URL VARCHAR(255), USERID BIGINT, VERSION VARCHAR(255), PERSON_ID BIGINT, PRIMARY KEY (ID))");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            nativeQueryResetOldValues = this.entityManager.createNativeQuery("ALTER TABLE STUDIOWEBSITES ADD CONSTRAINT FK_STUDIOWEBSITES_PERSON_ID FOREIGN KEY (PERSON_ID) REFERENCES STUDIO (ID)");
            updatedRows += nativeQueryResetOldValues.executeUpdate();
            this.entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (this.entityManager.getTransaction().isActive()) {
                LOG.info("Error during creating table studiowebsites (version 5.0.0). " + ex.getMessage());
                this.entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        return updatedRows;
    }

    public void migrate_websites_5_0_0() {
        try {
            LOG.info("migrating person websites");
            Upgrader.migratePersonWebsites();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            LOG.info("migrating studio websites");
            Upgrader.migrateStudioWebsites();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

