/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.FontUIResource;
import org.mindrot.jbcrypt.BCrypt;
import org.openide.LifecycleManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.ScenerixxLib;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.Ethnicity;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.model.statistic.QScenerixxStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.ScenerixxStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxlib.util.Downloader;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.actions.CheckForUpdatesAction;
import xxx.scenerixx.scenerixxmodule.actions.scenerixxhub.StreamingServerAction;
import xxx.scenerixx.scenerixxmodule.options.OptionsPanel;
import xxx.scenerixx.scenerixxmodule.options.PasswordPanel;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.UnzipUtil;
import xxx.scenerixx.scenerixxmodule.util.gui.LookAndFeelAndThemes;
import xxx.scenerixx.scenerixxmodule.windows.indexing.ScenerixxWizardPanel;
import xxx.scenerixx.scenerixxmodule.windows.mediumfile.MediumFileListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.studio.StudioListTopComponent;

public abstract class AbstractTopComponent
extends TopComponent {
    private static final Logger LOG = Logger.getLogger(AbstractTopComponent.class.getName());
    protected static AtomicBoolean initialized = new AtomicBoolean(false);
    protected DB db = DB.getInstance();
    protected PlaylistService ps = new PlaylistService();
    protected boolean fromWithinIDE = false;
    private final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
    private static final NotificationDisplayer notificationDisplayer = NotificationDisplayer.getDefault();
    private static final List<Pair<LocalDateTime, Notification>> notifications = new ArrayList<Pair<LocalDateTime, Notification>>();
    private static List<IPlayablePlaylistItems> clipboard = new ArrayList<IPlayablePlaylistItems>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTopComponent() {
        AbstractTopComponent abstractTopComponent = this;
        synchronized (abstractTopComponent) {
            if (initialized.compareAndSet(false, false)) {
                try {
                    this.db = DB.getInstance();
                    this.ps = new PlaylistService();
                }
                catch (Error ex) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "<html>Problem connecting to the database.<br>Be sure you are running only one instance of Scenerixx and the database is up and running.<br>Scenerixx will terminate now.</html>");
                    LifecycleManager.getDefault().exit(-451);
                    ex.printStackTrace();
                }
                LOG.info("Constructing. Start initializing Scenerixx.");
                ScenerixxSettings settings = this.db.getScenerixxSettings();
                try {
                    LOG.info("Trying to set Look&Feel '" + settings.getLookAndFeel() + "'");
                    LookAndFeelAndThemes.setLookAndFeel(settings.getLookAndFeel());
                    if (UIManager.getLookAndFeel() == null) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    Object editor = UIManager.get("EditorTabDisplayerUI");
                    UIManager.put("ViewTabDisplayerUI", editor);
                    this.setFontSize(settings.getFontSize());
                    LOG.info("Actual Look&Feel :'" + String.valueOf(UIManager.getLookAndFeel()));
                    UIManager.put("nb.diff.added.color", new Color(180, 255, 180));
                    UIManager.put("nb.diff.changed.color", new Color(160, 200, 255));
                    UIManager.put("nb.diff.deleted.color", new Color(255, 160, 180));
                    UIManager.put("nb.diff.applied.color", new Color(180, 255, 180));
                    UIManager.put("nb.diff.notapplied.color", new Color(160, 200, 255));
                    UIManager.put("TabbedPane.selectedBackground", new Color(240, 98, 146));
                    UIManager.put("TabbedPane.hoverColor", new Color(120, 93, 102));
                    UIManager.put("List.selectionInactiveBackground", new Color(0, 93, 130));
                    ToolTipManager.sharedInstance().setInitialDelay(settings.getTooltipDelay());
                    ToolTipManager.sharedInstance().setReshowDelay(settings.getTooltipReshowDelay());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Object screencapDir = settings.getScreencapDirectory();
                if (screencapDir == null) {
                    screencapDir = System.getProperty("user.home") + File.separator + "scenerixx" + Scenerixx.scenerixxScreencapDirNew;
                    AbstractTopComponent.notifyWarning("Screencap directory not specified! Specify one in the options else we use " + (String)screencapDir);
                }
                Scenerixx.scenerixxScreencapDir = screencapDir;
                LOG.info("Scenerixx-screencap directory: " + (String)screencapDir);
                LOG.info("initialize internal statistic");
                if (settings.isCalculateInternalStatisticOnStartup()) {
                    Scenerixx.statisticInternal = this.scenerixxCommon.readStatisticInternalAndSaveCopy();
                } else {
                    StatisticInternal stats = (StatisticInternal)this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{f -> f.dateOfCreation.desc()}).findFirst();
                    if (stats != null) {
                        Scenerixx.statisticInternal = stats;
                    } else {
                        LOG.warning("could not initialize internal statistic");
                    }
                }
                Object playlistDir = settings.getPlaylistDirectory();
                if (playlistDir == null || "".equals(playlistDir)) {
                    playlistDir = System.getProperty("user.home") + File.separator + "scenerixx" + Scenerixx.scenerixxPlaylistsDir;
                    AbstractTopComponent.notifyWarning("Playlist directory not specified! Specify one in the options else we use " + (String)playlistDir);
                }
                Scenerixx.scenerixxPlaylistsDir = playlistDir;
                LOG.info("Scenerixx-playlist directory: " + (String)playlistDir);
                if (settings != null && settings.getActivationKey() != null) {
                    Scenerixx.registered = true;
                    LOG.info("This instance is already registered... Registration key: " + settings.getActivationKey() + " - external user ID: " + settings.getExternalId());
                }
                new ScenerixxLib();
                WindowManager.getDefault().invokeWhenUIReady(() -> {
                    ScenerixxCommon.setSelectedNodesInTitle(-1);
                    this.scenerixxCommon.initPlaylistCache();
                    ScenerixxCommon.getSumSymbol(0);
                    ScenerixxCommon.getColoredHeart(0);
                    ScenerixxCommon.getColoredStar(0);
                    WindowManager.getDefault().getMainWindow().setExtendedState(6);
                    SwingUtilities.invokeLater(() -> {
                        try {
                            for (Frame frame : Frame.getFrames()) {
                                SwingUtilities.updateComponentTreeUI(frame);
                                frame.pack();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                    boolean showNotification = false;
                    Object message = "";
                    if (!settings.isShowDvd()) {
                        message = (String)message + "DVD - ";
                        showNotification = true;
                    }
                    if (!settings.isShowExport()) {
                        message = (String)message + "Export - ";
                        showNotification = true;
                    }
                    if (!settings.isShowImport()) {
                        message = (String)message + "Import - ";
                        showNotification = true;
                    }
                    if (!settings.isShowRare()) {
                        message = (String)message + "Some rarely used flags and some scene types (VR, 3D, etc)\n";
                        showNotification = true;
                    }
                    if (showNotification) {
                        message = "Following features are currently hidden:\n" + (String)message + "You can activate them in the options.";
                        AbstractTopComponent.notify((String)message, ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                    }
                    ImageIO.scanForPlugins();
                });
            }
        }
    }

    public static Notification notifyError(String text) {
        return AbstractTopComponent.notify(text, ImageUtilities.loadImageIcon((String)"icons/Error.png", (boolean)false), "", null, NotificationDisplayer.Priority.HIGH);
    }

    public static Notification notifyWarning(String text) {
        return AbstractTopComponent.notify(text, ImageUtilities.loadImageIcon((String)"icons/Warning.png", (boolean)false), "", null, NotificationDisplayer.Priority.NORMAL);
    }

    public static Notification notifyInfo(String text) {
        return AbstractTopComponent.notify(text, ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
    }

    public static Notification notify(String text, Icon icon, String detailText, String unused2, NotificationDisplayer.Priority prio) {
        Notification notify = notificationDisplayer.notify(text, icon, detailText, null, prio);
        notifications.add((Pair<LocalDateTime, Notification>)Pair.of((Object)LocalDateTime.now(), (Object)notify));
        AbstractTopComponent.purgeNotifications(5);
        return notify;
    }

    public static void purgeNotifications(int removeAfter) {
        ArrayList<Pair<LocalDateTime, Notification>> tmpList = new ArrayList<Pair<LocalDateTime, Notification>>(notifications);
        long maxAge = removeAfter * 1000 * 60;
        for (Pair pair : tmpList) {
            long age = Duration.between((Temporal)pair.first(), LocalDateTime.now()).toMillis();
            if (age < maxAge) continue;
            notifications.remove(pair);
            ((Notification)pair.second()).clear();
        }
    }

    public static JTextPane createInfoPanel(String notification) {
        JTextPane balloon = new JTextPane();
        balloon.setContentType("text/html");
        balloon.setText("<html><body>" + notification.trim() + "</body></html>");
        balloon.setOpaque(true);
        balloon.setEditable(true);
        balloon.setBorder(new EmptyBorder(0, 0, 0, 0));
        balloon.setBackground(new Color(0, 200, 200, 0));
        balloon.addHyperlinkListener(e -> {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
            }
        });
        return balloon;
    }

    private void setFontSize(int fontSize) {
        float multiplier = (float)fontSize / 100.0f;
        UIDefaults defaults = UIManager.getDefaults();
        int i = 0;
        Enumeration e = defaults.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = defaults.get(key);
            if (value instanceof Font) {
                Font font = (Font)value;
                int newSize = Math.round((float)font.getSize() * multiplier);
                if (value instanceof FontUIResource) {
                    defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), newSize));
                } else {
                    defaults.put(key, new Font(font.getName(), font.getStyle(), newSize));
                }
            }
            ++i;
        }
    }

    private void setLogLevelProperty(String s) {
        LOG.info("Try to set log level to " + s);
        if (s.equals("ALL")) {
            System.setProperty("xxx.scenerixx.scenerixxmodule.level", "" + Level.ALL.intValue());
        }
        if (s.equals("FINEST")) {
            System.setProperty("xxx.scenerixx.scenerixxmodule.level", "" + Level.FINEST.intValue());
        }
        if (s.equals("FINER")) {
            System.setProperty("xxx.scenerixx.scenerixxmodule.level", "" + Level.FINER.intValue());
        }
        if (s.equals("FINE")) {
            System.setProperty("xxx.scenerixx.scenerixxmodule.level", "" + Level.FINE.intValue());
        }
        if (s.equals("INFO")) {
            System.setProperty("xxx.scenerixx.scenerixxmodule.level", "" + Level.INFO.intValue());
        }
        if (s.equals("SEVERE")) {
            System.setProperty("xxx.scenerixx.scenerixxmodule.level", "" + Level.SEVERE.intValue());
        }
        if (s.equals("WARNING")) {
            System.setProperty("xxx.scenerixx.scenerixxmodule.level", "" + Level.WARNING.intValue());
        }
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("Could not set log level. An error occured: " + ex.getMessage());
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("Could not set log level. An error occured: " + ex.getMessage());
        }
    }

    private void checkDatabaseRequirements() {
        Studio s;
        Person p;
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown caucasian male]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown caucasian male]", "Placeholder for an unknown caucasian male person");
            p.setEthnicity(Ethnicity.Caucasian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown asian male]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown asian male]", "Placeholder for an unknown asian male person");
            p.setEthnicity(Ethnicity.Asian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown black male]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown black male]", "Placeholder for an unknown black male person");
            p.setEthnicity(Ethnicity.Black);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown latin male]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown latin male]", "Placeholder for an unknown latin male person");
            p.setEthnicity(Ethnicity.Latin);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown male (other ethnicity)]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown male (other ethnicity)]", "Placeholder for an unknown male person (of other ethnicity)");
            p.setEthnicity(Ethnicity.Multi);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (male, caucasian)]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown group (male, caucasian)]", "Placeholder for an unknown group (4 or more persons) of male caucasians");
            p.setEthnicity(Ethnicity.Caucasian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (male, asian)]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown group (male, asian)]", "Placeholder for an unknown group (4 or more persons) of male asians");
            p.setEthnicity(Ethnicity.Asian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (male, black)]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown group (male, black)]", "Placeholder for an unknown group (4 or more persons) of male blacks");
            p.setEthnicity(Ethnicity.Black);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (male, latin)]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown group (male, latin)]", "Placeholder for an unknown group (4 or more persons) of male latins");
            p.setEthnicity(Ethnicity.Latin);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (male, other ethnicity)]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown group (male, other ethnicity)]", "Placeholder for an unknown group (4 or more persons) of males with other ethnicity");
            p.setEthnicity(Ethnicity.Multi);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (male, mixed ethnicity)]")).count() == 0L) {
            p = new Person(Gender.MALE, "[Unknown group (male, mixed ethnicity)]", "Placeholder for an unknown group (4 or more persons) of males with different ethnicity");
            p.setEthnicity(Ethnicity.Multi);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown caucasian female]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown caucasian female]", "Placeholder for an unknown caucasian female person");
            p.setEthnicity(Ethnicity.Caucasian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown asian female]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown asian female]", "Placeholder for an unknown asian female person");
            p.setEthnicity(Ethnicity.Asian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown black female]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown black female]", "Placeholder for an unknown black female person");
            p.setEthnicity(Ethnicity.Black);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown latin female]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown latin female]", "Placeholder for an unknown latin female person");
            p.setEthnicity(Ethnicity.Latin);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown female (other ethnicity)]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown female (other ethnicity)]", "Placeholder for an unknown female person (of other ethnicity)");
            p.setEthnicity(Ethnicity.Multi);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (female, caucasian)]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown group (female, caucasian)]", "Placeholder for an unknown group (4 or more persons) of female caucasians");
            p.setEthnicity(Ethnicity.Caucasian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (female, asian)]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown group (female, asian)]", "Placeholder for an unknown group (4 or more persons) of female asians");
            p.setEthnicity(Ethnicity.Asian);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (female, black)]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown group (female, black)]", "Placeholder for an unknown group (4 or more persons) of female blacks");
            p.setEthnicity(Ethnicity.Black);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (female, latin)]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown group (female, latin)]", "Placeholder for an unknown group (4 or more persons) of female latins");
            p.setEthnicity(Ethnicity.Latin);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (female, other ethnicity)]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown group (female, other ethnicity)]", "Placeholder for an unknown group (4 or more persons) of females with other ethnicity");
            p.setEthnicity(Ethnicity.Multi);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)"[Unknown group (female, mixed ethnicity)]")).count() == 0L) {
            p = new Person(Gender.FEMALE, "[Unknown group (female, mixed ethnicity)]", "Placeholder for an unknown group (4 or more persons) of females with different ethnicity");
            p.setEthnicity(Ethnicity.Multi);
            this.db.getEntityService().save((AbstractEntity)p);
        }
        if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)"[Unknown studio]")).count() == 0L) {
            s = new Studio();
            s.setName("[Unknown studio]");
            s.setPublicDescription("Placeholder for an unknown studio. By setting this studio explicitly you can distinguish between movies where you haven't check the studio yet and those where you don't know the studio.If a movie was obviously not shot professionally you might want to consider using the [No Studio] placeholder.");
            this.db.getEntityService().save((AbstractEntity)s);
        }
        if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)"[No studio]")).count() == 0L) {
            s = new Studio();
            s.setName("[No studio]");
            s.setPublicDescription("A placeholder for movies that were not shot by a studio like e.g. homemade videos, spy cams, public cameras, etc.If the movie was shot professionally but you don't know the studio you might want to consider using the [Unknown studio] placeholder.");
            this.db.getEntityService().save((AbstractEntity)s);
        }
    }

    private void checkJavaVersion() {
        LOG.info("Current Java version: " + System.getProperty("java.version"));
        if (ScenerixxCommon.getJavaVersion() < 21) {
            JOptionPane.showMessageDialog(null, "Scenerixx needs at least Java 21 but you are currently using Java " + System.getProperty("java.version") + ". We are going to exit now.", "Outdated Java version", 0);
            LifecycleManager.getDefault().exit(-9);
        }
    }

    private void checkSoftwareRequirements() {
        String[] tmpParas;
        ArrayList<Object> paras;
        block23: {
            paras = new ArrayList<Object>();
            if (this.db.getScenerixxSettings().getPathToVlc() != null && !this.db.getScenerixxSettings().getPathToVlc().trim().isEmpty()) {
                paras.add(this.db.getScenerixxSettings().getPathToVlc() + "vlc");
                paras.add("--version");
                tmpParas = (String[])paras.toArray(String[]::new);
                try {
                    Runtime.getRuntime().exec(tmpParas);
                }
                catch (IOException ex) {
                    if (ScenerixxCommon.OS.LINUX.equals((Object)ScenerixxCommon.getOS())) {
                        JOptionPane.showMessageDialog(null, "VLC was not found. Download it from http://www.videolan.org/vlc/ or via your packet manager (e.g. apt install vlc) and make sure it's in the classpath or configure the path in the options.", "VLC not found", 0);
                        break block23;
                    }
                    if (ScenerixxCommon.OS.WINDOWS.equals((Object)ScenerixxCommon.getOS())) {
                        if (0 == JOptionPane.showConfirmDialog(null, "VLC was not found. Should we download it for you?\nIf you click no you have to manually install VLC from http://www.videolan.org/vlc/ and make sure it's in the classpath or configure the path in the options.\nDuring the download it seems like Scenerixx is frozen. So please be patient.", "Download VLC?", 0)) {
                            AbstractTopComponent.notifyInfo("Downloading VLC. This may take a while and Scenerixx seems to be frozen. Sorry about that.");
                            if (this.downloadVlc()) {
                                JOptionPane.showMessageDialog(null, "Download was successful and VLC is ready to use.", "VLC is ready to use", 1);
                            } else {
                                JOptionPane.showMessageDialog(null, "Download failed. You might have to set up VLC manually (http://www.videolan.org/vlc/). Sorry.", "Error downloading VLC", 0);
                            }
                        }
                        break block23;
                    }
                    JOptionPane.showMessageDialog(null, "VLC not found. Download it from http://www.videolan.org/vlc/ and make sure it's in the classpath or configure the path in the options.", "VLC not found", 0);
                }
            } else {
                LOG.info("Presence of VLC was not checked because a path to VLC is provided in the settings.\nIf you are having problems please check if the path in the settings is still valid.");
            }
        }
        paras.clear();
        paras.add(this.db.getScenerixxSettings().getPathToMediaInfo() + "mediainfo");
        paras.add("--version");
        tmpParas = paras.toArray(new String[paras.size()]);
        try {
            Runtime.getRuntime().exec(tmpParas);
        }
        catch (IOException ex) {
            if (ScenerixxCommon.OS.LINUX.equals((Object)ScenerixxCommon.getOS())) {
                JOptionPane.showMessageDialog(null, "MediaInfo was not found. Download it from https://mediaarea.net/en/MediaInfo or via your packet manager (e.g. apt install mediainfo) and make sure it's in the classpath or configure the path in the options.", "MediaInfo not found", 0);
            }
            if (ScenerixxCommon.OS.WINDOWS.equals((Object)ScenerixxCommon.getOS())) {
                if (0 == JOptionPane.showConfirmDialog(null, "MediaInfo was not found. Should we download it for you?\n If you click no you have to manually install MediaInfo from https://mediaarea.net/en/MediaInfo and make sure it's in the classpath or configure the path in the options.\nDuring the download it seems like Scenerixx is frozen. So please be patient.", "Download MediaInfo?", 0)) {
                    if (this.downloadMediaInfo()) {
                        JOptionPane.showMessageDialog(null, "Download was successful and MediaInfo is ready to use.", "MediaInfo is ready to use", 1);
                    } else {
                        JOptionPane.showMessageDialog(null, "Download failed. You might have to set up MediaInfo manually (https://mediaarea.net/en/MediaInfo). Sorry.", "Error downloading MediaInfo", 0);
                    }
                }
            }
            JOptionPane.showMessageDialog(null, "MediaInfo was not found. Download it from https://mediaarea.net/en/MediaInfo and make sure it's in the classpath or configure the path in the options.", "MediaInfo not found", 0);
        }
        paras.clear();
        paras.add(this.db.getScenerixxSettings().getPathToFfmpeg() + "ffmpeg");
        paras.add("-version");
        tmpParas = paras.toArray(new String[paras.size()]);
        try {
            Runtime.getRuntime().exec(tmpParas);
        }
        catch (IOException ex) {
            if (ScenerixxCommon.OS.LINUX.equals((Object)ScenerixxCommon.getOS())) {
                JOptionPane.showMessageDialog(null, "FFmpeg was not found. Download it from https://www.ffmpeg.org/ or via your packet manager (e.g. apt install ffmpeg) and make sure it's in the classpath or configure the path in the options.", "FFmpeg not found", 0);
            }
            if (ScenerixxCommon.OS.WINDOWS.equals((Object)ScenerixxCommon.getOS())) {
                if (0 == JOptionPane.showConfirmDialog(null, "FFmpeg was not found. Should we download it for you?\n If you click no you have to manually install FFmpeg from https://www.ffmpeg.org/ and make sure it's in the classpath or configure the path in the options.\nDuring the download it seems like Scenerixx is frozen (for several (3-5) minutes). So please be patient.", "Download FFmpeg?", 0)) {
                    if (this.downloadFfmpeg()) {
                        JOptionPane.showMessageDialog(null, "Download of FFmpeg was successful.", "FFmpeg is ready to use", 1);
                    } else {
                        JOptionPane.showMessageDialog(null, "Download failed. You might have to set up FFmpeg manually (https://www.ffmpeg.org/). Sorry.", "Error downloading FFmpeg", 0);
                    }
                }
            }
            JOptionPane.showMessageDialog(null, "FFmpeg not found. Download it from https://www.ffmpeg.org/ and make sure it's in the classpath or configure the path in the options.", "FFmpeg not found", 0);
        }
    }

    private boolean downloadVlc() {
        LOG.info("Try to download VLC");
        ScenerixxSettings settings = this.db.getScenerixxSettings();
        Object vlcDestDir = settings.getPathToToolsVlc();
        if ((vlcDestDir == null || vlcDestDir != null && ((String)vlcDestDir).isEmpty()) && !new File((String)(vlcDestDir = System.getProperty("user.home") + File.separator + "scenerixxtools" + File.separator + "vlc")).exists()) {
            new File((String)vlcDestDir).mkdirs();
        }
        LOG.info("path to vlc: " + (String)vlcDestDir);
        boolean result = false;
        result = this.downloadVlcBinary((String)vlcDestDir, "vlc-3.0.21", settings, "vlc-3.0.21-win64.zip", "https://get.videolan.org/vlc/last/win64/");
        LOG.info("Download result for VLC-3.0.21: " + result);
        if (!result) {
            result = this.downloadVlcBinary((String)vlcDestDir, "vlc-3.0.21", settings, "vlc-3.0.21-win64.zip", "https://get.videolan.org/vlc/3.0.20/win64/");
            LOG.info("Download result for VLC-3.0.21: " + result);
        }
        return result;
    }

    private boolean downloadVlcBinary(String vlcDestDir, String subDir, ScenerixxSettings settings, String zipFile, String url) {
        boolean result;
        block7: {
            result = false;
            try {
                if (new File(vlcDestDir + File.separator + zipFile).exists()) {
                    LOG.severe("File already exists: " + vlcDestDir + File.separator + zipFile + " Abort download");
                    break block7;
                }
                if (Downloader.download((String)(url + zipFile), (String)(vlcDestDir + File.separator + zipFile))) {
                    LOG.info("Download was successful. Unzip now.");
                    UnzipUtil unzip = new UnzipUtil();
                    unzip.unzip(vlcDestDir + File.separator + zipFile, vlcDestDir);
                    LOG.info("Unzipped to '" + vlcDestDir + "'. Check if we can execute VLC.");
                    ArrayList<Object> paras = new ArrayList<Object>();
                    paras.clear();
                    paras.add(vlcDestDir + File.separator + subDir + File.separator + "vlc");
                    paras.add("--version");
                    String[] tmpParas = paras.toArray(new String[paras.size()]);
                    try {
                        Runtime.getRuntime().exec(tmpParas);
                        result = true;
                        LOG.info("Successfully executed: " + result);
                        if (settings.getPathToVlc() == null || settings.getPathToVlc() != null && settings.getPathToVlc().isEmpty()) {
                            settings.setPathToToolsVlc(vlcDestDir + File.separator + subDir + File.separator);
                            settings.setPathToVlc(vlcDestDir + File.separator + subDir + File.separator);
                            this.db.getEntityService().save((AbstractEntity)settings);
                            LOG.info("Saved path to VLC: " + vlcDestDir + File.separator + subDir + File.separator);
                        }
                        break block7;
                    }
                    catch (IOException ex) {
                        LOG.info("VLC could not be found: " + ex.getMessage());
                    }
                    break block7;
                }
                LOG.info("Download of VLC failed");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    public boolean downloadFfmpeg() {
        boolean result;
        block10: {
            LOG.info("Try to download FFmpeg");
            result = false;
            ScenerixxSettings settings = this.db.getScenerixxSettings();
            Object ffmpegDestDir = settings.getPathToToolsFfmpeg();
            LOG.info("ffmpeg directory from settings: " + (String)ffmpegDestDir);
            if (ffmpegDestDir == null || ffmpegDestDir != null && ((String)ffmpegDestDir).isEmpty()) {
                LOG.info("ffmpeg directory is not valid. Try to create new one");
                ffmpegDestDir = System.getProperty("user.home") + File.separator + "scenerixxtools" + File.separator + "ffmpeg";
                LOG.info("New name: " + (String)ffmpegDestDir);
            }
            if (!new File((String)ffmpegDestDir).exists()) {
                new File((String)ffmpegDestDir).mkdirs();
                LOG.info("ffmpeg directory created");
            } else {
                LOG.info("directory already exists");
            }
            LOG.info("path to ffmpeg: " + (String)ffmpegDestDir);
            try {
                String ffmpegZipFile = "ffmpeg-release-essentials.zip ";
                URL oracle = new URL("https://www.gyan.dev/ffmpeg/builds/release-version");
                BufferedReader in = new BufferedReader(new InputStreamReader(oracle.openStream()));
                String inputLine = in.readLine();
                in.close();
                String ffmpegZipFileSubDir = "ffmpeg-" + inputLine + "-essentials_build";
                if (new File((String)ffmpegDestDir + File.separator + ffmpegZipFile).exists()) {
                    LOG.severe("File already exists: " + (String)ffmpegDestDir + File.separator + ffmpegZipFile + " Abort download");
                    break block10;
                }
                if (Downloader.downloadWithUserAgent((String)"https://www.gyan.dev/ffmpeg/builds/ffmpeg-release-essentials.zip", (String)((String)ffmpegDestDir + File.separator + ffmpegZipFile))) {
                    LOG.info("Download was successful. Unzip now.");
                    UnzipUtil unzip = new UnzipUtil();
                    unzip.unzip((String)ffmpegDestDir + File.separator + ffmpegZipFile, (String)ffmpegDestDir);
                    LOG.info("Unzipped to '" + (String)ffmpegDestDir + "'. Check if FFmpeg can be executed.");
                    ArrayList<Object> paras = new ArrayList<Object>();
                    paras.clear();
                    paras.add((String)ffmpegDestDir + File.separator + ffmpegZipFileSubDir + File.separator + "bin" + File.separator + "ffmpeg");
                    paras.add("-version");
                    String[] tmpParas = paras.toArray(new String[paras.size()]);
                    try {
                        Runtime.getRuntime().exec(tmpParas);
                        result = true;
                        LOG.info("FFmpeg successfuly executed.");
                        if (settings.getPathToFfmpeg() == null || settings.getPathToFfmpeg() != null && settings.getPathToFfmpeg().isEmpty()) {
                            settings.setPathToToolsFfmpeg((String)ffmpegDestDir + File.separator + ffmpegZipFileSubDir + File.separator + "bin" + File.separator);
                            settings.setPathToFfmpeg((String)ffmpegDestDir + File.separator + ffmpegZipFileSubDir + File.separator + "bin" + File.separator);
                            settings = (ScenerixxSettings)this.db.getEntityService().save((AbstractEntity)settings);
                            this.db.evictCache(ScenerixxSettings.class);
                            LOG.info("Saved path to FFmpeg: " + (String)ffmpegDestDir + File.separator + ffmpegZipFile + File.separator + "bin" + File.separator);
                        }
                        break block10;
                    }
                    catch (IOException ex) {
                        LOG.info("FFmpeg could not be found: " + ex.getMessage());
                    }
                    break block10;
                }
                LOG.info("Download of FFmpeg failed");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    private boolean downloadMediaInfo() {
        boolean result;
        block8: {
            LOG.info("Try to download MediaInfo");
            result = false;
            ScenerixxSettings settings = this.db.getScenerixxSettings();
            Object mediainfoDestDir = settings.getPathToToolsMediainfo();
            if ((mediainfoDestDir == null || mediainfoDestDir != null && ((String)mediainfoDestDir).isEmpty()) && !new File((String)(mediainfoDestDir = System.getProperty("user.home") + File.separator + "scenerixxtools" + File.separator + "mediainfo")).exists()) {
                new File((String)mediainfoDestDir).mkdirs();
            }
            LOG.info("path to mediainfo: " + (String)mediainfoDestDir);
            try {
                String mediaInfo_downloadfile_name = "MediaInfo_CLI_25.04_Windows_x64.zip";
                if (new File((String)mediainfoDestDir + File.separator + "MediaInfo_CLI_25.04_Windows_x64.zip").exists()) {
                    LOG.severe("File already exists: " + (String)mediainfoDestDir + File.separator + "MediaInfo_CLI_25.04_Windows_x64.zip Abort download");
                    break block8;
                }
                if (Downloader.download((String)"https://mediaarea.net/download/binary/mediainfo/25.04/MediaInfo_CLI_25.04_Windows_x64.zip", (String)((String)mediainfoDestDir + File.separator + "MediaInfo_CLI_22.12_Windows_x64.zip"))) {
                    LOG.info("Download was successful. Unzip now.");
                    UnzipUtil unzip = new UnzipUtil();
                    unzip.unzip((String)mediainfoDestDir + File.separator + "MediaInfo_CLI_25.04_Windows_x64.zip", (String)mediainfoDestDir);
                    LOG.info("Unzipped to '" + (String)mediainfoDestDir + "'. Check if we can execute MediaInfo.");
                    ArrayList<Object> paras = new ArrayList<Object>();
                    paras.clear();
                    paras.add((String)mediainfoDestDir + File.separator + "mediainfo");
                    paras.add("-version");
                    String[] tmpParas = (String[])paras.toArray(String[]::new);
                    try {
                        Runtime.getRuntime().exec(tmpParas);
                        result = true;
                        LOG.info("MediaInfo successfully executed.");
                        if (settings.getPathToMediaInfo() == null || settings.getPathToMediaInfo() != null && settings.getPathToMediaInfo().isEmpty()) {
                            settings.setPathToToolsMediainfo((String)mediainfoDestDir + File.separator);
                            settings.setPathToMediaInfo((String)mediainfoDestDir + File.separator);
                            this.db.getEntityService().save((AbstractEntity)settings);
                            LOG.info("Saved path to MediaInfo: " + (String)mediainfoDestDir + File.separator);
                        }
                        break block8;
                    }
                    catch (IOException ex) {
                        LOG.info("Mediainfo could not be found: " + ex.getMessage());
                    }
                    break block8;
                }
                LOG.info("Download of mediainfo failed");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    public static void checkScenerixxFileFolderStructure(String exportBase) {
        LOG.info("Check folder structure:");
        LOG.info("Export base: " + exportBase);
        LOG.info("temp: " + System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + Scenerixx.scenerixxTempDir);
        LOG.info("Studio directory: " + exportBase + Scenerixx.scenerixxFilesDirStudio);
        LOG.info("Playlist directory: " + Scenerixx.scenerixxPlaylistsDir);
        LOG.info("Movies directory: " + exportBase + Scenerixx.scenerixxFilesDirMovies);
        LOG.info("Persons directory: " + exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsFemale);
        LOG.info("Persons directory: " + exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsMale);
        LOG.info("Persons directory: " + exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsTS);
        LOG.info("screencap directory: " + Scenerixx.scenerixxScreencapDir);
        LOG.info("screencap scene directory: " + Scenerixx.scenerixxScreencapDir + File.separator + "scene");
        if (!(new File(exportBase).exists() && new File(exportBase + Scenerixx.scenerixxFilesDirStudio).exists() && new File(System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + Scenerixx.scenerixxTempDir).exists() && new File(Scenerixx.scenerixxPlaylistsDir).exists() && new File(exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsFemale).exists() && new File(exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsMale).exists() && new File(exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsTS).exists() && new File(exportBase + Scenerixx.scenerixxFilesDirMovies).exists() && new File(Scenerixx.scenerixxScreencapDir).exists() && new File(Scenerixx.scenerixxScreencapDir + File.separator + "scene").exists())) {
            new File(exportBase + Scenerixx.scenerixxFilesDirStudio).mkdirs();
            new File(System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + Scenerixx.scenerixxTempDir).mkdirs();
            new File(Scenerixx.scenerixxPlaylistsDir).mkdirs();
            new File(exportBase + Scenerixx.scenerixxFilesDirMovies).mkdirs();
            new File(exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsFemale).mkdirs();
            new File(exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsMale).mkdirs();
            new File(exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsTS).mkdirs();
            new File(Scenerixx.scenerixxScreencapDir + File.separator + "scene").mkdirs();
            AbstractTopComponent.notify("Export-directories for Scenerixx-files created!", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
            LOG.info("Export-directories for Scenerixx-files created. Base: " + exportBase);
            LOG.info("Temp directory: " + exportBase + Scenerixx.scenerixxTempDir);
            LOG.info("Studio directory: " + exportBase + Scenerixx.scenerixxFilesDirStudio);
            LOG.info("Playlist directory: " + Scenerixx.scenerixxPlaylistsDir);
            LOG.info("Movies directory: " + exportBase + Scenerixx.scenerixxFilesDirMovies);
            LOG.info("Persons directory: " + exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsFemale);
            LOG.info("Persons directory: " + exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsMale);
            LOG.info("Persons directory: " + exportBase + Scenerixx.scenerixxFilesDirPersons + Scenerixx.scenerixxFilesDirPersonsTS);
            LOG.info("screencap directory: " + Scenerixx.scenerixxScreencapDir);
            LOG.info("screencap scene directory: " + Scenerixx.scenerixxScreencapDir + File.separator + "scene");
        }
        Scenerixx.scenerixxFilesExportDirBase = exportBase;
    }

    public synchronized void componentOpened() {
        if (initialized.compareAndSet(false, true)) {
            LOG.info("Component opened. Start initializing Scenerixx.");
            ScenerixxSettings settings = this.db.getScenerixxSettings();
            Preferences pref = NbPreferences.forModule(OptionsPanel.class);
            this.checkPassword(settings.getStartPassword());
            String name = pref.get("logLevel", "FINE");
            this.setLogLevelProperty(name);
            pref.addPreferenceChangeListener(evt -> {
                if (evt.getKey().equals("logLevel")) {
                    LOG.info("Log-level preference changed: " + evt.getNewValue());
                    this.setLogLevelProperty(evt.getNewValue());
                }
            });
            String executionPath = System.getProperty("user.dir");
            LOG.info("Executing at =>" + executionPath);
            Object path = executionPath.replace("\\", "/");
            LOG.info("Executing at =>" + (String)path);
            if (Scenerixx.scenerixxFilesDirBase.length() <= Scenerixx.scenerixxFilesDirBaseInitValue.length() && !((String)path).contains("NetBeansProject")) {
                try {
                    LOG.info("Started outside IDE");
                    path = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
                    LOG.fine("New path: " + (String)path);
                    path = ScenerixxCommon.getOS().equals((Object)ScenerixxCommon.OS.WINDOWS) ? ((String)path).substring("file:/".length(), ((String)path).length() - "scenerixx/modules/xxx-scenerixx-ScenerixxModule.jar!/".length()) : ((String)path).substring("file:".length(), ((String)path).length() - "scenerixx/modules/xxx-scenerixx-ScenerixxModule.jar!/".length());
                    Scenerixx.scenerixxFilesDirBase = path = (String)path + "scenerixxfiles/";
                    LOG.fine("New path 2: " + (String)path);
                }
                catch (Exception ex) {
                    LOG.severe("Could not determine scenerixxfiles-path from " + (String)path);
                }
            } else if (Scenerixx.scenerixxFilesDirBase.length() <= Scenerixx.scenerixxFilesDirBaseInitValue.length() && ((String)path).contains("NetBeansProject")) {
                LOG.fine("Started from IDE");
                this.fromWithinIDE = true;
                try {
                    URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(Scenerixx.scenerixxFilesDirBase + "/");
                    Scenerixx.scenerixxFilesDirBase = resource.getFile();
                    LOG.info("Current: " + Scenerixx.scenerixxFilesDirBase);
                    if (Scenerixx.scenerixxFilesDirBase.contains("ScenerixxModule/target/classes")) {
                        Scenerixx.scenerixxFilesDirBase = Scenerixx.scenerixxFilesDirBase.replace("ScenerixxModule/target/classes", "application/target/scenerixx");
                        LOG.info("Replaced: " + Scenerixx.scenerixxFilesDirBase);
                    }
                }
                catch (Exception ex) {
                    LOG.severe("Could not determine scenerixxfiles-path from classloader");
                }
            }
            LOG.info("Scenerixx-files base directory...: " + Scenerixx.scenerixxFilesDirBase);
            if (Scenerixx.scenerixxFilesDirBase.length() <= Scenerixx.scenerixxFilesDirBaseInitValue.length()) {
                String nbPath = System.getProperty("netbeans.dirs");
                LOG.fine("NB directory: " + nbPath);
                String[] split = null;
                ScenerixxCommon.OS os = ScenerixxCommon.getOS();
                split = os != null && os == ScenerixxCommon.OS.WINDOWS && nbPath.contains(";") ? nbPath.split(";") : nbPath.split(":");
                for (String s : split) {
                    if (!s.contains("scenerixxfiles")) continue;
                    Scenerixx.scenerixxFilesDirBase = s;
                    LOG.info("Set Scenerixx-files base directory to: " + Scenerixx.scenerixxFilesDirBase);
                    break;
                }
            }
            if (Scenerixx.scenerixxFilesDirBase.length() <= Scenerixx.scenerixxFilesDirBaseInitValue.length()) {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "Could not determine scenerixxfiles directory.", "Error", 0));
            }
            SwingUtilities.invokeLater(() -> {
                ScenerixxStatistic scenerixxStat;
                LOG.info("Scenerixx-files base directory for import files: " + Scenerixx.scenerixxFilesDirBase);
                Object exportBaseDir = settings.getExportDirectory();
                LOG.info("Saved export base dir: " + (String)exportBaseDir);
                if (exportBaseDir == null || ((String)exportBaseDir).isBlank()) {
                    exportBaseDir = System.getProperty("user.home") + File.separator + "scenerixx" + Scenerixx.scenerixxFilesExportDirBase;
                }
                LOG.info("Scenerixx-files export base directory1: " + (String)exportBaseDir);
                Scenerixx.scenerixxServerPath = Scenerixx.scenerixxFilesDirBase.replace("scenerixxfiles", "server");
                LOG.info("Path to server app: " + Scenerixx.scenerixxServerPath);
                AbstractTopComponent.checkScenerixxFileFolderStructure((String)exportBaseDir);
                this.openHelpIfNecessaryAndCloseBrowserInstances();
                LocalDateTime now = LocalDateTime.now();
                this.checkJavaVersion();
                LOG.info("finished for Java version in " + Duration.between(LocalDateTime.now(), now).toString());
                now = LocalDateTime.now();
                this.checkSoftwareRequirements();
                LOG.info("finished check for requirements in " + Duration.between(LocalDateTime.now(), now).toString());
                now = LocalDateTime.now();
                this.checkDatabaseRequirements();
                LOG.info("finished for database requirements in " + Duration.between(LocalDateTime.now(), now).toString());
                now = LocalDateTime.now();
                if (settings.isLoadPersonsOnStartup()) {
                    this.choosePersonOfTheDay();
                    LOG.info("finished person of the day in " + Duration.between(LocalDateTime.now(), now).toString());
                }
                if ((scenerixxStat = (ScenerixxStatistic)this.db.getEntityService().find((EntityPathBase)QScenerixxStatistic.scenerixxStatistic).findFirst()) != null && scenerixxStat.getStarted().size() == 1) {
                    Scenerixx.firstRun = true;
                }
                if (Scenerixx.firstRun) {
                    JOptionPane.showMessageDialog(null, "This is the first time you are running Scenerixx. Please take some time to read the documentation since not everything is intuitive.\n\nTo help you get started we will start the Scenerixx Wizard after this dialog. You just need to choose the directory where your collection is stored and be patient. Scenerixx takes care of the rest.\n\nHave fun.", "Welcome", 1);
                    JDialog frame = new JDialog((Frame)null, "Scenerixx Wizard", true);
                    frame.getContentPane().add(new ScenerixxWizardPanel());
                    frame.pack();
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                }
                if (settings.isStartServerOnStartup()) {
                    new StreamingServerAction().actionPerformed(null);
                }
                if (settings.isCheckUpdatesOnStartup()) {
                    new CheckForUpdatesAction(false).actionPerformed(null);
                }
            });
        }
    }

    private void choosePersonOfTheDay() {
        Person randomPerson;
        List persons = this.db.getPersons(Gender.FEMALE, false, false);
        Random rnd = new Random();
        TopComponent personListTopComponent = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
        if (personListTopComponent != null && !persons.isEmpty() && (randomPerson = (Person)persons.get(rnd.nextInt(persons.size()))) != null) {
            ((PersonListTopComponent)personListTopComponent).selectPersonNode(randomPerson.getName());
            TopComponent detailsTC = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (detailsTC != null) {
                ((DetailsTopComponent)detailsTC).getPersonDetailsPanel().loadForm(randomPerson);
            }
        }
    }

    public void openHelpIfNecessaryAndCloseBrowserInstances() {
        SwingUtilities.invokeLater(() -> {
            Timer timer2 = new Timer(5000, evt -> {
                for (Mode m : WindowManager.getDefault().getModes()) {
                    TopComponent[] openedTopComponents;
                    if (!m.getName().equals("editor")) continue;
                    for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(m)) {
                        if (tc.getName() == null || !tc.getName().equals("Web Browser") && !tc.getName().equals("Changelog") && !tc.getName().equals("Help")) continue;
                        boolean closeResult = tc.close();
                        LOG.fine("Trying to close web browser instance from previous session. Result: " + closeResult);
                    }
                }
                ScenerixxSettings settings = this.db.getScenerixxSettings();
                if (settings.isShowHelpOnStartup()) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(AbstractTopComponent.class.getResource("/help/help.html"));
                }
                if (Scenerixx.upgradedToNewVersion) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(AbstractTopComponent.class.getResource("/changelog/changelog.html"));
                }
            });
            timer2.setRepeats(false);
            timer2.start();
        });
    }

    private void checkPassword(String password) throws HeadlessException {
        String storedPassword;
        if (password == null) {
            password = "";
        }
        if (!(storedPassword = password).isEmpty()) {
            final PasswordPanel pPnl = new PasswordPanel();
            JOptionPane op = new JOptionPane(pPnl, 2, -1);
            JDialog dlg = op.createDialog("You need to provide your password to startup this application");
            dlg.setVisible(true);
            dlg.addWindowFocusListener(new WindowAdapter(this){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    pPnl.gainedFocus();
                }
            });
            if (op.getValue() != null && op.getValue().equals(0)) {
                String enteredpassword = new String(pPnl.getPassword());
                if (BCrypt.checkpw((String)enteredpassword, (String)storedPassword)) {
                    JOptionPane.showMessageDialog(null, "Password was correct. Have fun :)");
                } else {
                    JOptionPane.showMessageDialog(null, "Password did not match. Exiting.");
                    LifecycleManager.getDefault().exit();
                }
            } else {
                LifecycleManager.getDefault().exit();
            }
        }
    }

    protected void addToDefaultPlaylist(Node[] nodes) {
        this.scenerixxCommon.addToDefaultPlaylist(nodes);
        this.reloadPlaylist(this.ps.getDefaultPlaylist(Scenerixx.unlocked));
    }

    public void componentClosed() {
    }

    public static void reloadMovieList() {
        AbstractTopComponent.reloadMovieList(false);
    }

    public static void reloadMovieList(boolean refocus) {
        SwingUtilities.invokeLater(() -> {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                if (refocus) {
                    ((MovieListTopComponent)movieList).reloadListAndRefocus();
                } else {
                    ((MovieListTopComponent)movieList).reloadList();
                }
            }
        });
    }

    public static void dirtyMovieList() {
        SwingUtilities.invokeLater(() -> {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            if (movieList != null) {
                ((MovieListTopComponent)movieList).setDirty();
            }
        });
    }

    protected void reloadPersonDetails(Person p) {
        SwingUtilities.invokeLater(() -> {
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                ((DetailsTopComponent)details).getPersonDetailsPanel().loadForm(p);
            }
        });
    }

    public static void reloadMediumFileList() {
        SwingUtilities.invokeLater(() -> {
            TopComponent mediumfilelist = WindowManager.getDefault().findTopComponent("MediumFileListTopComponent");
            if (mediumfilelist != null && mediumfilelist instanceof MediumFileListTopComponent) {
                MediumFileListTopComponent mf = (MediumFileListTopComponent)mediumfilelist;
                mf.reloadList();
            }
        });
    }

    public static void reloadPersonList() {
        AbstractTopComponent.reloadPersonList(false);
    }

    public static void reloadPersonList(boolean showScenerixxFiles) {
        SwingUtilities.invokeLater(() -> {
            TopComponent personlistTC = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
            if (personlistTC != null && personlistTC instanceof PersonListTopComponent) {
                PersonListTopComponent personList = (PersonListTopComponent)personlistTC;
                personList.reloadList(showScenerixxFiles);
            }
        });
    }

    public static void reloadPersonList(String personName) {
        SwingUtilities.invokeLater(() -> {
            TopComponent personlistTC = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
            if (personlistTC != null && personlistTC instanceof PersonListTopComponent) {
                PersonListTopComponent personList = (PersonListTopComponent)personlistTC;
                personList.reloadList(personName);
            }
        });
    }

    public static void reloadStudioList() {
        SwingUtilities.invokeLater(() -> {
            TopComponent studiolistTC = WindowManager.getDefault().findTopComponent("StudioListTopComponent");
            if (studiolistTC != null && studiolistTC instanceof StudioListTopComponent) {
                StudioListTopComponent studioList = (StudioListTopComponent)studiolistTC;
                studioList.reloadList();
            }
        });
    }

    public static void dirtyMediumFileList() {
        SwingUtilities.invokeLater(() -> {
            TopComponent mediumFileList = WindowManager.getDefault().findTopComponent("MediumFileListTopComponent");
            if (mediumFileList != null) {
                ((MediumFileListTopComponent)mediumFileList).setDirty();
            }
        });
    }

    public static void reloadMediumFileList(Node n) {
        SwingUtilities.invokeLater(() -> {
            TopComponent mediumFileList = WindowManager.getDefault().findTopComponent("MediumFileListTopComponent");
            if (mediumFileList != null) {
                ((MediumFileListTopComponent)mediumFileList).reloadList(n);
            }
        });
    }

    public static void dirtyPersonList() {
        SwingUtilities.invokeLater(() -> {
            TopComponent personList = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
            if (personList != null) {
                ((PersonListTopComponent)personList).setDirty();
            }
        });
    }

    protected void reloadDetails(Movie movie) {
        SwingUtilities.invokeLater(() -> {
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                ((DetailsTopComponent)details).loadMovie(movie);
            }
        });
    }

    protected void reloadDetails(Scene scene) {
        SwingUtilities.invokeLater(() -> {
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                ((DetailsTopComponent)details).loadScene(scene);
            }
        });
    }

    protected void reloadDetails(Bookmark bookmark) {
        SwingUtilities.invokeLater(() -> {
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                ((DetailsTopComponent)details).loadBookmark(bookmark);
            }
        });
    }

    public static void dirtyPlaylist() {
        SwingUtilities.invokeLater(() -> {
            TopComponent playlistTC = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
            if (playlistTC != null) {
                ((PlaylistTopComponent)playlistTC).setDirty();
            }
        });
    }

    public static void reloadPlaylist() {
        AbstractTopComponent.reloadPlaylist((String)null);
    }

    protected void reloadPlaylist(Playlist playlist) {
        if (playlist == null) {
            AbstractTopComponent.reloadPlaylist((String)null);
        } else {
            AbstractTopComponent.reloadPlaylist(playlist.getName());
        }
    }

    public static void reloadPlaylist(Node playlistNode) {
        SwingUtilities.invokeLater(() -> {
            TopComponent playlist = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
            if (playlist != null) {
                ((PlaylistTopComponent)playlist).reloadList(playlistNode.getParentNode());
            }
        });
    }

    public static void reloadPlaylist(String playlistName) {
        SwingUtilities.invokeLater(() -> {
            TopComponent playlistTC = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
            if (playlistTC != null) {
                if (playlistName == null) {
                    ((PlaylistTopComponent)playlistTC).reloadList();
                } else {
                    ((PlaylistTopComponent)playlistTC).reloadList(playlistName);
                }
            }
        });
    }

    protected void reloadStudiolist() {
        SwingUtilities.invokeLater(() -> {
            TopComponent studioList = WindowManager.getDefault().findTopComponent("StudioListTopComponent");
            if (studioList != null) {
                ((StudioListTopComponent)studioList).reloadList();
            }
        });
    }

    public static void dirtyStudiolist() {
        SwingUtilities.invokeLater(() -> {
            TopComponent studioList = WindowManager.getDefault().findTopComponent("StudioListTopComponent");
            if (studioList != null) {
                ((StudioListTopComponent)studioList).setDirty();
            }
        });
    }

    public static void clearClipboard() {
        clipboard.clear();
    }

    protected void clipboard(IPlayablePlaylistItems playable) {
        clipboard.add(playable);
        int i = 0;
        for (IPlayablePlaylistItems p : clipboard) {
            p.setPositionInList(++i);
        }
    }

    public static void removeFromClipboard(IPlayablePlaylistItems playableToRemove) {
        if (playableToRemove instanceof PlaylistEntry) {
            PlaylistEntry peToRemove = (PlaylistEntry)playableToRemove;
            LOG.info("clipboard: " + clipboard.size());
            if (playableToRemove.getId() == null) {
                ArrayList tmpClipboardList = new ArrayList();
                tmpClipboardList.addAll(clipboard);
                clipboard.clear();
                Iterator<Object> iterator = tmpClipboardList.iterator();
                while (iterator.hasNext()) {
                    IPlayablePlaylistItems p = (IPlayablePlaylistItems)iterator.next();
                    if (peToRemove.getBookmark() != null) {
                        if (peToRemove.getBookmark().getId().longValue() == p.getId().longValue()) {
                            LOG.info("MATCH bookmark: " + p.getId());
                            continue;
                        }
                        LOG.info("No match bookmark: " + p.getId());
                        clipboard.add(p);
                    }
                    if (peToRemove.getScene() != null) {
                        if (peToRemove.getScene().getId().longValue() == p.getId().longValue()) {
                            LOG.info("MATCH scene: " + p.getId());
                            continue;
                        }
                        LOG.info("No match scene: " + p.getId());
                        clipboard.add(p);
                    }
                    if (peToRemove.getMovie() != null) {
                        if (peToRemove.getMovie().getId().longValue() == p.getId().longValue()) {
                            LOG.info("MATCH movie: " + p.getId());
                            continue;
                        }
                        LOG.info("No match movie: " + p.getId());
                        clipboard.add(p);
                    }
                    if (peToRemove.getStudio() != null) {
                        if (peToRemove.getStudio().getId().longValue() == p.getId().longValue()) {
                            LOG.info("MATCH studio: " + p.getId());
                            continue;
                        }
                        LOG.info("No match studio: " + p.getId());
                        clipboard.add(p);
                    }
                    if (peToRemove.getPerson() != null) {
                        if (peToRemove.getPerson().getId().longValue() == p.getId().longValue()) {
                            LOG.info("MATCH person: " + p.getId());
                            continue;
                        }
                        LOG.info("No match person: " + p.getId());
                        clipboard.add(p);
                    }
                    if (peToRemove.getMediumFile() == null) continue;
                    if (peToRemove.getMediumFile().getId().longValue() == p.getId().longValue()) {
                        LOG.info("MATCH MediumFile: " + p.getId());
                        continue;
                    }
                    LOG.info("No match MediumFile: " + p.getId());
                    clipboard.add(p);
                }
            }
            for (IPlayablePlaylistItems p : clipboard) {
                LOG.info(p.getId() + " - ");
            }
            int i = 0;
            for (IPlayablePlaylistItems p : clipboard) {
                LOG.info("add " + p.getId() + " - ");
                p.setPositionInList(++i);
            }
        }
    }

    public static List<IPlayablePlaylistItems> getClipboard() {
        return clipboard;
    }

    private void showLogWindow() {
        TopComponent outputWindow = WindowManager.getDefault().findTopComponent("output");
        if (outputWindow != null) {
            outputWindow.setVisible(true);
            outputWindow.open();
            outputWindow.requestActive();
        }
        if (outputWindow != null && outputWindow.isOpened()) {
            String FOLDER = "Actions/View/";
            String INSTANCE_FILE = "org-netbeans-core-actions-LogAction";
            Lookup pathLookup = Lookups.forPath((String)"Actions/View/");
            Lookup.Template actionTemplate = new Lookup.Template(Action.class, "Actions/View/org-netbeans-core-actions-LogAction", null);
            Lookup.Result lookupResult = pathLookup.lookup(actionTemplate);
            Collection foundActions = lookupResult.allInstances();
            for (Action action : foundActions) {
                action.actionPerformed(null);
            }
        }
        Mode myMode = WindowManager.getDefault().findMode("editor");
        myMode.dockInto(outputWindow);
    }
}

