/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.indexing;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.util.gui.Figlets;
import xxx.scenerixx.scenerixxmodule.windows.indexing.IndexingTopComponent;

public class RenamePanel
extends JPanel {
    private DB db = DB.getInstance();
    private JButton btnAbort;
    private JButton btnExecute;
    private JButton btnOpenReplacement;
    private JButton btnOpenSrcDir;
    private JButton btnPreview;
    private JFileChooser jFileChooser2;
    private JScrollPane jScrollPane1;
    private JLabel lbDesc;
    private JLabel lbIntro;
    private JLabel lbReplacement;
    private JLabel lbSource;
    private JTextArea taLog;
    private JTextField tfReplacement;
    private JTextField tfSource;

    public RenamePanel() {
        this.initComponents();
        this.taLog.setFont(new Font("Courier 10 Pitch", 0, 13));
    }

    private void initComponents() {
        this.jFileChooser2 = new JFileChooser();
        this.lbIntro = new JLabel();
        this.lbSource = new JLabel();
        this.lbReplacement = new JLabel();
        this.tfReplacement = new JTextField();
        this.tfSource = new JTextField();
        this.btnPreview = new JButton();
        this.btnExecute = new JButton();
        this.btnAbort = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.taLog = new JTextArea();
        this.lbDesc = new JLabel();
        this.btnOpenSrcDir = new JButton();
        this.btnOpenReplacement = new JButton();
        this.lbIntro.setIcon(new ImageIcon(this.getClass().getResource("/icons/Warning.png")));
        this.lbIntro.setText("Source and replacement are cAsE sEnSiTiVe!");
        this.lbSource.setText("Source");
        this.lbReplacement.setText("Replacement");
        this.btnPreview.setIcon(new ImageIcon(this.getClass().getResource("/icons/Text preview.png")));
        this.btnPreview.setText("Preview");
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.btnPreviewActionPerformed(evt);
            }
        });
        this.btnExecute.setIcon(new ImageIcon(this.getClass().getResource("/icons.silk/arrow_join.png")));
        this.btnExecute.setText("Rename");
        this.btnExecute.setEnabled(false);
        this.btnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.btnExecuteActionPerformed(evt);
            }
        });
        this.btnAbort.setIcon(new ImageIcon(this.getClass().getResource("/icons/Cancel.png")));
        this.btnAbort.setText("Abort");
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.btnAbortActionPerformed(evt);
            }
        });
        this.taLog.setColumns(20);
        this.taLog.setRows(5);
        this.jScrollPane1.setViewportView(this.taLog);
        this.lbDesc.setText("<html>This feature is only for rare edge cases: You can rename paths of medium files in bulk.<br><br> One scenario: you move (part of) your collection to another hard disk. You could now index the new disk again and hash all those files, purge your collection and Scenerixx would sort things out and re-assign all movies. But that's quite time consuming. <br><br> You can replace here now parts within the filepath, e.g. if \"C:\\collection\" was moved to \"D:\\collection\" you can specify that \"C:\\\" (source) should be replaced by \"D:\\\" (replacement). But be aware that the source should be not too short. If you would replace only \"C\" by \"D\" an entry like \"C:\\collection\\corinna.avi\" would become \"D:\\dolledion\\dorinna.avi\". That's why a preview will be shown to you before renaming anything. \"source\" and \"replacement\" are surrounded by two stars, e.g.:<br> <i>**C**:\\**c**olle**c**tion\\**c**orinna.avi <br> would be renamed to<br> **D**:\\**d**olle**d**tion\\**d**orinna.avi <br><i>  <br>Anyhow: make a backup first!<br> </html>");
        this.btnOpenSrcDir.setIcon(new ImageIcon(this.getClass().getResource("/icons/Folder.png")));
        this.btnOpenSrcDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.btnOpenSrcDirActionPerformed(evt);
            }
        });
        this.btnOpenReplacement.setIcon(new ImageIcon(this.getClass().getResource("/icons/Folder.png")));
        this.btnOpenReplacement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenamePanel.this.btnOpenReplacementActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnExecute).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lbIntro).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbReplacement).addComponent(this.lbSource)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfSource).addComponent(this.tfReplacement)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnOpenSrcDir).addComponent(this.btnOpenReplacement))).addGroup(layout.createSequentialGroup().addComponent(this.btnPreview).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAbort))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbDesc, -2, 760, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.lbIntro).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbSource).addComponent(this.tfSource, -2, -1, -2))).addComponent(this.btnOpenSrcDir)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnOpenReplacement).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbReplacement).addComponent(this.tfReplacement, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPreview).addComponent(this.btnAbort)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExecute)).addComponent(this.lbDesc, -2, 246, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 249, Short.MAX_VALUE)));
    }

    private void btnPreviewActionPerformed(ActionEvent evt) {
        this.preview();
    }

    private void btnExecuteActionPerformed(ActionEvent evt) {
        this.execute();
    }

    private void btnAbortActionPerformed(ActionEvent evt) {
        this.abort();
    }

    private void btnOpenSrcDirActionPerformed(ActionEvent evt) {
        this.jFileChooser2.setFileSelectionMode(1);
        int ret = this.jFileChooser2.showOpenDialog(this);
        if (ret == 0) {
            this.tfSource.setText(this.jFileChooser2.getSelectedFile().getAbsolutePath());
        }
    }

    private void btnOpenReplacementActionPerformed(ActionEvent evt) {
        this.jFileChooser2.setFileSelectionMode(1);
        int ret = this.jFileChooser2.showOpenDialog(this);
        if (ret == 0) {
            this.tfReplacement.setText(this.jFileChooser2.getSelectedFile().getAbsolutePath());
        }
    }

    private void abort() {
        this.tfSource.setText("");
        this.tfReplacement.setText("");
        this.btnPreview.setEnabled(true);
        this.btnExecute.setEnabled(false);
        this.btnExecute.setText("Rename");
        this.taLog.append("\nAborted\n");
    }

    private void execute() {
        int confirmRenaming = 0;
        String src = this.tfSource.getText();
        String dest = this.tfReplacement.getText();
        if (src.length() < 3) {
            confirmRenaming = JOptionPane.showConfirmDialog(null, "Using only 1 or 2 characters is very dangerous. Continue anyway?", "Very few characters!", 0, 2);
        }
        if (confirmRenaming == 0) {
            new RenamingWorker().execute();
        } else {
            this.abort();
        }
    }

    private void preview() {
        new PreviewWorker().execute();
    }

    public class RenamingWorker
    extends SwingWorker<String, String> {
        String src;
        String dest;
        private DateTimeFormatter df;

        public RenamingWorker() {
            this.src = RenamePanel.this.tfSource.getText();
            this.dest = RenamePanel.this.tfReplacement.getText();
            this.df = DateTimeFormatter.ofPattern("HH:mm:ss");
        }

        @Override
        protected String doInBackground() throws Exception {
            List mediumFiles = RenamePanel.this.db.getMediumFiles(this.src, true, true, true, DB.OrderBy.TITLE);
            this.publish(Figlets.sRenaming);
            for (MediumFile mf : mediumFiles) {
                if (!mf.getFileCompletePath().contains(this.src)) continue;
                this.publish("[" + this.df.format(LocalDateTime.now()) + "] '" + mf.getFileCompletePath().replace(this.src, "**" + this.src + "**") + "'\n renamed to \n'" + mf.getFileCompletePath().replace(this.src, "**" + this.dest + "**") + "'\n\n");
                mf.setFileCompletePath(mf.getFileCompletePath().replaceAll(this.src, this.dest));
                RenamePanel.this.db.getEntityService().save((AbstractEntity)mf);
            }
            this.publish(Figlets.sRenamingEnd);
            RenamePanel.this.btnPreview.setEnabled(true);
            RenamePanel.this.btnExecute.setEnabled(false);
            RenamePanel.this.btnAbort.setEnabled(true);
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                RenamePanel.this.taLog.append(s);
            }
        }
    }

    public class PreviewWorker
    extends SwingWorker<String, String> {
        private DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");

        @Override
        protected String doInBackground() throws Exception {
            String src = RenamePanel.this.tfSource.getText();
            String dest = RenamePanel.this.tfReplacement.getText();
            List mediumFiles = RenamePanel.this.db.getMediumFiles(src, true, true, true, DB.OrderBy.TITLE);
            this.publish(Figlets.sPreview);
            int i = 0;
            for (MediumFile mf : mediumFiles) {
                if (!mf.getFileCompletePath().contains(src)) continue;
                this.publish("[" + this.df.format(LocalDateTime.now()) + "] '" + mf.getFileCompletePath().replace(src, "**" + src + "**") + "'\n would be renamed to \n'" + mf.getFileCompletePath().replace(src, "**" + dest + "**") + "'\n\n");
                ++i;
            }
            this.publish(Figlets.sPreviewEnd);
            RenamePanel.this.btnExecute.setText("Rename " + i + " entries in the database");
            RenamePanel.this.btnExecute.setEnabled(true);
            RenamePanel.this.btnAbort.setEnabled(false);
            IndexingTopComponent.LOG.finest("Finished preview.");
            return null;
        }

        @Override
        protected void process(List<String> item) {
            for (String s : item) {
                RenamePanel.this.taLog.append(s);
            }
        }
    }
}

