/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.statistic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.BlendMode;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.stage.PopupWindow;
import javax.swing.JPanel;
import org.controlsfx.control.WorldMapView;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.Nationality;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.RendererUtil;

public class WorldMap
extends JPanel {
    private static final Logger LOG = Logger.getLogger(WorldMap.class.getName());
    private static final int JFXPANEL_WIDTH_INT = 300;
    private static final int JFXPANEL_HEIGHT_INT = 250;
    private static JFXPanel fxContainer = new JFXPanel();
    private double zoom = 1.0;
    private static final String SQUARE_BUBBLE = "M 24 1 h -24 v 28 h 4 v 5.019 l 7 -5.019 h 13 z";

    public WorldMap() {
        this.setLayout(new BorderLayout());
        fxContainer.setPreferredSize(new Dimension(300, 250));
        this.add((Component)fxContainer, "Center");
        Platform.runLater(this::createScene);
    }

    private void createScene() {
        WorldMapView worldMapView = new WorldMapView(this){};
        worldMapView.setShowLocations(true);
        worldMapView.setOnScroll(t -> {
            LOG.finer("Scroll handler: " + this.zoom);
            this.zoom = t.getDeltaY() < 0.0 ? (this.zoom -= 0.1) : (this.zoom += 0.1);
            worldMapView.setZoomFactor(this.zoom);
        });
        worldMapView.setLocationViewFactory(location -> {
            LOG.finer("Get Persons for " + location.getName());
            int femaleCount = DB.getInstance().getPersonCount(Scenerixx.unlocked, Gender.FEMALE, Nationality.getEnum((String)location.getName()));
            int maleCount = DB.getInstance().getPersonCount(Scenerixx.unlocked, Gender.MALE, Nationality.getEnum((String)location.getName()));
            int tsCount = DB.getInstance().getPersonCount(Scenerixx.unlocked, Gender.TS, Nationality.getEnum((String)location.getName()));
            if (tsCount + maleCount + femaleCount > 0) {
                Text t = new Text("" + (femaleCount + tsCount + maleCount));
                int textSize = 8;
                if (this.zoom > 5.0) {
                    textSize = 6;
                }
                if (this.zoom > 10.0) {
                    textSize = 4;
                }
                t.setStyle("-fx-font: " + textSize + " arial;");
                int tmpTextSize = textSize;
                t.setOnMouseEntered(event -> {
                    Object x = "";
                    if (femaleCount > 0) {
                        x = (String)x + femaleCount + " " + Nationality.getEnum((String)location.getName()).getTitle() + " females\n";
                    }
                    if (maleCount > 0) {
                        x = (String)x + maleCount + " " + Nationality.getEnum((String)location.getName()).getTitle() + " males\n";
                    }
                    if (tsCount > 0) {
                        x = (String)x + tsCount + " " + Nationality.getEnum((String)location.getName()).getTitle() + " ts";
                    }
                    t.setStyle("-fx-font: " + (tmpTextSize + 4) + " arial; -fx-fill: white; -fx-stroke: red;");
                    Tooltip.install((Node)t, (Tooltip)this.makeBubble(new Tooltip((String)x)));
                });
                t.setOnMouseExited(event -> {
                    t.setText("" + (femaleCount + tsCount + maleCount));
                    t.setStyle("-fx-font: " + tmpTextSize + " arial;");
                });
                return t;
            }
            Circle circle = new Circle();
            circle.getStyleClass().add((Object)"location");
            circle.setRadius(3.0);
            LOG.fine("No persons for: " + location.getName());
            Image flagImage = RendererUtil.getFlagImage(Nationality.getEnum((String)location.getName()));
            circle.setFill((Paint)new ImagePattern((javafx.scene.image.Image)SwingFXUtils.toFXImage((BufferedImage)WorldMap.toBufferedImage(flagImage), null), 0.0, 0.0, 1.0, 1.0, true));
            circle.setTranslateX(-4.0);
            Tooltip.install((Node)circle, (Tooltip)this.makeBubble(new Tooltip(location.getName())));
            return circle;
        });
        ArrayList<WorldMapView.Location> lis = new ArrayList<WorldMapView.Location>();
        for (Nationality n : Nationality.values()) {
            if (n.getLatitude() == 0.0 || n.getLongitude() == 0.0) continue;
            WorldMapView.Location loc = new WorldMapView.Location(n.getCountry(), n.getLatitude(), n.getLongitude());
            LOG.info("loc: " + loc.getName() + " - " + loc.getLatitude() + " - " + loc.getLongitude());
            lis.add(loc);
        }
        ObservableList observableList = FXCollections.observableList(lis);
        worldMapView.setLocations(observableList);
        worldMapView.countrySelectionModeProperty().set((Object)WorldMapView.SelectionMode.MULTIPLE);
        worldMapView.blendModeProperty().set((Object)BlendMode.BLUE);
        worldMapView.backgroundProperty().set((Object)Background.EMPTY);
        ObservableList locations = FXCollections.observableArrayList();
        for (Nationality nat : Nationality.values()) {
            int femaleCount = DB.getInstance().getPersonCount(Scenerixx.unlocked, Gender.FEMALE, nat);
            int maleCount = DB.getInstance().getPersonCount(Scenerixx.unlocked, Gender.MALE, nat);
            int tsCount = DB.getInstance().getPersonCount(Scenerixx.unlocked, Gender.TS, nat);
            if (tsCount + maleCount + femaleCount <= 0) continue;
            WorldMapView.Location loc = new WorldMapView.Location(nat.getCountry(), nat.getLatitude(), nat.getLongitude());
            locations.add((Object)loc);
            LOG.info("loc: " + loc.getName() + " - " + loc.getLatitude() + " - " + loc.getLongitude());
            LOG.info("Locatino added " + nat.getCountry());
        }
        worldMapView.setSelectedLocations(locations);
        Group mapGroup = new Group(new Node[]{worldMapView});
        StackPane root = new StackPane(new Node[]{mapGroup});
        mapGroup.setScaleX(1.0);
        mapGroup.setScaleY(1.0);
        root.addEventFilter(ScrollEvent.SCROLL, e -> {
            double delta = e.getDeltaY();
            double scaleFactor = delta > 0.0 ? 1.1 : 0.9;
            mapGroup.setScaleX(mapGroup.getScaleX() * scaleFactor);
            mapGroup.setScaleY(mapGroup.getScaleY() * scaleFactor);
            e.consume();
        });
        fxContainer.setScene(new Scene((Parent)root));
    }

    private Tooltip makeBubble(Tooltip tooltip) {
        tooltip.setStyle("-fx-font-size: 16px; -fx-shape: \"M 24 1 h -24 v 28 h 4 v 5.019 l 7 -5.019 h 13 z\";");
        tooltip.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_BOTTOM_LEFT);
        return tooltip;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

