/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.studio;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.comparator.StudioComparator;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.settings.QUiState;
import xxx.scenerixx.scenerixxlib.model.settings.UiState;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.action.AddPersonsFromClipboardAction;
import xxx.scenerixx.scenerixxmodule.childfactories.studio.StudioChildFactory;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.StandardContextMenu;
import xxx.scenerixx.scenerixxmodule.util.gui.bean.ScenerixxBeanTreeView;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.IDirty;
import xxx.scenerixx.scenerixxmodule.windows.dashboard.DashboardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.studio.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.studio.action.ImportStudioAction;
import xxx.scenerixx.scenerixxmodule.windows.studio.action.ReloadAction;
import xxx.scenerixx.scenerixxmodule.windows.studio.action.ShowAvailableScenerixxFilesAction;

@TopComponent.Description(preferredID="StudioListTopComponent", iconBase="icons/home.png", persistenceType=0)
public final class StudioListTopComponent
extends AbstractTopComponent
implements ExplorerManager.Provider,
IDirty {
    private static final Logger LOG = Logger.getLogger(StudioListTopComponent.class.getName());
    private static ExplorerManager em = new ExplorerManager();
    private DB db = DB.getInstance();
    private boolean asc = true;
    private boolean initialized = false;
    private final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
    private BeanTreeView beanTreeView1;
    private ButtonGroup btnGroupSort;
    private JButton btnImportSelected;
    private JButton btnReload;
    private JButton btnReset;
    private JCheckBox cbHideImportedScenerixxFiles;
    public JCheckBox cbShowPosition;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel lbDirty;
    private JLabel lbSearch;
    public JRadioButton rbSortAmount;
    public JRadioButton rbSortName;
    private JTextField tfSearch;
    public JToggleButton toggleBtnAsc;

    public StudioListTopComponent() {
        LocalDateTime now = LocalDateTime.now();
        LOG.info("Initialize Studio window: " + String.valueOf(now));
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            StatusDisplayer.getDefault().setStatusText("Initializing Studio window");
            TopComponent dashboard = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
            if (dashboard != null) {
                ((DashboardTopComponent)dashboard).setStatus("Initializing Studios window");
            }
        });
        this.initComponents();
        this.setName(Bundle.CTL_StudioListTopComponent());
        this.setToolTipText(Bundle.HINT_StudioListTopComponent());
        this.setMinimumSize(new Dimension(0, 0));
        UiState uiState = (UiState)this.db.getEntityService().find((EntityPathBase)QUiState.uiState).findFirst();
        if (uiState == null) {
            uiState = new UiState();
        }
        this.toggleBtnAsc.setSelected(uiState.isStudiolistAsc());
        this.cbShowPosition.setSelected(uiState.isStudiolistShowPosition());
        if (this.cbShowPosition.isSelected()) {
            this.cbShowPosition.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/text_list_numbers.png")));
        } else {
            this.cbShowPosition.setIcon(null);
        }
        this.rbSortAmount.setSelected(uiState.isStudiolistSortByAmount());
        this.rbSortName.setSelected(uiState.isStudiolistSortByName());
        this.toggleIcons();
        this.cbHideImportedScenerixxFiles.setVisible(false);
        this.btnReset.setVisible(false);
        this.btnImportSelected.setVisible(false);
        this.asc = uiState.isStudiolistAsc();
        this.toggleAsc();
        StandardContextMenu.addTo(this.tfSearch);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)em, (ActionMap)this.getActionMap()));
        em.addPropertyChangeListener(evt -> {
            LOG.info("property changed");
            if (em.getSelectedNodes().length > 0) {
                this.btnImportSelected.setEnabled(true);
            } else {
                this.btnImportSelected.setEnabled(false);
            }
        });
        KeyStroke keyInsert = KeyStroke.getKeyStroke(80, 128);
        AbstractAction addToPlaylist = new AbstractAction("AddToPlaylist"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info("Add studio to playlist shortcut");
                StudioListTopComponent.this.addToDefaultPlaylist(em.getSelectedNodes());
            }
        };
        this.beanTreeView1.getActionMap().put("AddToPlaylist", addToPlaylist);
        this.beanTreeView1.getInputMap(1).put(keyInsert, "AddToPlaylist");
        KeyStroke keyDelete = KeyStroke.getKeyStroke(127, 0);
        AbstractAction performDelete = new AbstractAction("performDelete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (em.getSelectedNodes().length > 0) {
                    for (Node n : em.getSelectedNodes()) {
                        Object object;
                        if (n.getValue("studio") == null || !((object = n.getValue("studio")) instanceof Studio)) continue;
                        Studio studio = (Studio)object;
                        StudioListTopComponent.this.scenerixxCommon.deleteStudio(studio);
                    }
                    TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                    if (details != null) {
                        ((DetailsTopComponent)details).getStudioDetailsPanel().resetForm();
                    }
                    StudioListTopComponent.this.reloadList();
                }
            }
        };
        this.beanTreeView1.getActionMap().put("performDelete", performDelete);
        this.beanTreeView1.getInputMap(1).put(keyDelete, "performDelete");
        KeyStroke keyF6 = KeyStroke.getKeyStroke(117, 0);
        AbstractAction performAddToClipboard = new AbstractAction("performAddToClipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info("copy to temporary clipboard");
                if (em.getSelectedNodes().length > 0) {
                    for (Node n : em.getSelectedNodes()) {
                        String displayname = "";
                        if (n.getValue("studio") != null) {
                            StudioListTopComponent.this.clipboard((IPlayablePlaylistItems)((Studio)n.getValue("studio")));
                            displayname = ((Studio)n.getValue("studio")).getName();
                        }
                        if (n.getValue("movie") != null) {
                            StudioListTopComponent.this.clipboard((IPlayablePlaylistItems)((Movie)n.getValue("movie")));
                            displayname = ((Movie)n.getValue("movie")).getNameOfPlayable();
                        }
                        if (n.getValue("scene") != null) {
                            StudioListTopComponent.this.clipboard((IPlayablePlaylistItems)((Scene)n.getValue("scene")));
                            displayname = ((Scene)n.getValue("scene")).getNameOfPlayable();
                        }
                        if (n.getValue("bookmark") != null) {
                            StudioListTopComponent.this.clipboard((IPlayablePlaylistItems)((Bookmark)n.getValue("bookmark")));
                            displayname = ((Bookmark)n.getValue("bookmark")).getNameOfPlayable();
                        }
                        AbstractTopComponent.notifyInfo("added to temporary playlist: " + displayname);
                        LOG.info("added to temporary playlist: " + displayname);
                    }
                    AbstractTopComponent.reloadPlaylist("[TEMPORARY PLAYLIST]");
                }
            }
        };
        this.beanTreeView1.getActionMap().put("performAddToClipboard", performAddToClipboard);
        this.beanTreeView1.getInputMap(1).put(keyF6, "performAddToClipboard");
        KeyStroke keyEnter = KeyStroke.getKeyStroke(10, 2);
        AbstractAction openSelectedItems = new AbstractAction("OpenSelectedItemsFromStudioList"){

            @Override
            public void actionPerformed(ActionEvent e) {
                StudioListTopComponent.this.scenerixxCommon.openVlc(em.getSelectedNodes());
            }
        };
        this.beanTreeView1.getActionMap().put("OpenSelectedItemsFromStudioList", openSelectedItems);
        this.beanTreeView1.getInputMap(1).put(keyEnter, "OpenSelectedItemsFromStudioList");
        AbstractAction reloadAction = new AbstractAction("reload"){

            @Override
            public void actionPerformed(ActionEvent e) {
                StudioListTopComponent.this.reloadList();
            }
        };
        KeyStroke keyF5 = KeyStroke.getKeyStroke(116, 0);
        this.beanTreeView1.getActionMap().put("reload", reloadAction);
        this.beanTreeView1.getInputMap(1).put(keyF5, "reload");
        KeyStroke keyAddPersonFromClipboard = KeyStroke.getKeyStroke(86, 192);
        this.beanTreeView1.getActionMap().put("AddPersonFromClipboard", (Action)SystemAction.get(AddPersonsFromClipboardAction.class));
        this.beanTreeView1.getInputMap(1).put(keyAddPersonFromClipboard, "AddPersonFromClipboard");
        LOG.info("populate now studios list " + Duration.between(LocalDateTime.now(), now).toString());
        this.setRootContext(new ArrayList<Studio>(), false, false);
        em.getRootContext().setDisplayName("Press reload to load the list or use the context menu");
        em.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] selectedNodes = em.getSelectedNodes();
                ScenerixxCommon.setSelectedNodesInTitle(selectedNodes.length, "studio");
            }
        });
        this.initialized = true;
        if (!this.db.getScenerixxSettings().isLoadStudiosOnStartup()) {
            LOG.info("Studio list should not be loaded during startup");
            this.setDirty();
            return;
        }
        this.reloadList();
        LOG.info("finished initializing studios window " + Duration.between(LocalDateTime.now(), now).toString());
    }

    private void setRootDisplayName() {
        String sRuntime = "";
        em.getRootContext().setDisplayName("Studios [" + em.getRootContext().getChildren().getNodesCount() + "] " + sRuntime);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.btnGroupSort = new ButtonGroup();
        this.beanTreeView1 = new ScenerixxBeanTreeView();
        this.jLabel1 = new JLabel();
        this.rbSortName = new JRadioButton();
        this.rbSortAmount = new JRadioButton();
        this.cbShowPosition = new JCheckBox();
        this.toggleBtnAsc = new JToggleButton();
        this.lbDirty = new JLabel();
        this.btnReload = new JButton();
        this.cbHideImportedScenerixxFiles = new JCheckBox();
        this.btnImportSelected = new JButton();
        this.btnReset = new JButton();
        this.tfSearch = new JTextField();
        this.lbSearch = new JLabel();
        this.beanTreeView1.setVerticalScrollBarPolicy(22);
        this.beanTreeView1.setUseSubstringInQuickSearch(true);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.jLabel1.text"));
        this.btnGroupSort.add(this.rbSortName);
        this.rbSortName.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSortName, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.rbSortName.text"));
        this.rbSortName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.rbSortNameActionPerformed(evt);
            }
        });
        this.btnGroupSort.add(this.rbSortAmount);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSortAmount, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.rbSortAmount.text"));
        this.rbSortAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.rbSortAmountActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowPosition, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.cbShowPosition.text"));
        this.cbShowPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.cbShowPositionActionPerformed(evt);
            }
        });
        this.toggleBtnAsc.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/sort_ascending.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.toggleBtnAsc, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.toggleBtnAsc.text"));
        this.toggleBtnAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.toggleBtnAscActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbDirty, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.lbDirty.text"));
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.btnReload.text"));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.btnReloadActionPerformed(evt);
            }
        });
        this.cbHideImportedScenerixxFiles.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbHideImportedScenerixxFiles, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.cbHideImportedScenerixxFiles.text"));
        this.cbHideImportedScenerixxFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.cbHideImportedScenerixxFilesActionPerformed(evt);
            }
        });
        this.btnImportSelected.setIcon(new ImageIcon(this.getClass().getResource("/icons2/54downarrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImportSelected, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.btnImportSelected.text"));
        this.btnImportSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.btnImportSelectedActionPerformed(evt);
            }
        });
        this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/icons/No.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReset, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.btnReset.text"));
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.btnResetActionPerformed(evt);
            }
        });
        this.tfSearch.setText(NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.tfSearch.text"));
        this.tfSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudioListTopComponent.this.tfSearchActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbSearch, (String)NbBundle.getMessage(StudioListTopComponent.class, (String)"StudioListTopComponent.lbSearch.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.beanTreeView1, -2, 0, Short.MAX_VALUE).addComponent(this.cbHideImportedScenerixxFiles, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lbDirty).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReload)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbSortName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbSortAmount).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleBtnAsc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowPosition)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.lbSearch).addGap(12, 12, 12).addComponent(this.tfSearch)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.btnImportSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReset))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbDirty).addComponent(this.btnReload)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.beanTreeView1, -1, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbHideImportedScenerixxFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnImportSelected).addComponent(this.btnReset)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.lbSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.rbSortName).addComponent(this.rbSortAmount).addComponent(this.cbShowPosition).addComponent(this.toggleBtnAsc)).addContainerGap()));
    }

    private void rbSortNameActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void rbSortAmountActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbShowPositionActionPerformed(ActionEvent evt) {
        this.toggleShowPosition();
    }

    private void toggleBtnAscActionPerformed(ActionEvent evt) {
        this.toggleAsc();
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void cbHideImportedScenerixxFilesActionPerformed(ActionEvent evt) {
        this.loadStudioFiles();
    }

    private void btnImportSelectedActionPerformed(ActionEvent evt) {
        this.importSelected();
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void tfSearchActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void importSelected() {
        Object importedStudios = "";
        boolean reload = false;
        for (Node n : em.getSelectedNodes()) {
            Studio s = (Studio)n.getValue("studio");
            if (s == null) continue;
            try {
                String studioName = s.getName();
                if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)studioName)).count() > 0L) {
                    AbstractTopComponent.notifyError("There is already a studio with the name " + studioName + ". I cannot handle this. Either delete the studio person or rename the studio to import.");
                    continue;
                }
                if (s.getParent() != null) {
                    String parentName = s.getParent().getName();
                    LOG.info("parent: " + parentName);
                    if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)parentName)).count() > 0L) {
                        LOG.info("Set existing parent");
                        s.setParent((Studio)this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)parentName)).findFirst());
                    } else {
                        LOG.info("persist parent first");
                        s.setParent((Studio)this.db.getEntityService().save((AbstractEntity)s.getParent()));
                        importedStudios = (String)importedStudios + parentName + ",  ";
                    }
                }
                LOG.info("persist studio " + s.getName());
                s = (Studio)this.db.getEntityService().save((AbstractEntity)s);
                reload = true;
                importedStudios = (String)importedStudios + studioName + ",  ";
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                StudioListTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        }
        if (reload) {
            this.reloadList();
        }
        if (!((String)importedStudios).isEmpty()) {
            importedStudios = ((String)importedStudios).substring(0, ((String)importedStudios).lastIndexOf(","));
            JOptionPane.showMessageDialog(null, "Imported: " + (String)importedStudios);
        }
    }

    private void toggleIcons() {
        if (this.rbSortAmount.isSelected()) {
            this.rbSortAmount.setIcon(ImageUtilities.loadImageIcon((String)"icons.silk/sum.png", (boolean)false));
        } else {
            this.rbSortAmount.setIcon(null);
        }
        if (this.rbSortName.isSelected()) {
            this.rbSortName.setIcon(ImageUtilities.loadImageIcon((String)"icons.silk/font.png", (boolean)false));
        } else {
            this.rbSortName.setIcon(null);
        }
    }

    @Override
    public void setDirty() {
        this.lbDirty.setVisible(true);
        this.btnReload.setVisible(true);
    }

    public void selectStudioNode(String nameOfStudioToSelect) {
        SwingUtilities.invokeLater(() -> {
            if (nameOfStudioToSelect == null || nameOfStudioToSelect.isEmpty()) {
                LOG.info("Cannot select studio node. Empty name was passed. De-select any selection.");
                try {
                    em.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return;
            }
            LocalDateTime now = LocalDateTime.now();
            Node findChild = em.getRootContext().getChildren().findChild(nameOfStudioToSelect);
            if (findChild != null) {
                LOG.fine("found studio node: " + nameOfStudioToSelect);
                try {
                    em.setSelectedNodes(new Node[]{findChild});
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    StudioListTopComponent.notifyError("Could not select studio node. An error occured: " + ex.getMessage());
                }
            } else {
                LOG.fine("did NOT studio node: " + nameOfStudioToSelect);
            }
            LOG.fine("finished select studio node - " + Duration.between(LocalDateTime.now(), now).toString());
        });
    }

    private void toggleAsc() {
        boolean bl = this.asc = !this.asc;
        if (this.asc) {
            this.toggleBtnAsc.setToolTipText("sort ascending");
            this.toggleBtnAsc.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/sort_ascending.png")));
        } else {
            this.toggleBtnAsc.setToolTipText("sort descending");
            this.toggleBtnAsc.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/sort_descending.png")));
        }
        this.reloadList();
    }

    private void toggleShowPosition() {
        if (this.cbShowPosition.isSelected()) {
            this.cbShowPosition.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/text_list_numbers.png")));
        } else {
            this.cbShowPosition.setIcon(null);
        }
        if (em.getSelectedNodes().length >= 1) {
            this.doReloadList(em.getSelectedNodes()[0]);
        } else {
            this.reloadList();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void reloadList() {
        if (!this.initialized) {
            return;
        }
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                StudioListTopComponent.this.doReloadList(Node.EMPTY);
            }
        }, (String)"Loading studio list");
    }

    public void doReloadList(String nameOfStudioToSelect) {
        if (!this.initialized) {
            return;
        }
        this.reloadList();
        if (nameOfStudioToSelect == null || nameOfStudioToSelect.isEmpty()) {
            LOG.info("Cannot select studio node. Empty name was passed: " + nameOfStudioToSelect);
            return;
        }
        Node findChild = em.getRootContext().getChildren().findChild(nameOfStudioToSelect);
        if (findChild != null) {
            try {
                em.setSelectedNodes(new Node[]{findChild});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("Could not select studio node. An error occured: " + ex.getMessage());
            }
        }
    }

    private void doReloadList(Node node) {
        if (!this.initialized) {
            return;
        }
        this.cbHideImportedScenerixxFiles.setVisible(false);
        this.btnReset.setVisible(false);
        this.btnImportSelected.setVisible(false);
        List studios = this.db.getStudios(this.tfSearch.getText());
        if (this.rbSortAmount.isSelected()) {
            studios.sort(new StudioComparator(Scenerixx.unlocked));
        }
        if (this.tfSearch.getText().isEmpty()) {
            Studio unknown = new Studio();
            unknown.setName(StudioChildFactory.unknown_studios);
            studios.add(unknown);
        }
        this.setRootContext(studios, false, this.cbShowPosition.isSelected());
        this.setRootDisplayName();
        if (node != null && !node.equals((Object)Node.EMPTY)) {
            LOG.fine("A node (" + String.valueOf(node) + ") was passed which will be selected after reloading the list.");
            Node child = em.getRootContext().getChildren().findChild(node.getName());
            while (child == null && (node = node.getParentNode()) != null) {
                child = em.getRootContext().getChildren().findChild(node.getName());
            }
            if (child != null && !child.getName().equalsIgnoreCase(StudioChildFactory.unknown_studios) && !child.getName().trim().isEmpty()) {
                this.beanTreeView1.expandNode(child);
                try {
                    em.setSelectedNodes(new Node[]{em.getRootContext().getChildren().findChild(node.getName())});
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    StudioListTopComponent.notifyError("Could not select studio node. An error occured: " + ex.getMessage());
                }
            } else {
                LOG.fine("Node was not found, maybe empty or the 'unknown studio' node. Don't select any node.");
            }
        } else {
            LOG.fine("No node was passed which can be selected after reloading the list.");
        }
        this.lbDirty.setVisible(false);
        this.btnReload.setVisible(false);
        this.beanTreeView1.requestFocus();
    }

    private void loadStudioFiles() {
        ArrayList<Studio> tmpStudio = new ArrayList<Studio>();
        Importer imp = new Importer();
        LOG.fine("Loading Scenerixx-files");
        try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirStudio, new String[0]), new FileVisitOption[0]);){
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    LOG.finest("Found a file: " + filePath.toString());
                    if (!filePath.toString().endsWith("studio.scenerixx")) continue;
                    Studio importStudioFile = imp.importStudioFile(filePath.toString());
                    if (this.cbHideImportedScenerixxFiles.isSelected()) {
                        LOG.finest("Check if studio is already imported.");
                        if (this.db.getEntityService().find((EntityPathBase)QStudio.studio).filter(f -> f.name.eq((Object)importStudioFile.getName())).count() == 0L) {
                            LOG.finest("Was not yet imported");
                            tmpStudio.add(importStudioFile);
                            continue;
                        }
                        LOG.finest("Was already imported");
                        continue;
                    }
                    LOG.fine("Loading " + filePath.toString());
                    tmpStudio.add(importStudioFile);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("Could not load studio files. An error occured: " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            StudioListTopComponent.notifyError("Could not load studio files. An error occured: " + ex.getMessage());
        }
        tmpStudio.sort((one, other) -> one.getName().compareTo(other.getName()));
        this.setRootContext(tmpStudio, true, this.cbShowPosition.isSelected());
    }

    private void setRootContext(List<Studio> studios, boolean scenerixxFiles, boolean showPosition) {
        if (!this.asc) {
            Collections.reverse(studios);
        }
        String suffix = "";
        if (scenerixxFiles) {
            suffix = "[Scenerixx-File]";
        }
        ArrayList<Studio> studiosAsINode = new ArrayList<Studio>();
        for (Studio s : studios) {
            studiosAsINode.add(s);
        }
        StudioChildFactory studioChildFactory = new StudioChildFactory(studiosAsINode, suffix, scenerixxFiles, showPosition){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                StudioListTopComponent.this.doReloadList(node);
            }
        };
        AbstractNode abstractNode = new AbstractNode(Children.create((ChildFactory)studioChildFactory, (boolean)false)){

            public Action[] getActions(boolean context) {
                ArrayList<SystemAction> list = new ArrayList<SystemAction>();
                if (StudioListTopComponent.this.db.getScenerixxSettings().isShowImport()) {
                    list.add(SystemAction.get(ShowAvailableScenerixxFilesAction.class));
                    list.add(SystemAction.get(ImportStudioAction.class));
                }
                list.add(SystemAction.get(ReloadAction.class));
                Action[] actions = new Action[list.size()];
                actions = list.toArray(actions);
                return actions;
            }

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/home.png");
            }

            public Image getOpenedIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/home.png");
            }
        };
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Studios [" + studios.size() + " available Scenerixx-files]");
        SwingUtilities.invokeLater(() -> this.setName(Bundle.CTL_StudioListTopComponent() + " [" + studios.size() + "]"));
    }

    public void showAvailableScenerixxFiles() {
        this.loadStudioFiles();
        this.cbHideImportedScenerixxFiles.setVisible(true);
        this.btnReset.setVisible(true);
        this.btnImportSelected.setVisible(true);
    }

    public ExplorerManager getExplorerManager() {
        return em;
    }

    @Override
    public boolean getShowPosition() {
        return this.cbShowPosition.isSelected();
    }

    @Override
    public boolean getShowCounter() {
        return false;
    }

    @Override
    public boolean getShowLikeCounter() {
        return false;
    }

    @Override
    public boolean getShowRuntime() {
        return true;
    }

    @Override
    public boolean getShowMoviesWithScenerixxFiles() {
        return false;
    }

    @Override
    public boolean getShowRating() {
        return false;
    }

    @Override
    public boolean getPrefixMetaData() {
        return false;
    }
}

