/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.db;

import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxlib.db.EntityServiceInternal;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.QMovie;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.QSceneDetails;
import xxx.scenerixx.scenerixxlib.model.QStudio;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.medium.QMediumFile;

public class DBInternal {
    private static EntityServiceInternal entityService = null;
    private final Logger LOGGER = LoggerFactory.getLogger(DBInternal.class);

    private DBInternal(String jdbcUrl) {
        entityService = new EntityServiceInternal(jdbcUrl);
    }

    public static DBInternal getInstance(String jdbcUrl) {
        return new DBInternal(jdbcUrl);
    }

    public List<Movie> getMovies(Studio studio, boolean showSecret) {
        EntityServiceInternal.Finder find = entityService.find(QMovie.movie);
        if (!showSecret) {
            find = find.filter(f -> f.secret.ne((Object)true));
        }
        List<Movie> movies = find.filter(f -> f.studio.eq(studio)).order(m -> m.title.asc()).find();
        return movies;
    }

    public Movie getMovieByHash(String hash) {
        if (hash.length() != 40) {
            this.LOGGER.warn("Passed hash is not 40 characters long");
            return null;
        }
        EntityServiceInternal.Finder finder = entityService.find(QMediumFile.mediumFile);
        finder = finder.filter(f -> f.hashValue.isNotNull().and((Predicate)f.hashValue.equalsIgnoreCase(hash)));
        List mfs = finder.find(Long.MAX_VALUE);
        for (MediumFile mf : mfs) {
            if (mf.getMovie() == null) continue;
            return mf.getMovie();
        }
        return null;
    }

    public List<Person> getPersons(boolean showSecrets) {
        EntityServiceInternal.Finder find = entityService.find(QPerson.person);
        if (!showSecrets) {
            find = find.filter(p -> p.secret.ne((Object)true));
        }
        return find.order(p -> p.name.lower().asc()).find();
    }

    public Person getPerson(String name, boolean showSecrets) {
        List<Person> persons = this.getPersons(name, showSecrets);
        if (!persons.isEmpty()) {
            return persons.get(0);
        }
        return null;
    }

    public List<Person> getPersons(String name, boolean showSecrets) {
        EntityServiceInternal.Finder find = entityService.find(QPerson.person);
        if (!showSecrets) {
            find = find.filter(p -> p.secret.ne((Object)true));
        }
        return find.filter(p -> p.name.containsIgnoreCase(name)).order(p -> p.name.lower().asc()).find();
    }

    public Studio getStudio(String name) {
        EntityServiceInternal.Finder find = entityService.find(QStudio.studio);
        Studio studio = (Studio)find.filter(f -> f.name.containsIgnoreCase(name)).findFirst();
        return studio;
    }

    public List<Studio> getStudios(String name) {
        EntityServiceInternal.Finder find = entityService.find(QStudio.studio);
        List<Studio> studios = find.filter(f -> f.name.containsIgnoreCase(name)).find();
        return studios;
    }

    public List<Studio> getStudios() {
        return entityService.find(QStudio.studio).order(p -> p.name.asc()).find();
    }

    public List<Scene> getScenes(Studio studio, boolean showSecret) {
        List<Movie> movies = this.getMovies(studio, showSecret);
        ArrayList<Scene> result = new ArrayList<Scene>();
        for (Movie m : movies) {
            result.addAll(m.getScenes());
        }
        return result;
    }

    public List<Scene> getScenes(Person p, boolean showSecret) {
        ArrayList<Scene> result = new ArrayList<Scene>();
        EntityServiceInternal.Finder filter = entityService.find(QSceneDetails.sceneDetails).filter(f -> f.person.eq(p));
        if (!showSecret) {
            filter = filter.filter(f -> f.scene.movie.secret.ne((Object)true));
        }
        List scenedetails = filter.order(f -> f.scene.movie.title.asc()).find();
        for (SceneDetails sd : scenedetails) {
            if (sd.getScene() == null) continue;
            result.add(sd.getScene());
        }
        return result;
    }

    public EntityServiceInternal getEntityService() {
        return entityService;
    }

    public static enum OrderBy {
        TITLE,
        RUNTIME,
        DATEOFSHOOT,
        CREATED,
        LASTMODIFICATION,
        RESOLUTION,
        RATING,
        FILESIZE,
        FILEEXTENSION;

    }
}

