/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.util;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.ExportLevel;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.MovieType;
import xxx.scenerixx.scenerixxlib.util.json.ExcludeGson;
import xxx.scenerixx.scenerixxlib.util.json.JsonDateDeserializer;
import xxx.scenerixx.scenerixxlib.util.json.JsonLocalDateDeserializer;
import xxx.scenerixx.scenerixxlib.util.json.LocalDateTimeAdapter;

public class ScenerixxCommonLib {
    public static final Logger LOG = Logger.getLogger(ScenerixxCommonLib.class.getName());
    private static NumberFormat formatter = new DecimalFormat("0000");
    private DB db = DB.getInstance();
    public static String RED = "#E66363";
    public static String GREEN = "#33D424";

    public static String readableTimestamp(LocalDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd. MMMMM yyyy - HH:mm:ss");
        if (dateTime == null) {
            return "n/a";
        }
        return dateTime.format(formatter);
    }

    public static String readableDurationBetweenTimespans() {
        return "TODO";
    }

    public int getStarttimeForSceneUsingSmartStart(Scene scene, int startTime, boolean unlocked) {
        if (this.db.getScenerixxSettings().isUseSmartStart()) {
            for (Bookmark sceneBookmark : scene.getBookmarks(unlocked)) {
                if (BookmarkType.STORY.equals(sceneBookmark.getType()) && this.db.getScenerixxSettings().isSkipStory()) {
                    startTime = sceneBookmark.getEndTime();
                    break;
                }
                if (!BookmarkType.INTERVIEW.equals(sceneBookmark.getType()) || !this.db.getScenerixxSettings().isSkipInterview()) continue;
                startTime = sceneBookmark.getEndTime();
                break;
            }
        }
        return startTime;
    }

    public int getStarttimeUsingSmartStart(Movie movie, int startTime, boolean unlocked) {
        if (this.db.getScenerixxSettings().isUseSmartStart()) {
            boolean useBookmark = false;
            for (Bookmark movieBookmark : movie.getBookmarks(unlocked)) {
                if (BookmarkType.INTRO.equals(movieBookmark.getType()) && movieBookmark.getStartTime() >= 0) {
                    startTime = movieBookmark.getStartTime();
                    useBookmark = true;
                    break;
                }
                if (BookmarkType.STORY.equals(movieBookmark.getType()) && this.db.getScenerixxSettings().isSkipStory()) {
                    startTime = movieBookmark.getEndTime();
                    useBookmark = true;
                    break;
                }
                if (!BookmarkType.INTERVIEW.equals(movieBookmark.getType()) || !this.db.getScenerixxSettings().isSkipInterview()) continue;
                startTime = movieBookmark.getEndTime();
                useBookmark = true;
                break;
            }
            if (!useBookmark && !movie.getScenes().isEmpty()) {
                for (Bookmark firstSceneBookmark : movie.getScenes().get(0).getBookmarks(unlocked)) {
                    if (BookmarkType.STORY.equals(firstSceneBookmark.getType()) && this.db.getScenerixxSettings().isSkipStory()) {
                        startTime = firstSceneBookmark.getEndTime();
                        useBookmark = true;
                        break;
                    }
                    if (!BookmarkType.INTERVIEW.equals(firstSceneBookmark.getType()) || !this.db.getScenerixxSettings().isSkipInterview()) continue;
                    startTime = firstSceneBookmark.getEndTime();
                    useBookmark = true;
                    break;
                }
            }
            if (!useBookmark && !movie.getScenes().isEmpty()) {
                startTime = movie.getScenes().get(0).getStartTime();
            }
        }
        return startTime;
    }

    public static ExportLevel determineExportLevel(Movie m, boolean secret) {
        ExportLevel result = ExportLevel.Level_0;
        boolean level1 = true;
        LOG.info("Checking if criteria for level 1 is met.");
        if (m.getScenes().isEmpty()) {
            LOG.info(m.getNameOfPlayable() + " has no associated scenes. Movie is level 0.");
            return result;
        }
        for (Scene s : m.getScenes()) {
            if (s.getPersons(secret).isEmpty()) {
                LOG.info(s.getNameOfPlayable() + " has no associated persons. Movie is level 0.");
                return result;
            }
            if (s.getEndTime() != 0) continue;
            LOG.info(s.getNameOfPlayable() + " has no end time. Movie is level 0.");
            return result;
        }
        result = ExportLevel.Level_1;
        LOG.info("Checking if criteria for level 2 is met.");
        if (m.getStudio() == null) {
            LOG.info(m.getNameOfPlayable() + " has no associated studio. Movie is level 1.");
            return result;
        }
        if (m.getType() == null) {
            LOG.info(m.getNameOfPlayable() + " has no associated type(s). Movie is level 1.");
            return result;
        }
        if (m.getReleaseYear() == null) {
            LOG.info(m.getNameOfPlayable() + " has no date set. Movie is level 1.");
            return result;
        }
        if (m.getLanguageSpoken() == null) {
            LOG.info(m.getNameOfPlayable() + " has no language set. Movie is level 1.");
            return result;
        }
        result = ExportLevel.Level_2;
        LOG.info("Checking if criteria for level 3 is met.");
        for (Scene s : m.getScenes()) {
            for (SceneDetails sd : s.getDetails()) {
                if (!sd.getAppearances().isEmpty()) continue;
                LOG.info(s.getNameOfPlayable() + " has no appearance for person '" + sd.getPerson().getName() + "'. Movie is level 2.");
                return result;
            }
        }
        LOG.info(m.getNameOfPlayable() + " is missing.");
        return result;
    }

    public static Integer calculateAge(Scene s, Person p) {
        Integer result = null;
        if (s.getDateOfShootYear() != null && p.getBirthYear() != null) {
            int sDay = 31;
            int sMonth = 6;
            int sYear = s.getDateOfShootYear();
            int pDay = 31;
            int pMonth = 6;
            int pYear = p.getBirthYear();
            if (s.getDateOfShootMonth() != null) {
                sMonth = s.getDateOfShootMonth();
            }
            if (s.getDateOfShootDay() != null) {
                sDay = s.getDateOfShootDay();
            }
            if (p.getBirthMonth() != null) {
                pMonth = p.getBirthMonth();
            }
            if (p.getBirthDay() != null) {
                pDay = p.getBirthDay();
            }
            Date sceneDate = new Date(sYear + 1900, sMonth, sDay);
            Date personDate = new Date(pYear + 1900, pMonth, pDay);
            result = ScenerixxCommonLib.yearDifference(personDate, sceneDate);
        } else if (s.getDetails(p) != null) {
            if (s.getDetails(p).getMentionedAge() != null) {
                result = s.getDetails(p).getMentionedAge();
            } else if (s.getDetails(p).getAgeRange() != null) {
                return -1;
            }
        }
        return result;
    }

    public static int yearDifference(Date first, Date second) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        int d1 = Integer.parseInt(formatter.format(first));
        int d2 = Integer.parseInt(formatter.format(second));
        int age = (d2 - d1) / 10000;
        return age;
    }

    public static GsonBuilder getGsonBuilder() {
        ExclusionStrategy exclusionStrategy = new ExclusionStrategy(){

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }

            public boolean shouldSkipField(FieldAttributes field) {
                return field.getAnnotation(ExcludeGson.class) != null;
            }
        };
        GsonBuilder gsonBuilder = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{exclusionStrategy});
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new JsonDateDeserializer());
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new JsonLocalDateDeserializer());
        gsonBuilder.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter());
        return gsonBuilder;
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> ScenerixxCommonLib.copy(source, dest.resolve(src.relativize((Path)source))));
        }
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static List<MovieType> findMovieTypesWithSynonyms(String terms) {
        String[] split;
        ArrayList<MovieType> result = new ArrayList<MovieType>();
        for (String s : split = terms.split(" ")) {
            MovieType synonyms = ScenerixxCommonLib.findMovieType(s);
            if (synonyms == null) continue;
            result.add(synonyms);
        }
        return result;
    }

    public static MovieType findMovieType(String s) {
        s = s.toLowerCase();
        HashMap map = new HashMap();
        for (MovieType mt : MovieType.values()) {
            map.put(mt, new ArrayList());
            ((List)map.get(mt)).add(mt.getTitle());
        }
        ((List)map.get(MovieType.AMATEUR)).add("amateur");
        ((List)map.get(MovieType.ASSES_BIG)).add("pawg");
        ((List)map.get(MovieType.ASSES_BIG)).add("bigass");
        ((List)map.get(MovieType.BI_SEX)).add("bisexual");
        ((List)map.get(MovieType.BUSHES)).add("bush");
        ((List)map.get(MovieType.CAMSHOW)).add("cam");
        ((List)map.get(MovieType.CREAMPIES)).add("creampie");
        ((List)map.get(MovieType.DEEPTHROATS)).add("deepthroat");
        ((List)map.get(MovieType.DEEPTHROATS)).add("deep throat");
        ((List)map.get(MovieType.EDGING)).add("edge");
        ((List)map.get(MovieType.FAKE_TITS)).add("fake");
        ((List)map.get(MovieType.FAKE_TITS)).add("silicon");
        ((List)map.get(MovieType.FAT)).add("fatty");
        ((List)map.get(MovieType.FOOTJOBS)).add("footjob");
        ((List)map.get(MovieType.FOURSOMES)).add("mmmf");
        ((List)map.get(MovieType.FOURSOMES)).add("mmff");
        ((List)map.get(MovieType.FOURSOMES)).add("mfff");
        ((List)map.get(MovieType.FOURSOMES)).add("ffff");
        ((List)map.get(MovieType.FOURSOMES)).add("fmmm");
        ((List)map.get(MovieType.FOURSOMES)).add("ffmm");
        ((List)map.get(MovieType.FOURSOMES)).add("fffm");
        ((List)map.get(MovieType.HANDJOBS)).add("handjob");
        ((List)map.get(MovieType.LESBIANS)).add("lesbian");
        ((List)map.get(MovieType.RIMJOBS)).add("rimming");
        ((List)map.get(MovieType.RIMJOBS)).add("rimjob");
        ((List)map.get(MovieType.SQUIRTING)).add("squirt");
        ((List)map.get(MovieType.TEENS)).add("teen");
        ((List)map.get(MovieType.TEENS)).add("teeny");
        ((List)map.get(MovieType.TEENS)).add("teenies");
        ((List)map.get(MovieType.THREESOMES_FFM)).add("ffm");
        ((List)map.get(MovieType.THREESOMES_MMF)).add("mmf");
        ((List)map.get(MovieType.TRANSSEXUAL)).add("trans");
        ((List)map.get(MovieType.TRANSSEXUAL)).add("tranny");
        ((List)map.get(MovieType.TRANSSEXUAL)).add("ladyboy");
        ((List)map.get(MovieType.VOMIT)).add("puke");
        ((List)map.get(MovieType.VOMIT)).add("puking");
        ((List)map.get(MovieType.WATERSPORTS)).add("pee");
        ((List)map.get(MovieType.WATERSPORTS)).add("piss");
        ((List)map.get(MovieType.WATERSPORTS)).add("goldenshower");
        for (MovieType mt : MovieType.values()) {
            for (String x : (List)map.get(mt)) {
                if (!(x = x.toLowerCase()).contains(s) && !s.contains(x)) continue;
                return mt;
            }
        }
        return null;
    }

    public static String doesFileWithIndexExist(String name, int index) {
        for (int i = 0; i <= index; ++i) {
            if (!new File(name + "_" + formatter.format(i) + ".png").exists()) continue;
            return name + "_" + formatter.format(i) + ".png";
        }
        return null;
    }
}

