/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class JsonDateDeserializer
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public Date deserialize(JsonElement element, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        String date = element.getAsString();
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return this.format.parse(date);
        }
        catch (ParseException exp) {
            System.err.println("Failed to parse Date: " + date + " - Error: " + String.valueOf(exp));
            return null;
        }
    }

    public JsonElement serialize(Date date, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.format.format(date));
    }
}

