/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.hibernate;

import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.ParamNotSetException;
import com.querydsl.core.types.dsl.Param;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.hibernate.query.BindableType;
import org.hibernate.query.Query;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.StandardBasicTypes;

public final class HibernateUtil {
    private static final Set<Class<?>> BUILT_IN = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, BigDecimal.class, byte[].class, Byte[].class, java.util.Date.class, Calendar.class, Date.class, Time.class, Timestamp.class, Locale.class, TimeZone.class, Currency.class, Class.class, Serializable.class, Blob.class, Clob.class)));
    private static final Map<Class<?>, BasicTypeReference<?>> TYPES;

    private HibernateUtil() {
    }

    public static void setConstants(Query<?> query, List<Object> constants, Map<ParamExpression<?>, Object> params) {
        for (int i = 0; i < constants.size(); ++i) {
            Object val = constants.get(i);
            if (val instanceof Param) {
                Param param = (Param)val;
                if ((val = params.get(val)) == null) {
                    throw new ParamNotSetException((ParamExpression)param);
                }
            }
            HibernateUtil.setValueWithNumberedLabel(query, i + 1, val);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setValueWithNumberedLabel(Query<?> query, Integer key, Object val) {
        if (val instanceof Collection) {
            Collection collection = (Collection)val;
            query.setParameterList(key.intValue(), collection);
            return;
        }
        if (val instanceof Object[]) {
            Object[] objects = (Object[])val;
            if (!BUILT_IN.contains(val.getClass())) {
                query.setParameterList(key.intValue(), objects);
                return;
            }
        }
        if (val instanceof Number && TYPES.containsKey(val.getClass())) {
            query.setParameter(key.intValue(), val, (BindableType)HibernateUtil.getType(val.getClass()));
            return;
        }
        query.setParameter(key.intValue(), val);
    }

    public static BasicTypeReference getType(Class<?> clazz) {
        return TYPES.get(clazz);
    }

    static {
        HashMap<Class, BasicTypeReference> builder = new HashMap<Class, BasicTypeReference>();
        builder.put(Byte.class, StandardBasicTypes.BYTE);
        builder.put(Short.class, StandardBasicTypes.SHORT);
        builder.put(Integer.class, StandardBasicTypes.INTEGER);
        builder.put(Long.class, StandardBasicTypes.LONG);
        builder.put(BigInteger.class, StandardBasicTypes.BIG_INTEGER);
        builder.put(Double.class, StandardBasicTypes.DOUBLE);
        builder.put(Float.class, StandardBasicTypes.FLOAT);
        builder.put(BigDecimal.class, StandardBasicTypes.BIG_DECIMAL);
        builder.put(String.class, StandardBasicTypes.STRING);
        builder.put(Character.class, StandardBasicTypes.CHARACTER);
        builder.put(java.util.Date.class, StandardBasicTypes.DATE);
        builder.put(Boolean.class, StandardBasicTypes.BOOLEAN);
        TYPES = Collections.unmodifiableMap(builder);
    }
}

