/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.exporter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;

public class EDLExporter {
    public String exportPlaylistToEDL(Playlist playlist, String scenerixxPlaylistsDir, boolean unlocked) {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("# mpv EDL v0");
        for (PlaylistEntry pe : playlist.getEntries(unlocked)) {
            if (pe.getMovie() != null) {
                lines.add(this.escapeFilename(((MediumFile)pe.getMovie().getStartMedium()).getFileCompletePath()));
                continue;
            }
            if (pe.getScene() != null) {
                lines.add(this.escapeFilename(((MediumFile)pe.getScene().getStartMedium()).getFileCompletePath()) + ",start=" + pe.getStarttime() + ",length=" + (pe.getEndtime() - pe.getStarttime()));
                continue;
            }
            if (pe.getBookmark() == null) continue;
            lines.add(this.escapeFilename(((MediumFile)pe.getBookmark().getStartMedium()).getFileCompletePath()) + ",start=" + pe.getStarttime() + ",length=" + (pe.getEndtime() - pe.getStarttime()));
        }
        String result = null;
        try {
            Path file = Files.write(Path.of(scenerixxPlaylistsDir + File.separator + this.escapeEdlFilename(playlist.getName()) + ".edl", new String[0]), lines, new OpenOption[0]);
            result = file.toFile().getAbsolutePath();
        }
        catch (IOException ex) {
            System.getLogger(EDLExporter.class.getName()).log(System.Logger.Level.ERROR, (String)null, (Throwable)ex);
        }
        return result;
    }

    private String escapeFilename(String name) {
        return "%" + name.length() + "%" + name;
    }

    private String escapeEdlFilename(String name) {
        name = name.replace(":", "_");
        return name;
    }
}

