/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.exporter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;

public class M3UExporter {
    public String exportPlaylistToM3U(Playlist playlist, String scenerixxPlaylistsDir, boolean unlocked) {
        ArrayList<Object> lines = new ArrayList<Object>();
        for (PlaylistEntry pe : playlist.getEntries(unlocked)) {
            if (pe.getMovie() != null) {
                lines.add("#EXTINF:-1," + pe.getNameOfPlayable());
                lines.add(this.escapeFilename(((MediumFile)pe.getMovie().getStartMedium()).getFileCompletePath()));
                continue;
            }
            if (pe.getScene() != null) {
                lines.add("#EXTINF:-1," + pe.getNameOfPlayable());
                lines.add(this.escapeFilename(((MediumFile)pe.getScene().getStartMedium()).getFileCompletePath()) + "#t=" + pe.getStarttime() + "," + pe.getEndtime());
                continue;
            }
            if (pe.getBookmark() == null) continue;
            lines.add("#EXTINF:-1," + pe.getNameOfPlayable());
            lines.add(this.escapeFilename(((MediumFile)pe.getBookmark().getStartMedium()).getFileCompletePath()) + "#t=" + pe.getStarttime() + "," + pe.getEndtime());
        }
        String result = null;
        try {
            Path file = Files.write(Path.of(scenerixxPlaylistsDir + File.separator + this.escapeFilename(playlist.getName()) + ".m3u", new String[0]), lines, new OpenOption[0]);
            result = file.toFile().getAbsolutePath();
        }
        catch (IOException ex) {
            System.getLogger(M3UExporter.class.getName()).log(System.Logger.Level.ERROR, (String)null, (Throwable)ex);
        }
        return result;
    }

    private String escapeFilename(String name) {
        name = name.replace(":", "_");
        name = name.replace("#", "%23");
        return name;
    }
}

