/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.exporter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.db.EntityService;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Studio;

public class ScenerixxDataImporter {
    private final Logger LOG = LoggerFactory.getLogger(ScenerixxDataImporter.class);
    private EntityService es = null;
    private DB db = DB.getInstance();

    public void initDb() {
        this.es = new EntityService("jdbc:hsqldb:file:" + System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + "data" + File.separator + "scenerixxdatadb;shutdown=true;hsqldb.write_delay=false;");
    }

    public void closeDb() {
        this.es.getEntityManager().close();
    }

    public void unzip(String filename) {
        try {
            String fileZip = System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + "scenerixxdata_delta_2022-04-24.zip";
            File destDir = new File(System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + "data" + File.separator + "scenerixxdata");
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(fileZip));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = ScenerixxDataImporter.newFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(newFile));
                    }
                } else {
                    int len;
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(parent));
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public void createDatabase() {
    }

    public void importIntoDatabase() {
        File[] list;
        Importer importer = new Importer();
        String dirName = System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + "data" + File.separator + "scenerixxdata";
        dirName = dirName + File.separator + "scenerixxdataexport";
        this.LOG.info("Check if " + dirName + " exists");
        if (Files.exists(Paths.get(dirName, new String[0]), LinkOption.NOFOLLOW_LINKS) && (list = new File(dirName).listFiles()) != null) {
            for (File importFile : list) {
                if (importFile.isDirectory()) continue;
                try {
                    this.LOG.info("Try to import: " + importFile.getAbsolutePath());
                    Movie importMovie = importer.importMovieFile(importFile.getAbsolutePath());
                    if (importMovie.getStudio() != null) {
                        Studio studioToAssign = null;
                        if (importMovie.getStudio().getExternalId() != null) {
                            this.LOG.info("Studio has external id - search for it: " + importMovie.getStudio().getExternalId() + " - " + importMovie.getStudio().getName());
                            studioToAssign = this.db.getStudio(importMovie.getStudio().getExternalId());
                        } else if (studioToAssign == null) {
                            this.LOG.info("Search studio by name: " + importMovie.getStudio().getName());
                            studioToAssign = this.db.getStudio(importMovie.getStudio().getName());
                        } else if (studioToAssign == null) {
                            this.LOG.info("Studio was not found, create new: " + String.valueOf(studioToAssign));
                            studioToAssign = this.es.save(importMovie.getStudio());
                        }
                        this.LOG.info("assign studio '" + String.valueOf(studioToAssign) + "' to movie '" + importMovie.getTitle() + "'");
                        importMovie.setStudio(studioToAssign);
                    }
                    importMovie = this.es.save(importMovie);
                    this.LOG.info("new movie id: " + importMovie.getId() + " - " + importMovie.getTitle());
                }
                catch (Exception ex) {
                    java.util.logging.Logger.getLogger(ScenerixxDataImporter.class.getName()).log(Level.SEVERE, null, ex);
                    ex.printStackTrace();
                }
            }
        }
    }
}

