/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.exporter;

import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;

public class XspfExporter {
    private DB db = DB.getInstance();

    public String exportPlaylistToXspf(Playlist playlist, String scenerixxPlaylistsDir, boolean unlocked) throws TransformerFactoryConfigurationError, IllegalArgumentException, DOMException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Attr attrVersion = doc.createAttribute("version");
        attrVersion.setValue("1");
        Attr attrXmlns = doc.createAttribute("xmlns");
        attrXmlns.setValue("http://xspf.org/ns/0/");
        Attr attrXmlnsVlc = doc.createAttribute("xmlns:vlc");
        attrXmlnsVlc.setValue("http://www.videolan.org/vlc/playlist/ns/0/");
        Element rootElement = doc.createElement("playlist");
        rootElement.setAttributeNode(attrXmlns);
        rootElement.setAttributeNode(attrXmlnsVlc);
        doc.appendChild(rootElement);
        Element title = doc.createElement("title");
        title.appendChild(doc.createTextNode(playlist.getName()));
        rootElement.appendChild(title);
        Element tracklist = doc.createElement("trackList");
        rootElement.appendChild(tracklist);
        int index = 0;
        for (PlaylistEntry pe : playlist.getEntries(unlocked)) {
            if (pe.getMovie() != null) {
                index = this.addMovieEntry(pe, unlocked, doc, tracklist, index);
                continue;
            }
            if (pe.getBookmark() != null) {
                index = this.addBookmarkEntry(doc, tracklist, pe, index);
                continue;
            }
            if (pe.getScene() != null) {
                index = this.addSceneEntry(doc, tracklist, pe, index, unlocked);
                continue;
            }
            if (pe.getPerson() != null) {
                for (Scene scene : pe.getPerson().getScenes(unlocked)) {
                    pe.setScene(scene);
                    index = this.addSceneEntry(doc, tracklist, pe, index, unlocked);
                }
                continue;
            }
            if (pe.getStudio() != null) {
                for (Movie movie : this.db.getMovies(pe.getStudio(), unlocked)) {
                    pe.setMovie(movie);
                    index = this.addMovieEntry(pe, unlocked, doc, tracklist, index);
                }
                continue;
            }
            if (pe.getMediumFile() == null) continue;
            Element track = doc.createElement("track");
            tracklist.appendChild(track);
            Element tracktitle = doc.createElement("title");
            tracktitle.appendChild(doc.createTextNode(pe.getNameOfPlayable()));
            track.appendChild(tracktitle);
            Element tracklocation = doc.createElement("location");
            tracklocation.appendChild(doc.createTextNode("file:///" + pe.getMediumFile().getFileCompletePath().replace("%", "%25").replace(" ", "%20").replace("\\", "/").replace("#", "%23")));
            track.appendChild(tracklocation);
            Element trackextension = doc.createElement("extension");
            Attr attrExtensionApplication = doc.createAttribute("application");
            attrExtensionApplication.setValue("http://www.videolan.org/vlc/playlist/0");
            trackextension.setAttributeNode(attrExtensionApplication);
            track.appendChild(trackextension);
            Element vlcid = doc.createElement("vlc:id");
            vlcid.appendChild(doc.createTextNode("" + index++));
            trackextension.appendChild(vlcid);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        String destFile = scenerixxPlaylistsDir + File.separator + this.escapeFilename(playlist.getName()) + ".xspf";
        StreamResult result = new StreamResult(new File(destFile));
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
        return destFile;
    }

    private int addBookmarkEntry(Document doc, Element tracklist, PlaylistEntry pe, int index) throws DOMException {
        Element track = doc.createElement("track");
        tracklist.appendChild(track);
        Element tracktitle = doc.createElement("title");
        tracktitle.appendChild(doc.createTextNode(pe.getNameOfPlayable()));
        track.appendChild(tracktitle);
        Bookmark bookmark = pe.getBookmark();
        MediumFile medium = (MediumFile)bookmark.getMedium();
        if (medium != null) {
            Element tracklocation = doc.createElement("location");
            tracklocation.appendChild(doc.createTextNode("file:///" + medium.getFileCompletePath().replace("%", "%25").replace(" ", "%20").replace("\\", "/").replace("#", "%23")));
            track.appendChild(tracklocation);
            Element trackextension = doc.createElement("extension");
            Attr attrExtensionApplication = doc.createAttribute("application");
            attrExtensionApplication.setValue("http://www.videolan.org/vlc/playlist/0");
            trackextension.setAttributeNode(attrExtensionApplication);
            track.appendChild(trackextension);
            Element vlcid = doc.createElement("vlc:id");
            vlcid.appendChild(doc.createTextNode("" + index++));
            trackextension.appendChild(vlcid);
            if (pe.getStarttime() > 0) {
                Element vlcoptionStart = doc.createElement("vlc:option");
                vlcoptionStart.appendChild(doc.createTextNode("start-time=" + bookmark.getStartTime()));
                trackextension.appendChild(vlcoptionStart);
            }
            if (bookmark.getEndMedium() != null && !bookmark.getEndMedium().equals(bookmark.getMedium())) {
                Element track2 = doc.createElement("track");
                tracklist.appendChild(track2);
                Element tracktitle2 = doc.createElement("title");
                tracktitle2.appendChild(doc.createTextNode(pe.getNameOfPlayable()));
                track2.appendChild(tracktitle2);
                Element tracklocationEnd = doc.createElement("location");
                tracklocationEnd.appendChild(doc.createTextNode("file:///" + ((MediumFile)bookmark.getEndMedium()).getFileCompletePath().replace("%", "%25").replace(" ", "%20").replace("\\", "/").replace("#", "%23")));
                track.appendChild(tracklocationEnd);
                Element trackextension2 = doc.createElement("extension");
                Attr attrExtensionApplication2 = doc.createAttribute("application");
                attrExtensionApplication2.setValue("http://www.videolan.org/vlc/playlist/0");
                trackextension2.setAttributeNode(attrExtensionApplication2);
                track.appendChild(trackextension2);
                Element vlcid2 = doc.createElement("vlc:id");
                vlcid2.appendChild(doc.createTextNode("" + index++));
                trackextension2.appendChild(vlcid2);
                if (pe.getStarttime() > 0) {
                    Element vlcoptionStart = doc.createElement("vlc:option");
                    vlcoptionStart.appendChild(doc.createTextNode("start-time=0"));
                    trackextension2.appendChild(vlcoptionStart);
                }
                if (pe.getEndtime() > 0) {
                    Element vlcoptionEnd = doc.createElement("vlc:option");
                    vlcoptionEnd.appendChild(doc.createTextNode("stop-time=" + bookmark.getEndTime()));
                    trackextension2.appendChild(vlcoptionEnd);
                }
            } else if (pe.getEndtime() > 0) {
                Element vlcoptionEnd = doc.createElement("vlc:option");
                vlcoptionEnd.appendChild(doc.createTextNode("stop-time=" + bookmark.getEndTime()));
                trackextension.appendChild(vlcoptionEnd);
            }
        }
        return index;
    }

    private int addMovieEntry(PlaylistEntry pe, boolean unlocked, Document doc, Element tracklist, int index) throws DOMException {
        List<MediumFile> tmpMediumFiles = this.db.getMediumFiles(pe.getMovie(), unlocked);
        for (int i = 0; i < tmpMediumFiles.size(); ++i) {
            Element track2 = doc.createElement("track");
            tracklist.appendChild(track2);
            Element tracktitle2 = doc.createElement("title");
            tracktitle2.appendChild(doc.createTextNode(pe.getNameOfPlayable()));
            track2.appendChild(tracktitle2);
            Element tracklocation = doc.createElement("location");
            tracklocation.appendChild(doc.createTextNode("file:///" + tmpMediumFiles.get(i).getFileCompletePath().replace("%", "%25").replace(" ", "%20").replace("\\", "/").replace("#", "%23")));
            track2.appendChild(tracklocation);
            Element trackextension = doc.createElement("extension");
            Attr attrExtensionApplication = doc.createAttribute("application");
            attrExtensionApplication.setValue("http://www.videolan.org/vlc/playlist/0");
            trackextension.setAttributeNode(attrExtensionApplication);
            track2.appendChild(trackextension);
            Element vlcid = doc.createElement("vlc:id");
            vlcid.appendChild(doc.createTextNode("" + index++));
            trackextension.appendChild(vlcid);
            if (i != 0) continue;
            Element vlcoptionStart = doc.createElement("vlc:option");
            vlcoptionStart.appendChild(doc.createTextNode("start-time=" + new ScenerixxCommonLib().getStarttimeUsingSmartStart(pe.getMovie(), 0, unlocked)));
            trackextension.appendChild(vlcoptionStart);
            Element vlcoptionBookmark = doc.createElement("vlc:option");
            Object bookmarkTitle = "";
            for (Scene s : pe.getMovie().getScenes()) {
                bookmarkTitle = (String)bookmarkTitle + "{name=Scene " + s.getPosition() + ",time=" + s.getStartTime() + "},";
                for (Bookmark b : s.getBookmarks(unlocked)) {
                    bookmarkTitle = (String)bookmarkTitle + "{name=" + String.valueOf(b.getType()) + ",time=" + b.getStartTime() + "},";
                }
            }
            vlcoptionBookmark.appendChild(doc.createTextNode("bookmarks=" + (String)bookmarkTitle));
            trackextension.appendChild(vlcoptionBookmark);
        }
        return index;
    }

    private String escapeFilename(String name) {
        name = name.replace(":", "_");
        return name;
    }

    private int addSceneEntry(Document doc, Element tracklist, PlaylistEntry pe, int index, boolean unlocked) throws DOMException {
        Element track = doc.createElement("track");
        tracklist.appendChild(track);
        Element tracktitle = doc.createElement("title");
        tracktitle.appendChild(doc.createTextNode(pe.getNameOfPlayable()));
        track.appendChild(tracktitle);
        Scene scene = pe.getScene();
        if (scene.getStartMedium() == null && scene.getMovieAssociated() != null && scene.getMovieAssociated().getStartMedium() != null) {
            scene.setStartMedium((MediumFile)scene.getMovieAssociated().getStartMedium());
        }
        if (scene.getStartMedium() != null) {
            Element tracklocation = doc.createElement("location");
            tracklocation.appendChild(doc.createTextNode("file:///" + ((MediumFile)scene.getStartMedium()).getFileCompletePath().replace("%", "%25").replace(" ", "%20").replace("\\", "/").replace("#", "%23")));
            track.appendChild(tracklocation);
            Element trackextension = doc.createElement("extension");
            Attr attrExtensionApplication = doc.createAttribute("application");
            attrExtensionApplication.setValue("http://www.videolan.org/vlc/playlist/0");
            trackextension.setAttributeNode(attrExtensionApplication);
            track.appendChild(trackextension);
            Element vlcid = doc.createElement("vlc:id");
            vlcid.appendChild(doc.createTextNode("" + index++));
            trackextension.appendChild(vlcid);
            if (pe.getStarttime() > 0) {
                Element vlcoptionStart = doc.createElement("vlc:option");
                vlcoptionStart.appendChild(doc.createTextNode("start-time=" + new ScenerixxCommonLib().getStarttimeForSceneUsingSmartStart(scene, scene.getStartTime(), unlocked)));
                trackextension.appendChild(vlcoptionStart);
            }
            if (scene.getEndMedium() != null && !scene.getEndMedium().equals(scene.getStartMedium())) {
                Element track2 = doc.createElement("track");
                tracklist.appendChild(track2);
                Element tracktitle2 = doc.createElement("title");
                tracktitle2.appendChild(doc.createTextNode(pe.getNameOfPlayable()));
                track2.appendChild(tracktitle2);
                Element tracklocationEnd = doc.createElement("location");
                tracklocationEnd.appendChild(doc.createTextNode("file:///" + ((MediumFile)scene.getEndMedium()).getFileCompletePath().replace("%", "%25").replace(" ", "%20").replace("\\", "/").replace("#", "%23")));
                track2.appendChild(tracklocationEnd);
                Element trackextension2 = doc.createElement("extension");
                Attr attrExtensionApplication2 = doc.createAttribute("application");
                attrExtensionApplication2.setValue("http://www.videolan.org/vlc/playlist/0");
                trackextension2.setAttributeNode(attrExtensionApplication2);
                track2.appendChild(trackextension2);
                Element vlcid2 = doc.createElement("vlc:id");
                vlcid2.appendChild(doc.createTextNode("" + index++));
                trackextension2.appendChild(vlcid2);
                if (pe.getStarttime() > 0) {
                    Element vlcoptionStart = doc.createElement("vlc:option");
                    vlcoptionStart.appendChild(doc.createTextNode("start-time=0"));
                    trackextension2.appendChild(vlcoptionStart);
                }
                if (pe.getEndtime() > 0) {
                    Element vlcoptionEnd = doc.createElement("vlc:option");
                    vlcoptionEnd.appendChild(doc.createTextNode("stop-time=" + scene.getEndTime()));
                    trackextension2.appendChild(vlcoptionEnd);
                }
            } else if (pe.getEndtime() > 0) {
                Element vlcoptionEnd = doc.createElement("vlc:option");
                vlcoptionEnd.appendChild(doc.createTextNode("stop-time=" + scene.getEndTime()));
                trackextension.appendChild(vlcoptionEnd);
            }
        }
        return index;
    }
}

