/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxlib.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class JsonLocalDateDeserializer
implements JsonDeserializer<LocalDate>,
JsonSerializer<LocalDate> {
    private static final DateTimeFormatter format = DateTimeFormatter.ISO_LOCAL_DATE;

    public LocalDate deserialize(JsonElement element, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        String date = element.getAsString();
        return format.parse((CharSequence)date, LocalDate::from);
    }

    public JsonElement serialize(LocalDate date, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(format.format(date));
    }
}

