/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.eis.mappings.EISCompositeDirectCollectionMapping;
import org.eclipse.persistence.eis.mappings.EISCompositeObjectMapping;
import org.eclipse.persistence.eis.mappings.EISDirectMapping;
import org.eclipse.persistence.eis.mappings.EISOneToManyMapping;
import org.eclipse.persistence.eis.mappings.EISOneToOneMapping;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.queries.DatabaseQuery;

public class EISDescriptor
extends ClassDescriptor {
    protected String dataFormat;
    public static final String MAPPED = "mapped";
    public static final String INDEXED = "indexed";
    public static final String XML = "xml";
    protected NamespaceResolver namespaceResolver;

    public EISDescriptor() {
        this.shouldOrderMappings = false;
        this.dataFormat = XML;
    }

    @Override
    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isEISMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    public void setDataTypeName(String dataTypeName) throws DescriptorException {
        this.setTableName(dataTypeName);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    @Override
    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            if (this.isXMLFormat()) {
                this.setInheritancePolicy(new QNameInheritancePolicy(this));
            } else {
                this.setInheritancePolicy(new InheritancePolicy(this));
            }
        }
        return (InheritancePolicy)this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    @Override
    public void setQueryManager(DescriptorQueryManager queryManager) {
        this.queryManager = queryManager;
        if (queryManager != null) {
            queryManager.setDescriptor(this);
        }
    }

    @Override
    public void preInitialize(AbstractSession session) {
        if (this.isInitialized(1)) {
            return;
        }
        if (this.isXMLFormat()) {
            this.setObjectBuilder(new XMLObjectBuilder(this));
            if (this.hasInheritance()) {
                ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.namespaceResolver);
            }
        }
        super.preInitialize(session);
    }

    @Override
    public void initialize(DescriptorQueryManager queryManager, AbstractSession session) {
        ((DatasourcePlatform)session.getDatasourcePlatform()).initializeDefaultQueries(queryManager, session);
        super.initialize(queryManager, session);
    }

    public boolean isXMLFormat() {
        return this.dataFormat.equals(XML);
    }

    public boolean isMappedFormat() {
        return this.dataFormat.equals(MAPPED);
    }

    public boolean isIndexedFormat() {
        return this.dataFormat.equals(INDEXED);
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getDataTypeName() throws DescriptorException {
        return this.getTableName();
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void useMappedRecordFormat() {
        this.setDataFormat(MAPPED);
    }

    public void useIndexedRecordFormat() {
        this.setDataFormat(INDEXED);
    }

    public void useXMLRecordFormat() {
        this.setDataFormat(XML);
    }

    @Override
    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) {
        if (fieldValue instanceof AbstractRecord) {
            AbstractRecord rec = (AbstractRecord)fieldValue;
            return rec;
        }
        if (!(fieldValue instanceof List)) {
            return this.getObjectBuilder().createRecord(0, null);
        }
        List nestedRows = (List)fieldValue;
        if (nestedRows.isEmpty()) {
            return this.getObjectBuilder().createRecord(0, null);
        }
        if (!(nestedRows.get(0) instanceof AbstractRecord)) {
            return this.getObjectBuilder().createRecord(0, null);
        }
        return (AbstractRecord)nestedRows.get(0);
    }

    @Override
    public List<AbstractRecord> buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) {
        if (!this.isXMLFormat()) {
            if (!(fieldValue instanceof List)) {
                return new Vector<AbstractRecord>();
            }
            return new Vector<AbstractRecord>((List)fieldValue);
        }
        if (!(fieldValue instanceof Vector)) {
            return new Vector<AbstractRecord>(0);
        }
        return (Vector)fieldValue;
    }

    @Override
    public List<Object> buildDirectValuesFromFieldValue(Object fieldValue) {
        if (!(fieldValue instanceof Vector)) {
            Vector<Object> fieldValues = new Vector<Object>(1);
            fieldValues.add(fieldValue);
            return fieldValues;
        }
        return (List)fieldValue;
    }

    @Override
    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) {
        return directValues;
    }

    @Override
    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        Vector<AbstractRecord> nestedRows = new Vector<AbstractRecord>(1);
        nestedRows.add(nestedRow);
        return this.buildFieldValueFromNestedRows(nestedRows, "", session);
    }

    @Override
    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        return nestedRows;
    }

    @Override
    public DatabaseField buildField(String fieldName) {
        if (this.isXMLFormat()) {
            XMLField xmlField = new XMLField(fieldName);
            xmlField.setNamespaceResolver(this.getNamespaceResolver());
            xmlField.initialize();
            return xmlField;
        }
        return super.buildField(fieldName);
    }

    @Override
    public DatabaseField buildField(DatabaseField field) {
        if (this.isXMLFormat()) {
            if (!(field instanceof XMLField)) {
                Object xPath = field.getName();
                String columnDefinition = field.getColumnDefinition();
                if (((String)xPath).indexOf(64) == -1 && !((String)xPath).contains("/text()")) {
                    xPath = (String)xPath + "/text()";
                }
                field = new XMLField((String)xPath);
                field.setColumnDefinition(columnDefinition);
            }
            ((XMLField)field).setNamespaceResolver(this.getNamespaceResolver());
            ((XMLField)field).initialize();
        }
        return super.buildField(field);
    }

    @Override
    public AbstractDirectMapping newDirectMapping() {
        return new EISDirectMapping();
    }

    @Override
    public AggregateMapping newAggregateMapping() {
        return new EISCompositeObjectMapping();
    }

    @Override
    public DatabaseMapping newAggregateCollectionMapping() {
        return new EISCompositeCollectionMapping();
    }

    @Override
    public DatabaseMapping newDirectCollectionMapping() {
        return new EISCompositeDirectCollectionMapping();
    }

    @Override
    public ObjectReferenceMapping newOneToOneMapping() {
        return new EISOneToOneMapping();
    }

    @Override
    public ObjectReferenceMapping newManyToOneMapping() {
        return new EISOneToOneMapping();
    }

    @Override
    public CollectionMapping newOneToManyMapping() {
        return new EISOneToManyMapping();
    }

    @Override
    public CollectionMapping newUnidirectionalOneToManyMapping() {
        return new EISOneToManyMapping();
    }

    @Override
    public CollectionMapping newManyToManyMapping() {
        return new EISOneToManyMapping();
    }

    @Override
    public DatabaseMapping addDirectMapping(String attributeName, String fieldName) {
        EISDirectMapping mapping = new EISDirectMapping();
        mapping.setAttributeName(attributeName);
        if (this.isXMLFormat()) {
            mapping.setXPath(fieldName);
        } else {
            mapping.setFieldName(fieldName);
        }
        return this.addMapping(mapping);
    }

    @Override
    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String fieldName) {
        EISDirectMapping mapping = new EISDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        if (this.isXMLFormat()) {
            mapping.setXPath(fieldName);
        } else {
            mapping.setFieldName(fieldName);
        }
        return this.addMapping(mapping);
    }

    @Override
    public void addPrimaryKeyFieldName(String fieldName) {
        if (this.isXMLFormat()) {
            this.addPrimaryKeyField(new XMLField(fieldName));
        } else {
            super.addPrimaryKeyFieldName(fieldName);
        }
    }

    @Override
    public void setSequenceNumberFieldName(String fieldName) {
        super.setSequenceNumberFieldName(fieldName);
    }

    @Override
    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        return ((EISPlatform)session.getDatasourcePlatform()).buildCallFromStatement(statement, query, session);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.isXMLFormat()) {
            int primaryKeyFieldsSize = this.primaryKeyFields.size();
            for (int x = 0; x < primaryKeyFieldsSize; ++x) {
                XMLField pkField = (XMLField)this.primaryKeyFields.get(x);
                pkField.setNamespaceResolver(this.namespaceResolver);
                pkField.initialize();
            }
        }
        super.initialize(session);
    }

    @Override
    public void initializeAggregateInheritancePolicy(AbstractSession session) {
    }

    @Override
    public boolean requiresInitialization(AbstractSession session) {
        return !this.isDescriptorForInterface();
    }

    @Override
    protected DatabaseTable extractDefaultTable() {
        if (this.isAggregateDescriptor()) {
            return new DatabaseTable();
        }
        return super.extractDefaultTable();
    }

    @Override
    public boolean isReturnTypeRequiredForReturningPolicy() {
        return false;
    }

    @Override
    public boolean isEISDescriptor() {
        return true;
    }

    @Override
    public boolean shouldUseFullChangeSetsForNewObjects() {
        return true;
    }
}

