/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public abstract class MouseLiberalAdapter
extends MouseAdapter {
    private boolean isComponentPressedDown = false;
    private long lastUnusedLiberalSingleClickTimeStamp = 0L;
    private final int slowestDoubleClickMilliseconds = 1800;

    public void mouseLiberalClick(MouseEvent e) {
    }

    public void mouseLiberalDoubleClick(MouseEvent e) {
    }

    public void mouseClick(MouseEvent e) {
    }

    public void mousePress(MouseEvent e) {
    }

    public void mouseRelease(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseWheelMove(MouseWheelEvent e) {
    }

    public void mouseDrag(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this.isComponentPressedDown = true;
        this.mousePress(e);
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (this.isComponentPressedDown) {
            this.mouseLiberalClick(e);
            long now = System.currentTimeMillis();
            long timeBetweenUnusedClicks = now - this.lastUnusedLiberalSingleClickTimeStamp;
            if (timeBetweenUnusedClicks <= 1800L) {
                this.mouseLiberalDoubleClick(e);
                this.lastUnusedLiberalSingleClickTimeStamp = 0L;
            } else {
                this.lastUnusedLiberalSingleClickTimeStamp = System.currentTimeMillis();
            }
        }
        this.isComponentPressedDown = false;
        this.mouseRelease(e);
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        this.mouseEnter(e);
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        this.isComponentPressedDown = false;
        this.mouseExit(e);
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        this.mouseClick(e);
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseWheelMove(e);
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        this.mouseDrag(e);
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        this.mouseMove(e);
    }
}

