/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.chartpart.components.ChartButton;

public class SelectionZoom
extends MouseAdapter
implements ChartPart,
ActionListener {
    protected XChartPanel<XYChart> chartPanel;
    protected XYChart chart;
    protected Rectangle bounds;
    protected Color selectionColor = new Color(0, 0, 192, 128);
    protected boolean resetByDoubleClick = true;
    protected boolean resetByButton = true;
    protected ChartButton resetButton = new ChartButton("Reset Zoom");
    protected int x = -1;
    protected int x2 = -1;
    protected boolean filtered;

    public void init(XChartPanel<XYChart> chartPanel) {
        this.chartPanel = chartPanel;
        this.chart = chartPanel.getChart();
        chartPanel.addMouseListener(this);
        chartPanel.addMouseMotionListener(this);
        this.chart.addPlotPart(this);
        this.resetButton.init(chartPanel);
        this.resetButton.setVisible(false);
        this.resetButton.addActionListener(this);
    }

    protected void resetZoom() {
        this.chart.resetFilter();
        this.filtered = false;
        this.resetButton.setVisible(false);
        this.x = -1;
        this.x2 = -1;
        this.repaint();
    }

    protected void repaint() {
        this.chartPanel.invalidate();
        this.chartPanel.repaint();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.x == -1 || this.x2 == -1) {
            return;
        }
        g.setColor(this.selectionColor);
        int xStart = Math.min(this.x, this.x2);
        int width = Math.abs(this.x - this.x2);
        this.bounds = g.getClipBounds();
        g.fillRect(xStart, 0, width, (int)((double)this.bounds.height + this.bounds.getY()));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.x = e.getX();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.x2 = e.getX();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isOverlapping()) {
            this.x = -1;
            this.x2 = -1;
            return;
        }
        if (this.bounds != null && this.x2 != -1) {
            int bigPoint;
            int smallPoint;
            if (this.x2 < this.x) {
                smallPoint = this.x2;
                bigPoint = this.x;
            } else {
                smallPoint = this.x;
                bigPoint = this.x2;
            }
            this.filtered = this.chart.filterXByScreen(smallPoint, bigPoint);
            this.resetButton.setVisible(this.filtered && this.resetByButton);
        }
        this.x = -1;
        this.x2 = -1;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.filtered) {
            return;
        }
        if (this.resetByDoubleClick && e.getClickCount() == 2) {
            this.resetZoom();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resetZoom();
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    public boolean isResetByDoubleClick() {
        return this.resetByDoubleClick;
    }

    public void setResetByDoubleClick(boolean resetByDoubleClick) {
        this.resetByDoubleClick = resetByDoubleClick;
    }

    public boolean isResetByButton() {
        return this.resetByButton;
    }

    public void setResetByButton(boolean resetByButton) {
        this.resetByButton = resetByButton;
        this.resetButton.setVisible(this.filtered && resetByButton);
    }

    public ChartButton getResetButton() {
        return this.resetButton;
    }

    public void setResetButton(ChartButton resetButton) {
        this.resetButton = resetButton;
    }

    private boolean isOverlapping() {
        boolean isOverlapping = false;
        double start = this.x;
        double end = this.x2;
        if (this.x > this.x2) {
            start = this.x2;
            end = this.x;
        }
        if (Math.max(start, this.chart.plot.bounds.getX()) < Math.min(end, this.chart.plot.bounds.getX() + this.chart.plot.bounds.getWidth())) {
            isOverlapping = true;
        }
        return isOverlapping;
    }
}

