/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GstControlSourceAPI;
import org.freedesktop.gstreamer.lowlevel.GstControlSourcePtr;

public class ControlSource
extends GstObject {
    public static final String GTYPE_NAME = "GstControlSource";
    private final Handle handle;

    protected ControlSource(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
    }

    ControlSource(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstControlSourcePtr.class, GstControlSourcePtr::new), init.ownsHandle), init.needRef);
    }

    public double getValue(long timestamp) {
        double[] out = new double[1];
        boolean ok = GstControlSourceAPI.GSTCONTROLSOURCE_API.gst_control_source_get_value(this.handle.getPointer(), timestamp, out);
        if (ok) {
            return out[0];
        }
        throw new IllegalStateException();
    }

    public boolean getValueArray(long timestamp, long interval, double[] values) {
        return GstControlSourceAPI.GSTCONTROLSOURCE_API.gst_control_source_get_value_array(this.handle.getPointer(), timestamp, interval, values.length, values);
    }

    protected static class Handle
    extends GstObject.Handle {
        public Handle(GstControlSourcePtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected GstControlSourcePtr getPointer() {
            return (GstControlSourcePtr)super.getPointer();
        }
    }

    public static final class TimedValue {
        public final long timestamp;
        public final double value;

        public TimedValue(long timestamp, double value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (int)(this.timestamp ^ this.timestamp >>> 32);
            hash = 37 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimedValue other = (TimedValue)obj;
            if (this.timestamp != other.timestamp) {
                return false;
            }
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }

        public String toString() {
            return "TimedValue{timestamp=" + this.timestamp + ", value=" + this.value + '}';
        }
    }
}

