/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.PadDirection;
import org.freedesktop.gstreamer.PluginFeature;
import org.freedesktop.gstreamer.StaticPadTemplate;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstElementFactoryAPI;
import org.freedesktop.gstreamer.lowlevel.GstPadTemplateAPI;
import org.freedesktop.gstreamer.lowlevel.GstPluginAPI;

public class ElementFactory
extends PluginFeature {
    public static final String GTYPE_NAME = "GstElementFactory";
    private static final Level DEBUG = Level.FINE;
    private static final Logger LOG = Logger.getLogger(ElementFactory.class.getName());

    ElementFactory(NativeObject.Initializer init) {
        super(init);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "<init>", new Object[]{init});
        }
    }

    public Element create(String name) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "create", name);
        }
        Pointer elem = GstElementFactoryAPI.GSTELEMENTFACTORY_API.ptr_gst_element_factory_create(this, name);
        LOG.log(DEBUG, "gst_element_factory_create returned: " + elem);
        if (elem == null) {
            throw new IllegalArgumentException("Cannot create GstElement");
        }
        return ElementFactory.elementFor(elem, this.getName());
    }

    public String getAuthor() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "getAuthor");
        }
        return GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_get_metadata(this, "author");
    }

    public String getDescription() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "getDescription");
        }
        return GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_get_metadata(this, "description");
    }

    public String getKlass() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "getKlass");
        }
        return GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_get_metadata(this, "klass");
    }

    public String getLongName() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "getLongName");
        }
        return GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_get_metadata(this, "long-name");
    }

    public List<StaticPadTemplate> getStaticPadTemplates() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "getStaticPadTemplates");
        }
        GlibAPI.GList glist = GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_get_static_pad_templates(this);
        LOG.log(DEBUG, "GSTELEMENTFACTORY_API.gst_element_factory_get_static_pad_templates returned: " + (Object)((Object)glist));
        ArrayList<StaticPadTemplate> templates = new ArrayList<StaticPadTemplate>();
        for (GlibAPI.GList next = glist; next != null; next = next.next()) {
            if (next.data == null) continue;
            GstPadTemplateAPI.GstStaticPadTemplate temp = new GstPadTemplateAPI.GstStaticPadTemplate(next.data);
            templates.add(new StaticPadTemplate(temp.getName(), temp.getPadDirection(), temp.getPadPresence(), GstPadTemplateAPI.GSTPADTEMPLATE_API.gst_static_pad_template_get_caps(temp)));
        }
        return templates;
    }

    public static ElementFactory find(String name) {
        ElementFactory factory;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "find", name);
        }
        if ((factory = GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_find(name)) == null) {
            throw new IllegalArgumentException("No such Gstreamer factory: " + name);
        }
        return factory;
    }

    public static List<ElementFactory> listGetElements(ListType type, PluginFeature.Rank minrank) {
        GlibAPI.GList glist = GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_list_get_elements(type.getValue(), minrank.intValue());
        ArrayList<ElementFactory> list = new ArrayList<ElementFactory>();
        for (GlibAPI.GList next = glist; next != null; next = next.next()) {
            if (next.data == null) continue;
            ElementFactory fact = new ElementFactory(Natives.initializer(next.data, true, true));
            list.add(fact);
        }
        GstPluginAPI.GSTPLUGIN_API.gst_plugin_list_free(glist);
        return list;
    }

    public static List<ElementFactory> listGetElementsFilter(ListType type, PluginFeature.Rank minrank, Caps caps, PadDirection direction, boolean subsetonly) {
        GlibAPI.GList gFilterList;
        ArrayList<ElementFactory> filterList = new ArrayList<ElementFactory>();
        GlibAPI.GList glist = GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_list_get_elements(type.getValue(), minrank.intValue());
        for (GlibAPI.GList next = gFilterList = GstElementFactoryAPI.GSTELEMENTFACTORY_API.gst_element_factory_list_filter(glist, caps, direction, subsetonly); next != null; next = next.next()) {
            if (next.data == null) continue;
            ElementFactory fact = new ElementFactory(Natives.initializer(next.data, true, true));
            filterList.add(fact);
        }
        GstPluginAPI.GSTPLUGIN_API.gst_plugin_list_free(glist);
        GstPluginAPI.GSTPLUGIN_API.gst_plugin_list_free(gFilterList);
        return filterList;
    }

    public static Element make(String factoryName, String name) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "make", new Object[]{factoryName, name});
        }
        return ElementFactory.elementFor(ElementFactory.makeRawElement(factoryName, name), factoryName);
    }

    static Pointer makeRawElement(String factoryName, String name) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.entering("ElementFactory", "makeRawElement", new Object[]{factoryName, name});
        }
        Pointer elem = GstElementFactoryAPI.GSTELEMENTFACTORY_API.ptr_gst_element_factory_make(factoryName, name);
        LOG.log(DEBUG, "Return from gst_element_factory_make=" + elem);
        if (elem == null) {
            throw new IllegalArgumentException("No such Gstreamer factory: " + factoryName);
        }
        return elem;
    }

    private static Element elementFor(Pointer ptr, String factoryName) {
        return Natives.objectFor(ptr, Element.class, false, true);
    }

    public static enum ListType {
        DECODER(1L),
        ENCODER(2L),
        SINK(4L),
        SRC(8L),
        MUXER(16L),
        DEMUXER(32L),
        PARSER(64L),
        PAYLOADER(128L),
        DEPAYLOADER(256L),
        FORMATTER(512L),
        DECRYPTOR(1024L),
        ENCRYPTOR(2048L),
        ANY(0x1FFFFFFFFFFFFL),
        MEDIA_ANY(-281474976710656L),
        MEDIA_VIDEO(0x2000000000000L),
        MEDIA_AUDIO(0x4000000000000L),
        MEDIA_IMAGE(0x8000000000000L),
        MEDIA_SUBTITLE(0x10000000000000L),
        MEDIA_METADATA(0x20000000000000L),
        VIDEO_ENCODER(ENCODER.getValue() | MEDIA_VIDEO.getValue() | MEDIA_IMAGE.getValue()),
        AUDIO_ENCODER(ENCODER.getValue() | MEDIA_AUDIO.getValue()),
        AUDIOVIDEO_SINKS(SINK.getValue() | MEDIA_AUDIO.getValue() | MEDIA_VIDEO.getValue() | MEDIA_IMAGE.getValue()),
        DECODABLE(DECODER.getValue() | DEMUXER.getValue() | DEPAYLOADER.getValue() | PARSER.getValue());

        private final long value;

        private ListType(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }
}

