/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.webrtc;

import org.freedesktop.gstreamer.Bin;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.Promise;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.glib.NativeEnum;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GstAPI;
import org.freedesktop.gstreamer.webrtc.WebRTCICEGatheringState;
import org.freedesktop.gstreamer.webrtc.WebRTCPeerConnectionState;
import org.freedesktop.gstreamer.webrtc.WebRTCSessionDescription;

@Gst.Since(minor=14)
public class WebRTCBin
extends Bin {
    public static final String GST_NAME = "webrtcbin";
    public static final String GTYPE_NAME = "GstWebRTCBin";

    WebRTCBin(NativeObject.Initializer init) {
        super(init);
    }

    public WebRTCBin(String name) {
        super(WebRTCBin.makeRawElement(GST_NAME, name));
    }

    public void connect(final ON_NEGOTIATION_NEEDED listener) {
        this.connect(ON_NEGOTIATION_NEEDED.class, listener, new GstAPI.GstCallback(){

            public void callback(Element elem) {
                listener.onNegotiationNeeded(elem);
            }
        });
    }

    public void connect(final ON_ICE_CANDIDATE listener) {
        this.connect(ON_ICE_CANDIDATE.class, listener, new GstAPI.GstCallback(){

            public void callback(Element elem, int sdpMLineIndex, String candidate) {
                listener.onIceCandidate(sdpMLineIndex, candidate);
            }
        });
    }

    public void createOffer(final CREATE_OFFER listener) {
        Promise promise = new Promise(new Promise.PROMISE_CHANGE(){

            @Override
            public void onChange(Promise promise) {
                Structure reply = promise.getReply();
                WebRTCSessionDescription description = (WebRTCSessionDescription)reply.getValue("offer");
                listener.onOfferCreated(description);
                promise.dispose();
            }
        });
        this.emit("create-offer", null, promise);
    }

    public void createAnswer(final CREATE_ANSWER listener) {
        Promise promise = new Promise(new Promise.PROMISE_CHANGE(){

            @Override
            public void onChange(Promise promise) {
                Structure reply = promise.getReply();
                WebRTCSessionDescription description = (WebRTCSessionDescription)reply.getValue("answer");
                listener.onAnswerCreated(description);
                promise.dispose();
            }
        });
        this.emit("create-answer", null, promise);
    }

    public void addIceCandidate(int sdpMLineIndex, String candidate) {
        this.emit("add-ice-candidate", sdpMLineIndex, candidate);
    }

    public void setLocalDescription(WebRTCSessionDescription description) {
        Promise promise = new Promise();
        description.disown();
        this.emit("set-local-description", description, promise);
        promise.interrupt();
        promise.dispose();
    }

    public void setRemoteDescription(WebRTCSessionDescription description) {
        Promise promise = new Promise();
        description.disown();
        this.emit("set-remote-description", description, promise);
        promise.interrupt();
        promise.dispose();
    }

    public void setStunServer(String server) {
        this.set("stun-server", server);
    }

    public String getStunServer() {
        return (String)this.get("stun-server");
    }

    public void setTurnServer(String server) {
        this.set("turn-server", server);
    }

    public String getTurnServer() {
        return (String)this.get("turn-server");
    }

    public WebRTCPeerConnectionState getConnectionState() {
        return NativeEnum.fromInt(WebRTCPeerConnectionState.class, (Integer)this.get("connection-state"));
    }

    public WebRTCICEGatheringState getICEGatheringState() {
        return NativeEnum.fromInt(WebRTCICEGatheringState.class, (Integer)this.get("ice-gathering-state"));
    }

    public WebRTCSessionDescription getLocalDescription() {
        WebRTCSessionDescription description = (WebRTCSessionDescription)this.get("local-description");
        description.disown();
        return description;
    }

    public WebRTCSessionDescription getRemoteDescription() {
        WebRTCSessionDescription description = (WebRTCSessionDescription)this.get("remote-description");
        description.disown();
        return description;
    }

    public static interface CREATE_ANSWER {
        public void onAnswerCreated(WebRTCSessionDescription var1);
    }

    public static interface CREATE_OFFER {
        public void onOfferCreated(WebRTCSessionDescription var1);
    }

    public static interface ON_ICE_CANDIDATE {
        public void onIceCandidate(int var1, String var2);
    }

    public static interface ON_NEGOTIATION_NEEDED {
        public void onNegotiationNeeded(Element var1);
    }
}

