/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.ReplicationPartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.AbstractPartitioningMetadata;

public class ReplicationPartitioningMetadata
extends AbstractPartitioningMetadata {
    protected List<String> connectionPools;

    public ReplicationPartitioningMetadata() {
        super("<replication-partitioning>");
    }

    public ReplicationPartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.connectionPools = new ArrayList<String>();
        this.connectionPools.addAll(Arrays.asList(annotation.getAttributeArray("connectionPools")));
    }

    protected ReplicationPartitioningMetadata(String elementName) {
        super(elementName);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ReplicationPartitioningMetadata) {
            ReplicationPartitioningMetadata policy = (ReplicationPartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.connectionPools, policy.getConnectionPools());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.connectionPools != null ? this.connectionPools.hashCode() : 0);
        return result;
    }

    public List<String> getConnectionPools() {
        return this.connectionPools;
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        ReplicationPartitioningPolicy policy = new ReplicationPartitioningPolicy();
        super.buildPolicy(policy);
        return policy;
    }

    @Override
    public void buildPolicy(PartitioningPolicy policy) {
        super.buildPolicy(policy);
        ((ReplicationPartitioningPolicy)policy).setConnectionPools(this.getConnectionPools());
    }

    public void setConnectionPools(List<String> connectionPools) {
        this.connectionPools = connectionPools;
    }
}

