/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic.metadata;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationStringValue;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlEnumValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.jaxb.dynamic.metadata.Metadata;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaModelInputImpl;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SchemaMetadata
extends Metadata {
    private static final String DEFAULT_SYSTEM_ID = "sysid";
    private static final String XML_ENUM_VALUE_VALUE = "value";
    private SchemaCompiler schemaCompiler;
    private List<InputSource> externalBindings;

    public SchemaMetadata(DynamicClassLoader dynamicClassLoader, Map<String, Object> properties) throws JAXBException {
        super(dynamicClassLoader, properties);
        try {
            Object propValue;
            if (properties != null && (propValue = properties.get("external-bindings")) != null) {
                this.externalBindings = new ArrayList<InputSource>();
                if (propValue instanceof List) {
                    List xjbSources = (List)propValue;
                    for (Source source : xjbSources) {
                        this.externalBindings.add(SchemaMetadata.createInputSourceFromSource(source));
                    }
                } else {
                    Source xjbSource = (Source)propValue;
                    InputSource xjbInputSource = SchemaMetadata.createInputSourceFromSource(xjbSource);
                    this.externalBindings.add(xjbInputSource);
                }
            }
        }
        catch (ClassCastException cce) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.xjbNotSource());
        }
    }

    public SchemaMetadata(DynamicClassLoader dynamicClassLoader, Map<String, Object> properties, Source metadataSource, EntityResolver resolver) throws JAXBException {
        this(dynamicClassLoader, properties);
        try {
            InputSource schemaInputSource = SchemaMetadata.createInputSourceFromSource(metadataSource);
            if (schemaInputSource.getSystemId() == null) {
                schemaInputSource.setSystemId(DEFAULT_SYSTEM_ID);
            }
            this.schemaCompiler = XJC.createSchemaCompiler();
            this.schemaCompiler.setEntityResolver(resolver);
            this.schemaCompiler.setErrorListener((ErrorListener)new XJCErrorListener());
            if (this.externalBindings != null) {
                for (InputSource xjbSource : this.externalBindings) {
                    this.schemaCompiler.parseSchema(xjbSource);
                }
            }
            this.schemaCompiler.parseSchema(schemaInputSource);
        }
        catch (XMLPlatformException xpe) {
            TransformerException te;
            Throwable throwable = xpe.getCause();
            if (throwable instanceof TransformerException && (te = (TransformerException)throwable).getCause() instanceof IOException) {
                throw org.eclipse.persistence.exceptions.JAXBException.cannotRefreshMetadata();
            }
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(e));
        }
    }

    public SchemaMetadata(DynamicClassLoader dynamicClassLoader, Map<String, Object> properties, Node node, EntityResolver resolver) throws JAXBException {
        this(dynamicClassLoader, properties);
        Element element;
        if (node.getNodeType() == 9) {
            element = ((Document)node).getDocumentElement();
        } else if (node.getNodeType() == 1) {
            element = (Element)node;
        } else {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.cannotInitializeFromNode());
        }
        this.schemaCompiler = XJC.createSchemaCompiler();
        this.schemaCompiler.setEntityResolver(resolver);
        this.schemaCompiler.setErrorListener((ErrorListener)new XJCErrorListener());
        this.schemaCompiler.parseSchema(DEFAULT_SYSTEM_ID, element);
    }

    @Override
    public JavaModelInput getJavaModelInput() throws JAXBException {
        S2JJAXBModel model = this.schemaCompiler.bind();
        if (model == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.xjcBindingError());
        }
        JCodeModel codeModel = model.generateCode(new Plugin[0], null);
        ArrayList<JDefinedClass> classesToProcess = new ArrayList<JDefinedClass>();
        Iterator packages = codeModel.packages();
        while (packages.hasNext()) {
            JPackage pkg = (JPackage)packages.next();
            Iterator classes = pkg.classes();
            while (classes.hasNext()) {
                JDefinedClass cls = (JDefinedClass)classes.next();
                classesToProcess.add(cls);
            }
        }
        ArrayList<JDefinedClass> innerClasses = new ArrayList<JDefinedClass>();
        for (int i = 0; i < classesToProcess.size(); ++i) {
            innerClasses.addAll(this.getInnerClasses((JDefinedClass)classesToProcess.get(i)));
        }
        classesToProcess.addAll(innerClasses);
        JavaClass[] jotClasses = this.createClassModelFromXJC(classesToProcess, codeModel, this.dynamicClassLoader);
        XJCJavaModelImpl javaModel = new XJCJavaModelImpl(codeModel, this.dynamicClassLoader);
        XJCJavaModelInputImpl javaModelInput = new XJCJavaModelInputImpl(jotClasses, (JavaModel)javaModel);
        for (JavaClass javaClass : jotClasses) {
            ((XJCJavaClassImpl)javaClass).setJavaModel(javaModel);
            javaModel.getJavaModelClasses().put(javaClass.getQualifiedName(), javaClass);
        }
        return javaModelInput;
    }

    private HashSet<JDefinedClass> getInnerClasses(JDefinedClass xjcClass) {
        HashSet<JDefinedClass> classesToReturn = new HashSet<JDefinedClass>();
        Iterator it = xjcClass.classes();
        while (it.hasNext()) {
            JDefinedClass innerClass = (JDefinedClass)it.next();
            classesToReturn.add(innerClass);
            classesToReturn.addAll(this.getInnerClasses(innerClass));
        }
        return classesToReturn;
    }

    private JavaClass[] createClassModelFromXJC(ArrayList<JDefinedClass> xjcClasses, JCodeModel jCodeModel, DynamicClassLoader dynamicClassLoader) throws JAXBException {
        try {
            JavaClass[] elinkClasses = new JavaClass[xjcClasses.size()];
            int count = 0;
            for (JDefinedClass definedClass : xjcClasses) {
                XJCJavaClassImpl xjcClass = new XJCJavaClassImpl(definedClass, jCodeModel, dynamicClassLoader);
                elinkClasses[count] = xjcClass;
                ++count;
                if (!definedClass.getClassType().equals(ClassType.ENUM)) continue;
                dynamicClassLoader.addEnum(definedClass.fullName(), this.getEnumValues(definedClass));
            }
            return elinkClasses;
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(e));
        }
    }

    private Map<String, String> getEnumValues(JDefinedClass definedClass) {
        return definedClass.enumConstants().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JEnumConstant)entry.getValue()).annotations().stream().filter(annotation -> XmlEnumValue.class.getName().equals(annotation.getAnnotationClass().binaryName())).map(annotation -> (JAnnotationValue)annotation.getAnnotationMembers().get(XML_ENUM_VALUE_VALUE)).filter(value -> value instanceof JAnnotationStringValue).map(Object::toString).findFirst().orElse((String)entry.getKey())));
    }

    private static InputSource createInputSourceFromSource(Source aSource) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        XMLTransformer t = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        t.transform(aSource, (Result)result);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputSource inputSource = new InputSource(bais);
        inputSource.setSystemId(aSource.getSystemId());
        return inputSource;
    }

    private class XJCErrorListener
    implements ErrorListener {
        private XJCErrorListener() {
        }

        public void error(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }

        public void fatalError(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }

        public void info(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }

        public void warning(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }
    }
}

