/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOClassGeneratorListener;

public class ClassBuffer {
    private static final String lsep = System.lineSeparator();
    private static final String lsep2 = lsep + lsep;
    private String indent = "";
    private StringBuffer attributeBuffer;
    private StringBuffer methodBuffer;
    private StringBuffer classBuffer;
    private StringBuffer interfaceBuffer;
    private String interfaceName;
    private String className;
    private String packageName;
    private String uri;
    private String sdoTypeName;
    private boolean closed;
    private boolean generateInterface;
    private SDOType sdoType;
    private SDOClassGeneratorListener sdoClassGeneratorListener;

    public ClassBuffer(SDOClassGeneratorListener sdoClassGeneratorListener) {
        this.setAttributeBuffer(new StringBuffer());
        this.setMethodBuffer(new StringBuffer());
        this.setClassBuffer(new StringBuffer());
        this.setInterfaceBuffer(new StringBuffer());
        this.sdoClassGeneratorListener = sdoClassGeneratorListener;
    }

    public void setAttributeBuffer(StringBuffer attributeBuffer) {
        this.attributeBuffer = attributeBuffer;
    }

    public StringBuffer getAttributeBuffer() {
        return this.attributeBuffer;
    }

    public void setMethodBuffer(StringBuffer methodBuffer) {
        this.methodBuffer = methodBuffer;
    }

    public StringBuffer getMethodBuffer() {
        return this.methodBuffer;
    }

    public void setClassBuffer(StringBuffer classBuffer) {
        this.classBuffer = classBuffer;
    }

    public StringBuffer getClassBuffer() {
        return this.classBuffer;
    }

    public void setInterfaceBuffer(StringBuffer interfaceBuffer) {
        this.interfaceBuffer = interfaceBuffer;
    }

    public StringBuffer getInterfaceBuffer() {
        return this.interfaceBuffer;
    }

    public void close() {
        if (!this.closed) {
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preImplAttributes(this.classBuffer);
            }
            this.classBuffer.append(this.attributeBuffer);
            this.classBuffer.append(this.methodBuffer);
            this.classBuffer.append(lsep).append(this.indent).append("}").append(lsep2);
            this.closed = true;
            if (this.isGenerateInterface()) {
                this.interfaceBuffer.append(lsep).append(this.indent).append("}").append(lsep2);
            }
        }
    }

    public void setGenerateInterface(boolean generateInterface) {
        this.generateInterface = generateInterface;
    }

    public boolean isGenerateInterface() {
        return this.generateInterface;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setSdoTypeName(String sdoTypeName) {
        this.sdoTypeName = sdoTypeName;
    }

    public String getSdoTypeName() {
        return this.sdoTypeName;
    }

    public void setSdoType(SDOType sdoType) {
        this.sdoType = sdoType;
    }

    public SDOType getSdoType() {
        return this.sdoType;
    }
}

