/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxhub.web;

import com.google.common.net.UrlEscapers;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.media.video.Video;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemResource;
import org.apache.wicket.resource.FileSystemResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;

public class VideoDescription
extends Panel {
    String moviePath = "";
    private Movie movie;
    private transient Video video = null;
    private transient Path path;
    private transient FileSystemResourceReference ref;
    private transient DB db = DB.getInstance();
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    public VideoDescription(String id) {
        super(id);
    }

    public VideoDescription(String id, Movie movie) {
        super(id);
        this.movie = movie;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.LOGGER.info("Loading video description for " + this.movie.getTitle());
        WebMarkupContainer wmc = new WebMarkupContainer("wmc");
        this.LOGGER.info("movie-id: " + this.movie.getId());
        wmc.add(new Behavior[]{new AttributeModifier("tg", (Serializable)this.movie.getId())});
        wmc.add(new Component[]{new Label("desc", (Serializable)((Object)this.movie.getPublicDescription()))});
        wmc.add(new Component[]{new Label("title", (Serializable)((Object)this.movie.getTitle()))});
        List mediumFiles = this.db.getMediumFiles(this.movie, false);
        if (!mediumFiles.isEmpty()) {
            this.moviePath = ((MediumFile)mediumFiles.get(0)).getFileCompletePath();
            this.LOGGER.info("org: " + this.moviePath);
            this.moviePath = UrlEscapers.urlFragmentEscaper().escape(this.moviePath);
            this.LOGGER.info("enc: " + this.moviePath);
            this.moviePath = this.moviePath.replace("\u2026", "%E2%80%A6");
            this.moviePath = this.moviePath.replace("#", "%23");
            this.LOGGER.info("end: " + this.moviePath);
            this.moviePath = "file:///" + this.moviePath;
        } else {
            this.LOGGER.error("oooops, no medium files");
        }
        try {
            if (this.moviePath == null || this.moviePath == null || this.moviePath.isBlank()) {
                // empty if block
            }
            this.path = FileSystemResourceReference.getPath((URI)URI.create(this.moviePath));
            this.ref = new FileSystemResourceReference("video_" + new Date().toString() + this.movie.getId()){

                protected FileSystemResource getFileSystemResource() {
                    return new FileSystemResource(Path.of(URI.create(VideoDescription.this.moviePath)));
                }
            };
            this.video = new Video("video", (ResourceReference)this.ref);
            this.video.setOutputMarkupId(true);
            this.video.setControls(Boolean.valueOf(false));
            this.video.setHeight(Integer.valueOf(120));
            wmc.add(new Component[]{this.video});
        }
        catch (Exception ex) {
            this.LOGGER.error("ooops, something went wrong");
            java.util.logging.Logger.getLogger(VideoDescription.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.add(new Component[]{wmc});
    }
}

