/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxserver.services;

import com.querydsl.core.types.dsl.EntityPathBase;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.BookmarkType;
import xxx.scenerixx.scenerixxlib.model.enums.Differentiator;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;

@Path(value="v1")
public class ScenerixxServerApi {
    private static final Logger LOG = Logger.getLogger(ScenerixxServerApi.class.getName());
    private DB db = DB.getInstance();
    private static Scene currentScene = null;
    private static Bookmark currentBookmark = null;

    @GET
    @Path(value="newestVersion")
    @Produces(value={"application/json"})
    public String newestVersion(@QueryParam(value="version") Long version) {
        return "1.0";
    }

    @GET
    @Path(value="randomNames")
    @Produces(value={"application/json"})
    public List<String> getRandomNames() {
        List<Person> females = this.db.getPersons(Gender.FEMALE, false, false, 10000L);
        Collections.shuffle(females);
        females.removeIf(p -> p.getScenes(ScenerixxHubSession.get().isUnlocked()).isEmpty());
        females.removeIf(p -> p.getName().toLowerCase().contains("unknown"));
        int max = 50;
        if (females.size() - 1 < max) {
            max = females.size() - 1;
        }
        if (!females.isEmpty()) {
            females = females.subList(0, max);
        }
        List<String> names = females.stream().map(f -> f.getName()).collect(Collectors.toList());
        return names;
    }

    @GET
    @Path(value="markMovieAsFavorite")
    @Produces(value={"text/plain"})
    public String markMovieAsFavorite(@QueryParam(value="filename") String filename) {
        LOG.info("mark movie as favorite");
        Object result = "";
        Movie movie = this.getMovie(filename);
        if (movie != null) {
            LOG.info("current fav: " + movie.isFavorite() + " - ID: " + movie.getId());
            movie.setFavorite(true);
            movie = (Movie)this.db.getEntityService().save((AbstractEntity)movie);
            result = movie.getNameOfPlayable() + " was marked as favorite";
            LOG.info("current favorite now: " + movie.isFavorite());
        } else {
            result = "Could not find a movie for file: " + filename;
        }
        LOG.info((String)result);
        LOG.info("clear db context ");
        this.db.evictCache(Movie.class);
        return result;
    }

    @GET
    @Path(value="markSceneAsFavorite")
    @Produces(value={"text/plain"})
    public String markSceneAsFavorite(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        LOG.info("mark scene as favorite");
        Object result = "";
        LOG.info("filename : " + filename + " - time: " + time);
        if (filename == null || time == null) {
            return null;
        }
        int timeInSeconds = this.parseTime(time);
        if (timeInSeconds == -1) {
            return null;
        }
        Movie movie = this.getMovie(filename);
        if (movie != null) {
            Scene s = this.getScene(movie, timeInSeconds);
            if (s != null) {
                s.setFavorite(true);
                this.db.getEntityService().save((AbstractEntity)s);
                result = s.getNameOfPlayable() + " was marked as favorite";
                LOG.info("current fav scene: " + s.isFavorite() + " - ID: " + s.getId());
            }
        } else {
            result = "Could not find a movie for file: " + filename;
        }
        LOG.info((String)result);
        return result;
    }

    private Scene getScene(Movie movie, int timeInSeconds) {
        Scene result = null;
        for (Scene s : movie.getScenes()) {
            if (s.getStartTime() > timeInSeconds || s.getEndTime() < timeInSeconds) continue;
            result = s;
            break;
        }
        if (result == null) {
            LOG.info("Could not find scene");
        }
        return result;
    }

    private Movie getMovie(String filename) {
        if (!((String)filename).startsWith(File.separator)) {
            filename = File.separator + (String)filename;
        }
        LOG.info("file redacted: " + (String)filename);
        Movie movie = this.db.getMovie((String)filename);
        return movie;
    }

    private int parseTime(String time) {
        int timeInSeconds = -1;
        String[] split = time.split(":");
        if (split.length == 3) {
            try {
                int hour = Integer.parseInt(split[0].replace("00", "0"));
                int minutes = Integer.parseInt(split[1].replace("00", "0"));
                int seconds = Integer.parseInt(split[2].replace("00", "0"));
                timeInSeconds = hour * 60 * 60 + minutes * 60 + seconds;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.info("Could not parse time: " + numberFormatException.getMessage());
            }
        } else {
            LOG.info("Could not parse time. More than 3 splitted elements");
        }
        return timeInSeconds;
    }

    public static String formatSecondsToHHmmss(int totalSeconds) {
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    @GET
    @Path(value="remainingTimeInScene")
    @Produces(value={"text/plain"})
    public String remainingTimeInScene(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        int parseTime;
        Scene scene;
        LOG.info("remainingTimeInScene: " + filename + " @ " + time);
        String result = "remainingTimeInScene";
        Movie movie = this.getMovie(filename);
        if (movie != null && (scene = this.getScene(movie, parseTime = this.parseTime(time))) != null) {
            result = ScenerixxServerApi.formatSecondsToHHmmss(scene.getEndTime() - parseTime);
        }
        return result;
    }

    @GET
    @Path(value="iCame")
    @Produces(value={"text/plain"})
    public String iCame(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        LOG.info("icame: " + filename + " @ " + time);
        String result = "i came";
        Movie movie = this.getMovie(filename);
        if (movie != null) {
            int parseTime = this.parseTime(time);
            Scene scene = this.getScene(movie, parseTime);
            Statistic statistic = new Statistic();
            if (scene != null) {
                statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.scene.eq((Object)scene)).findFirst();
                if (statistic == null) {
                    statistic = new Statistic();
                    statistic = (Statistic)this.db.getEntityService().save((AbstractEntity)statistic);
                }
                statistic.setScene(scene);
                statistic.getLikes().add(LocalDateTime.now());
                this.db.getEntityService().save((AbstractEntity)statistic);
                int newPos = -1;
                for (Bookmark b : scene.getBookmarks(true)) {
                    if (newPos >= b.getPosition()) continue;
                    newPos = b.getPosition();
                }
                Bookmark newBookmark = new Bookmark();
                newBookmark.setDateOfCreation(LocalDateTime.now());
                newBookmark.setPosition(newPos + 1);
                newBookmark.setScene(scene);
                newBookmark.setStartTime(parseTime);
                scene.getBookmarks(true).add(newBookmark);
                newBookmark.setType(BookmarkType.ICAME);
                this.db.getEntityService().save((AbstractEntity)scene);
            } else {
                statistic = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.movie.eq((Object)movie)).findFirst();
                if (statistic == null) {
                    statistic = new Statistic();
                    statistic = (Statistic)this.db.getEntityService().save((AbstractEntity)statistic);
                }
                statistic.setMovie(movie);
                statistic.getLikes().add(LocalDateTime.now());
                this.db.getEntityService().save((AbstractEntity)statistic);
                int newPos = -1;
                for (Bookmark b : movie.getBookmarks(true)) {
                    if (newPos >= b.getPosition()) continue;
                    newPos = b.getPosition();
                }
                Bookmark newBookmark = new Bookmark();
                newBookmark.setDateOfCreation(LocalDateTime.now());
                newBookmark.setPosition(newPos + 1);
                newBookmark.setMovie(movie);
                newBookmark.setStartTime(parseTime);
                movie.getBookmarks(true).add(newBookmark);
                newBookmark.setType(BookmarkType.ICAME);
                this.db.getEntityService().save((AbstractEntity)movie);
            }
        } else {
            result = "";
        }
        return result;
    }

    @GET
    @Path(value="addScene")
    @Produces(value={"text/plain"})
    public String addScene(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        Movie movie = this.getMovie(filename);
        Object result = "";
        if (movie != null) {
            int parseTime = this.parseTime(time);
            int newPos = 0;
            for (Scene sc : movie.getScenes()) {
                if (newPos >= sc.getPos()) continue;
                newPos = sc.getPos();
            }
            Scene newScene = new Scene();
            newScene.setDateOfCreation(LocalDateTime.now());
            newScene.setPos(newPos + 1);
            newScene.setMovie(movie);
            newScene.setStartMedium(movie.getStartMedium());
            newScene.setStartTime(parseTime);
            movie.getScenes().add(newScene);
            movie = (Movie)this.db.getEntityService().save((AbstractEntity)movie);
            try {
                currentScene = (Scene)this.db.getEntityService().load(Scene.class, ((Scene)movie.getScenes().get(movie.getScenes().size() - 1)).getId().longValue());
                result = "Added scene to " + movie.getTitle();
                LOG.info("Added scene to " + movie.getTitle());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @GET
    @Path(value="setSceneEndTime")
    @Produces(value={"text/plain"})
    public String setSceneEndTime(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        String result = "";
        LOG.info("Set end time for scene: " + String.valueOf(currentScene));
        int parseTime = this.parseTime(time);
        if (currentScene != null) {
            currentScene.setEndTime(parseTime);
            currentScene.setEndMedium(currentScene.getStartMedium());
            currentScene = (Scene)this.db.getEntityService().save((AbstractEntity)currentScene);
            currentScene = null;
            result = "Set end time on scene";
        }
        return result;
    }

    @GET
    @Path(value="addBookmark")
    @Produces(value={"text/plain"})
    public String addBookmark(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        Scene scene;
        Object result = "";
        Movie movie = this.getMovie(filename);
        int parseTime = this.parseTime(time);
        if (movie != null && (scene = this.getScene(movie, parseTime)) != null) {
            int newPos = -1;
            for (Bookmark b : scene.getBookmarks(true)) {
                if (newPos >= b.getPosition()) continue;
                newPos = b.getPosition();
            }
            Bookmark newBookmark = new Bookmark();
            newBookmark.setDateOfCreation(LocalDateTime.now());
            newBookmark.setPosition(newPos + 1);
            newBookmark.setScene(scene);
            newBookmark.setStartTime(parseTime);
            newBookmark.setMedium(scene.getStartMedium());
            scene.getBookmarks(true).add(newBookmark);
            newBookmark.setType(BookmarkType.UNDEFINED);
            scene = (Scene)this.db.getEntityService().save((AbstractEntity)scene);
            LOG.finest("Added bookmark to " + movie.getTitle());
            result = "Added bookmark to " + movie.getTitle();
            try {
                currentBookmark = (Bookmark)this.db.getEntityService().load(Bookmark.class, ((Bookmark)scene.getBookmarks(true).get(scene.getBookmarks(true).size() - 1)).getId().longValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @GET
    @Path(value="setBookmarkEndTime")
    @Produces(value={"text/plain"})
    public String setBookmarkEndTime(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        String result = "";
        int parseTime = this.parseTime(time);
        if (currentBookmark != null) {
            currentBookmark.setEndTime(parseTime);
            this.db.getEntityService().save((AbstractEntity)currentBookmark);
            currentBookmark = null;
            result = "Set end time on bookmark";
        }
        return result;
    }

    @GET
    @Path(value="getMovieTypes")
    @Produces(value={"text/plain"})
    public String getMovieTypes(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        int parseTime;
        Scene scene;
        Object result = "";
        Movie movie = this.getMovie(filename);
        if (movie != null) {
            result = "movie types: " + movie.getTypesAsString();
        }
        if ((scene = this.getScene(movie, parseTime = this.parseTime(time))) != null && !scene.getTypesAsString().isBlank()) {
            result = (String)result + "\nscene types: " + scene.getTypesAsString();
        }
        return result;
    }

    @GET
    @Path(value="getRating")
    @Produces(value={"text/plain"})
    public String getRating(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        Object result = "";
        int parseTime = this.parseTime(time);
        Movie movie = this.getMovie(filename);
        if (movie != null) {
            if (movie.getRating() != null) {
                result = "" + movie.getRating();
                if (movie.getRatingDifferentiator() != null) {
                    result = (String)result + String.valueOf(movie.getRatingDifferentiator());
                }
            } else {
                Scene scene = this.getScene(movie, parseTime);
                if (scene != null && scene.getRating() != null) {
                    result = "" + scene.getRating();
                    if (scene.getRatingDifferentiator() != null) {
                        result = (String)result + String.valueOf(scene.getRatingDifferentiator());
                    }
                }
            }
        }
        if (((String)result).isBlank()) {
            result = "No rating yet";
        }
        return "rating: " + (String)result;
    }

    @GET
    @Path(value="setRating")
    @Produces(value={"text/plain"})
    public String setRating(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time, @QueryParam(value="rating") String rating) {
        String result = "";
        int parseTime = this.parseTime(time);
        Movie movie = this.getMovie(filename);
        if (movie != null) {
            Scene scene = this.getScene(movie, parseTime);
            if (scene != null) {
                rating = rating.replaceAll("%2B", "+");
                switch (rating.trim().charAt(rating.trim().length() - 1)) {
                    case '=': {
                        scene.setRatingDifferentiator(Differentiator.SAME);
                        rating = rating.trim().substring(0, rating.length() - 1);
                        break;
                    }
                    case '+': {
                        scene.setRatingDifferentiator(Differentiator.MORE);
                        rating = rating.trim().substring(0, rating.length() - 1);
                        break;
                    }
                    case '-': {
                        scene.setRatingDifferentiator(Differentiator.LESS);
                        rating = rating.trim().substring(0, rating.length() - 1);
                        break;
                    }
                }
                try {
                    Integer intRating = Integer.valueOf(rating);
                    scene.setRating(intRating);
                    this.db.getEntityService().save((AbstractEntity)scene);
                    if (movie.getScenes().size() == 1) {
                        movie.setRating(intRating);
                        movie.setRatingDifferentiator(scene.getRatingDifferentiator());
                        this.db.getEntityService().save((AbstractEntity)movie);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                return "Could not find scene";
            }
        }
        return "rating set: " + result;
    }

    @GET
    @Path(value="getImmersion")
    @Produces(value={"text/plain"})
    public String getImmersion(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time) {
        Scene scene;
        Object result = "";
        int parseTime = this.parseTime(time);
        Movie movie = this.getMovie(filename);
        if (movie != null && (scene = this.getScene(movie, parseTime)) != null && scene.getImmersion() != null) {
            result = "" + scene.getImmersion();
            if (scene.getImmersionDifferentiator() != null) {
                result = (String)result + String.valueOf(scene.getImmersionDifferentiator());
            }
        }
        if (((String)result).isBlank()) {
            result = "No immersion set";
        }
        return "immersion: " + (String)result;
    }

    @GET
    @Path(value="setImmersion")
    @Produces(value={"text/plain"})
    public String setImmersion(@QueryParam(value="filename") String filename, @QueryParam(value="time") String time, @QueryParam(value="immersion") String immersion) {
        String result = "";
        int parseTime = this.parseTime(time);
        Movie movie = this.getMovie(filename);
        if (movie != null) {
            Scene scene = this.getScene(movie, parseTime);
            if (scene != null) {
                String trim = immersion.trim().replaceAll("%2B", "+");
                switch (trim.charAt(trim.length() - 1)) {
                    case '=': {
                        scene.setImmersionDifferentiator(Differentiator.SAME);
                        immersion = trim.substring(0, immersion.length() - 1);
                        break;
                    }
                    case '+': {
                        scene.setImmersionDifferentiator(Differentiator.MORE);
                        immersion = trim.substring(0, immersion.length() - 1);
                        break;
                    }
                    case '-': {
                        scene.setImmersionDifferentiator(Differentiator.LESS);
                        immersion = trim.substring(0, immersion.length() - 1);
                        break;
                    }
                }
                try {
                    scene.setImmersion(Integer.valueOf(immersion));
                    this.db.getEntityService().save((AbstractEntity)scene);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                return "Could not find scene";
            }
        }
        return "immersion set: " + result;
    }
}

