/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxserver.web;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.QMovie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.PartnerCompatibility;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxserver.web.AbstractBasePage;
import xxx.scenerixx.scenerixxserver.web.MovieItemPanel;

public class HomePage
extends AbstractBasePage {
    private final Logger LOGGER = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private static final long serialVersionUID = 1L;
    WebMarkupContainer wmc;
    final Label lbStreamableResults = new Label("streamableResults");
    final Label lbTotalResults = new Label("totalResults");

    public HomePage(PageParameters parameters) {
        super(parameters);
        String searchString = "";
        Model searchModel = Model.of((Serializable)((Object)searchString));
        final TextField search = new TextField("search", (IModel)searchModel);
        this.wmc = new WebMarkupContainer("wmc");
        this.wmc.setOutputMarkupPlaceholderTag(true);
        this.wmc.setVisible(false);
        Form form = new Form("searchForm");
        this.add(new Component[]{form});
        AjaxFormComponentUpdatingBehavior searchBehavior = new AjaxFormComponentUpdatingBehavior("keyup"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                String currentSearchString = (String)search.getModel().getObject();
                if (currentSearchString != null && currentSearchString.length() >= 3) {
                    HomePage.this.LOGGER.info("search for: " + String.valueOf(search.getModel().getObject()));
                    HomePage.this.showSearchResults(currentSearchString);
                }
            }
        };
        search.add(new Behavior[]{searchBehavior});
        form.add(new Component[]{search});
        form.add(new Component[]{this.lbStreamableResults.setOutputMarkupPlaceholderTag(true)});
        form.add(new Component[]{this.lbTotalResults.setOutputMarkupPlaceholderTag(true)});
        DropDownChoice<PartnerCompatibility> ddcPartnerCompatibility = new DropDownChoice<PartnerCompatibility>("partnerComp", Arrays.asList(PartnerCompatibility.values())){};
        ddcPartnerCompatibility.setModel((IModel)new Model());
        ddcPartnerCompatibility.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (DropDownChoice)ddcPartnerCompatibility){
            final /* synthetic */ DropDownChoice val$ddcPartnerCompatibility;
            {
                this.val$ddcPartnerCompatibility = dropDownChoice;
                super(arg0);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                System.out.println("selected : " + String.valueOf(this.val$ddcPartnerCompatibility.getModelObject()));
                PartnerCompatibility modelObject = (PartnerCompatibility)this.val$ddcPartnerCompatibility.getModelObject();
                if (modelObject == null) {
                    HomePage.this.showSearchResults("");
                } else {
                    List partnerCompList = HomePage.this.db.getEntityService().find((EntityPathBase)QMovie.movie).find();
                    ArrayList tmpList = new ArrayList();
                    tmpList.addAll(partnerCompList);
                    for (Movie m : tmpList) {
                        if (!m.getScenes().isEmpty() && ((Scene)m.getScenes().get(0)).getPartnerCompatibility() != null) {
                            System.out.println(((Scene)m.getScenes().get(0)).getPartnerCompatibility().getTitle() + " - " + modelObject.getTitle());
                            if (!((Scene)m.getScenes().get(0)).getPartnerCompatibility().getTitle().equals(modelObject.getTitle())) {
                                partnerCompList.remove(m);
                                System.out.println("remoovve " + m.getTitle());
                                continue;
                            }
                            System.out.println("keep " + m.getTitle());
                            continue;
                        }
                        partnerCompList.remove(m);
                    }
                    System.out.println("partner list size " + partnerCompList.size());
                    HomePage.this.displayResult(partnerCompList, partnerCompList.size());
                }
            }
        }});
        form.add(new Component[]{ddcPartnerCompatibility.setNullValid(true)});
        PlaylistService ps = new PlaylistService();
        List playlists = ps.getPlaylists(false, false);
        DropDownChoice<Playlist> ddcPlaylist = new DropDownChoice<Playlist>("playlists", playlists, (IChoiceRenderer)new ChoiceRenderer<Playlist>(){

            public Object getDisplayValue(Playlist object) {
                return object.getName();
            }
        }){};
        ddcPlaylist.setModel((IModel)Model.of((Serializable)new Playlist()));
        ddcPlaylist.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change", (DropDownChoice)ddcPlaylist){
            final /* synthetic */ DropDownChoice val$ddcPlaylist;
            {
                this.val$ddcPlaylist = dropDownChoice;
                super(arg0);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                System.out.println("selected playlist: " + String.valueOf(this.val$ddcPlaylist.getModelObject()));
                Playlist modelObject = (Playlist)this.val$ddcPlaylist.getModelObject();
                if (modelObject == null) {
                    HomePage.this.showSearchResults("");
                } else {
                    ArrayList<Movie> moviesFromPlaylist = new ArrayList<Movie>();
                    for (IPlayablePlaylistItems p : modelObject.getPlayables(ScenerixxHubSession.get().isUnlocked())) {
                        if (p instanceof MediumFile) {
                            System.out.println("Mediumfiles are not supported yet: " + ((MediumFile)p).getNameOfPlayable());
                            continue;
                        }
                        if (!(p instanceof IPlayable)) continue;
                        moviesFromPlaylist.add(((IPlayable)p).getMovieAssociated());
                    }
                    System.out.println("moviesFromPlaylist size " + moviesFromPlaylist.size());
                    HomePage.this.displayResult(moviesFromPlaylist, moviesFromPlaylist.size());
                }
            }
        }});
        form.add(new Component[]{ddcPlaylist.setNullValid(true)});
        this.showSearchResults("");
    }

    private void showSearchResults(String searchTerm) {
        this.wmc.removeAll();
        int searchResultsTotal = 0;
        int searchResultsStreamable = 0;
        List<Object> moviesResult = new ArrayList<Movie>();
        if (searchTerm != null && !searchTerm.isEmpty()) {
            this.LOGGER.info("showing search results for '" + searchTerm + "'");
            List movies = this.db.getMovies(false);
            searchResultsTotal = movies.size();
            moviesResult = this.db.getMovies(false);
            String[] split = searchTerm.split(" ");
            boolean cntInclude = false;
            block0: for (Movie movie : movies) {
                boolean includeInResults = false;
                List mediumFiles = this.db.getMediumFiles(movie, true);
                if (mediumFiles.size() == 0) {
                    moviesResult.remove(movie);
                    continue;
                }
                if (((MediumFile)mediumFiles.get(0)).getFileExtension() == null) {
                    moviesResult.remove(movie);
                    continue;
                }
                if (((MediumFile)mediumFiles.get(0)).getFileExtension() != null && ((MediumFile)mediumFiles.get(0)).getFileExtension().isEmpty()) {
                    moviesResult.remove(movie);
                    continue;
                }
                if (!((MediumFile)mediumFiles.get(0)).getFileExtension().toUpperCase().endsWith("MP4") && !((MediumFile)mediumFiles.get(0)).getFileExtension().toUpperCase().endsWith("M4V")) {
                    moviesResult.remove(movie);
                    continue;
                }
                for (String s : split) {
                    String title = movie.getTitle();
                    if (title.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) {
                        this.LOGGER.debug("'" + s + "' matches movie " + movie.getTitle());
                        includeInResults = true;
                    }
                    for (Scene scene : movie.getScenes()) {
                        if (!scene.getPersonNames(ScenerixxHubSession.get().isUnlocked()).toLowerCase(Locale.ROOT).contains(searchTerm.toLowerCase(Locale.ROOT))) continue;
                        this.LOGGER.debug("'" + s + "' matches one person " + scene.getPersonNames(ScenerixxHubSession.get().isUnlocked()));
                        includeInResults = true;
                        break;
                    }
                    if (!includeInResults) {
                        moviesResult.remove(movie);
                        continue block0;
                    }
                    includeInResults = false;
                }
            }
            searchResultsStreamable = moviesResult.size();
        }
        this.displayResult(moviesResult, searchResultsStreamable);
    }

    private void displayResult(List<Movie> moviesResult, int searchResultsStreamable) {
        if (!moviesResult.isEmpty()) {
            this.wmc.setVisible(true);
        } else {
            this.wmc.setVisible(false);
        }
        RepeatingView repeatingView = new RepeatingView("movies");
        int cnt = 0;
        for (Movie m : moviesResult) {
            this.LOGGER.info("add " + m.getTitle() + " to the search results");
            repeatingView.add(new Component[]{new MovieItemPanel(repeatingView.newChildId(), (IModel<Movie>)Model.of((Serializable)m))});
            if (++cnt <= 128) continue;
            break;
        }
        this.wmc.addOrReplace(new Component[]{repeatingView});
        this.add(new Component[]{this.wmc.setOutputMarkupId(true)});
        Optional art = RequestCycle.get().find(AjaxRequestTarget.class);
        if (art.isPresent()) {
            this.lbStreamableResults.setDefaultModel((IModel)Model.of((Serializable)((Object)("Found " + searchResultsStreamable + " matches"))));
            ((AjaxRequestTarget)art.get()).add(new Component[]{this.lbStreamableResults});
            ((AjaxRequestTarget)art.get()).add(new Component[]{this.wmc});
        }
    }
}

