/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxserver.web;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import xxx.scenerixx.scenerixxhub.web.ScenerixxHubSession;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxserver.web.HomePage;
import xxx.scenerixx.scenerixxserver.web.VideoPage;

public class MovieItemPanel
extends Panel {
    private transient DB db = DB.getInstance();

    public MovieItemPanel(String id, final IModel<Movie> model) {
        super(id, model);
        Movie mov = (Movie)model.getObject();
        String studioName = "???";
        if (mov.getStudio() != null) {
            studioName = mov.getStudio().getName();
        }
        Object year = "???";
        if (mov.getReleaseYear() != null) {
            year = "" + mov.getReleaseYear();
        }
        this.add(new Component[]{new Label("studio", (Serializable)((Object)studioName))});
        this.add(new Component[]{new Label("year", (Serializable)year)});
        Object tags = "";
        if (mov.getType() != null) {
            tags = (String)tags + String.valueOf(mov.getType());
        }
        if (mov.getType2() != null) {
            tags = (String)tags + ", " + String.valueOf(mov.getType2());
        }
        if (mov.getType3() != null) {
            tags = (String)tags + ", " + String.valueOf(mov.getType3());
        }
        if (mov.getType4() != null) {
            tags = (String)tags + ", " + String.valueOf(mov.getType4());
        }
        if (mov.getType5() != null) {
            tags = (String)tags + ", " + String.valueOf(mov.getType5());
        }
        if (mov.getType6() != null) {
            tags = (String)tags + ", " + String.valueOf(mov.getType6());
        }
        if (!mov.getMovietypes().isEmpty()) {
            for (Object mt : mov.getMovietypes()) {
                tags = (String)tags + ", " + String.valueOf(mt);
            }
        }
        this.add(new Component[]{new Label("tags", (Serializable)tags)});
        Object cast = "";
        for (Scene s : mov.getScenes()) {
            if (s.getPersonNames(ScenerixxHubSession.get().isUnlocked()).isEmpty()) continue;
            cast = (String)cast + ", " + s.getPersonNames(ScenerixxHubSession.get().isUnlocked());
        }
        if (((String)cast).startsWith(",")) {
            cast = ((String)cast).substring(1);
        }
        this.add(new Component[]{new Label("cast", (Serializable)cast)});
        Object resRuntime = "n/a";
        int runtime = mov.getTotalRuntime();
        if (runtime >= 0) {
            resRuntime = String.format("%02d", runtime / 3600 % 24) + ":" + String.format("%02d", runtime / 60 % 60) + ":" + String.format("%02d", runtime % 60);
        }
        this.add(new Component[]{new Label("runtime", (Serializable)resRuntime)});
        this.add(new Component[]{new Label("scenes", (Serializable)Integer.valueOf(mov.getScenes().size()))});
        Link<Void> link = new Link<Void>("movieLink"){

            public void onClick() {
                List mediumFiles = MovieItemPanel.this.db.getMediumFiles((Movie)model.getObject(), false);
                if (!mediumFiles.isEmpty()) {
                    this.setResponsePage((IRequestablePage)new VideoPage((Movie)model.getObject(), ((MediumFile)mediumFiles.get(0)).getFileCompletePath()));
                } else {
                    this.setResponsePage(HomePage.class);
                }
            }
        };
        link.add(new Component[]{new Label("title", (IModel)new PropertyModel(model, "title"))});
        this.add(new Component[]{link});
    }
}

