/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.jpa.DefaultQueryHandler;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.QueryHandler;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HQLTemplates
extends JPQLTemplates {
    private static final QueryHandler QUERY_HANDLER;
    private static final List<Operator> wrapElements;
    public static final HQLTemplates DEFAULT;
    private final Map<Class<?>, String> typeNames;

    public HQLTemplates() {
        this('!');
    }

    public HQLTemplates(char escape) {
        super(escape, QUERY_HANDLER);
        HashMap<Class, String> builder = new HashMap<Class, String>();
        builder.put(Byte.class, "byte");
        builder.put(Short.class, "short");
        builder.put(Integer.class, "integer");
        builder.put(Long.class, "long");
        builder.put(BigInteger.class, "big_integer");
        builder.put(Float.class, "float");
        builder.put(Double.class, "double");
        builder.put(BigDecimal.class, "big_decimal");
        this.typeNames = Collections.unmodifiableMap(builder);
        try {
            Class<?> cl = Class.forName("com.querydsl.spatial.hibernate.HibernateSpatialSupport");
            this.add((Map)cl.getMethod("getSpatialOps", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean wrapElements(Operator operator) {
        return wrapElements.contains(operator);
    }

    @Override
    public String getTypeForCast(Class<?> cl) {
        String typeName = this.typeNames.get(cl);
        if (typeName == null) {
            return super.getTypeForCast(cl);
        }
        return typeName;
    }

    @Override
    public String getExistsProjection() {
        return "1";
    }

    @Override
    public boolean wrapConstant(Object constant) {
        Class<?> type = constant.getClass();
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    @Override
    public boolean isWithForOn() {
        return true;
    }

    @Override
    public boolean isCaseWithLiterals() {
        return true;
    }

    @Override
    public boolean isSubQueryModifiersSupported() {
        return true;
    }

    static {
        QueryHandler instance;
        try {
            instance = (QueryHandler)Class.forName("com.querydsl.jpa.HibernateHandler").newInstance();
        }
        catch (Exception | NoClassDefFoundError e) {
            instance = DefaultQueryHandler.DEFAULT;
        }
        QUERY_HANDLER = instance;
        wrapElements = Arrays.asList(Ops.QuantOps.ALL, Ops.QuantOps.ANY, Ops.QuantOps.AVG_IN_COL, Ops.EXISTS);
        DEFAULT = new HQLTemplates();
    }
}

