/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import kotlin.jvm.JvmInline;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.reflect.jvm.internal.KClassImpl;
import org.springframework.core.MethodParameter;

public final class KotlinInlineParameterResolver {
    private KotlinInlineParameterResolver() {
    }

    public static Class<?> resolveInlineType(MethodParameter methodParameter, Type type) {
        Method method = methodParameter.getMethod();
        if (method == null) {
            return null;
        }
        KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
        if (kFunction == null) {
            return null;
        }
        int paramIndex = methodParameter.getParameterIndex();
        KParameter kParam = kFunction.getParameters().stream().filter(p -> p.getKind() == KParameter.Kind.VALUE).skip(paramIndex).findFirst().orElse(null);
        if (kParam == null) {
            return null;
        }
        KClassifier classifier = kParam.getType().getClassifier();
        if (!(classifier instanceof KClass)) {
            return null;
        }
        KClass kClass = (KClass)classifier;
        for (Annotation a : kClass.getAnnotations()) {
            if (a.annotationType() != JvmInline.class || !(kClass instanceof KClassImpl)) continue;
            KClassImpl impl = (KClassImpl)kClass;
            return impl.getJClass();
        }
        return null;
    }
}

