/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.openide.util.actions.Presenter;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.settings.QUiState;
import xxx.scenerixx.scenerixxlib.model.settings.UiState;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.mediumfile.MediumFileListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.search.SearchTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.statistic.StatisticTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.studio.StudioListTopComponent;

public final class LoadLastSessionAction
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private final DB db = DB.getInstance();

    @Override
    public void actionPerformed(ActionEvent e) {
        MediumFileListTopComponent mfList;
        StudioListTopComponent studioList;
        MovieListTopComponent movieList;
        UiState uiState = (UiState)this.db.getEntityService().find((EntityPathBase)QUiState.uiState).findFirst();
        if (uiState == null) {
            AbstractTopComponent.notifyError("Could not find last session");
            return;
        }
        PersonListTopComponent personList = (PersonListTopComponent)WindowManager.getDefault().findTopComponent("PersonListTopComponent");
        if (personList != null && uiState.getSearchPerson() != null && !uiState.getSearchPerson().isEmpty()) {
            personList.getTfSearch().setText(uiState.getSearchPerson());
            personList.new PersonListTopComponent.UpdateSearchResultListWorker().execute();
        }
        if ((movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent")) != null && uiState.getSearchMovie() != null && !uiState.getSearchMovie().isEmpty()) {
            movieList.getTfSearch().setText(uiState.getSearchMovie());
            movieList.new MovieListTopComponent.UpdateSearchResultListWorker().execute();
        }
        if ((studioList = (StudioListTopComponent)WindowManager.getDefault().findTopComponent("StudioListTopComponent")) != null && uiState.getSearchStudio() != null && !uiState.getSearchStudio().isEmpty()) {
            studioList.getTfSearch().setText(uiState.getSearchStudio());
            studioList.reloadList();
        }
        if ((mfList = (MediumFileListTopComponent)WindowManager.getDefault().findTopComponent("MediumFileListTopComponent")) != null && uiState.getSearchMedium() != null && !uiState.getSearchMedium().isEmpty()) {
            mfList.getTfSearch().setText(uiState.getSearchMedium());
            mfList.reloadList();
        }
    }

    private void updateOtherWindows() {
        ScenerixxCommon.setSelectedNodesInTitle(-1);
        EventQueue.invokeLater(() -> {
            LocalDateTime now = LocalDateTime.now();
            AbstractTopComponent.dirtyMovieList();
            ScenerixxCommon.LOG.info("finished movies window " + Duration.between(LocalDateTime.now(), now).toString());
            AbstractTopComponent.dirtyPersonList();
            ScenerixxCommon.LOG.info("finished persons window " + Duration.between(LocalDateTime.now(), now).toString());
            AbstractTopComponent.dirtyPlaylist();
            ScenerixxCommon.LOG.info("finished playlist window " + Duration.between(LocalDateTime.now(), now).toString());
            AbstractTopComponent.dirtyMediumFileList();
            ScenerixxCommon.LOG.info("finished medium file window " + Duration.between(LocalDateTime.now(), now).toString());
            TopComponent search = WindowManager.getDefault().findTopComponent("SearchTopComponent");
            if (search != null) {
                ((SearchTopComponent)search).reload();
            }
            ScenerixxCommon.LOG.info("finished search window " + Duration.between(LocalDateTime.now(), now).toString());
            TopComponent details = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
            if (details != null) {
                ((DetailsTopComponent)details).unlockElements();
            }
            ScenerixxCommon.LOG.info("finished details window " + Duration.between(LocalDateTime.now(), now).toString());
            block0: for (Mode m : WindowManager.getDefault().getModes()) {
                TopComponent[] openedTopComponents;
                if (!m.getName().equals("editor")) continue;
                for (TopComponent tc : openedTopComponents = WindowManager.getDefault().getOpenedTopComponents(m)) {
                    if (tc.getName() == null || !tc.getName().equals("Statistic") || !tc.isOpened()) continue;
                    ((StatisticTopComponent)tc).setDirty();
                    ScenerixxCommon.LOG.info("finished statistic window " + Duration.between(LocalDateTime.now(), now).toString());
                    continue block0;
                }
            }
        });
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }

    @Override
    public boolean isEnabled() {
        return !Scenerixx.unlocked;
    }
}

