/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxmodule.Initializer;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public final class MakeBackupAction
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private DB db = DB.getInstance();
    private static final Logger LOG = Logger.getLogger(MakeBackupAction.class.getName());

    @Override
    public void actionPerformed(ActionEvent e) {
        ScenerixxSettings settings = this.db.getScenerixxSettings();
        if (settings.getBackupPath() == null || settings.getBackupPath().isBlank()) {
            JOptionPane.showMessageDialog(null, "Specify a backup directory first in the options.", "Error - No backup directory", 0);
        } else {
            int showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "<html>Make a backup?<br><br>You can make a backup now. If you want Scenerixx to make a backup each time Scenerixx is shut down, enable this feature in the options.<br><br>Make backup now?</html>", "Make now a backup?", 0, 1);
            if (showInternalConfirmDialog == 0) {
                LOG.fine("make backup");
                String makeBackup = new Initializer().makeBackup(settings, true, LOG);
                AbstractTopComponent.notifyInfo("Finished creating backup: " + makeBackup);
            } else {
                LOG.fine("make backup aborted");
                AbstractTopComponent.notifyWarning("User aborted. No backup was made.");
            }
        }
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }
}

