/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions;

import api.api.ScenerixxRestApiApi;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public final class ResetRegisterAction
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private DB db = DB.getInstance();
    private static final Logger LOG = Logger.getLogger(ResetRegisterAction.class.getName());
    private ScenerixxSettings settings = this.db.getScenerixxSettings();

    public ResetRegisterAction() {
        if (this.settings != null && this.settings.getActivationKey() != null) {
            this.putValue("Name", "Reset Registration");
        } else {
            this.putValue("Name", "Reset Registration");
            this.setEnabled(false);
        }
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"icons/Key.png", (boolean)false));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "<html>Reset Registration - Why?<br><br>In version 2.4.0 a registration was introduced. But due to a bug it was not usable. If you registered with version 2.4.0 you need to reset and then re-start the registration. Sorry.<br>Reset now?</html>", "Reset registration now?", 0, 1);
        if (showInternalConfirmDialog == 0) {
            LOG.fine("Reset registration");
            this.resetRegistration();
        } else {
            LOG.fine("Reset Registration aborted");
        }
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }

    private void resetRegistration() {
        AbstractTopComponent.notifyInfo("Start resetting the registration. This might take a bit");
        EntityManager entityManager = this.db.getEntityService().getEntityManager();
        ScenerixxRestApiApi api = new ScenerixxRestApiApi();
        api.deactivate(this.settings.getExternalId(), this.settings.getActivationKey());
        LOG.info("resetting registration");
        this.settings.setActivationKey(null);
        this.settings.setExternalId(null);
        this.db.getEntityService().save((AbstractEntity)this.settings);
        LOG.info("resetting medium files");
        int updatedRowsMedium = 0;
        try {
            entityManager.getTransaction().begin();
            Query nativeQueryResetOldValues = entityManager.createNativeQuery("UPDATE MEDIUM SET EXTERNALID = NULL, UPLOADED = FALSE");
            updatedRowsMedium += nativeQueryResetOldValues.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (entityManager.getTransaction().isActive()) {
                LOG.info("Error resetting mediums. " + ex.getMessage());
                entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        LOG.info("resetting persons");
        int updatedRowsPerson = 0;
        try {
            entityManager.getTransaction().begin();
            Query nativeQueryResetOldValues = entityManager.createNativeQuery("UPDATE PERSON SET EXTERNALID = NULL");
            updatedRowsPerson += nativeQueryResetOldValues.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (entityManager.getTransaction().isActive()) {
                LOG.info("Error resetting persons. " + ex.getMessage());
                entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        LOG.info("resetting studios");
        int updatedRowsStudio = 0;
        try {
            entityManager.getTransaction().begin();
            Query nativeQueryResetOldValues = entityManager.createNativeQuery("UPDATE STUDIO SET EXTERNALID = NULL");
            updatedRowsStudio += nativeQueryResetOldValues.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (entityManager.getTransaction().isActive()) {
                LOG.info("Error resetting studios. " + ex.getMessage());
                entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        LOG.info("resetting movies");
        int updatedRowsMovies = 0;
        try {
            entityManager.getTransaction().begin();
            Query nativeQueryResetOldValues = entityManager.createNativeQuery("UPDATE MOVIE SET EXTERNALID = NULL");
            updatedRowsMovies += nativeQueryResetOldValues.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            if (entityManager.getTransaction().isActive()) {
                LOG.info("Error resetting movies. " + ex.getMessage());
                entityManager.getTransaction().rollback();
                LOG.info("Transaction was rolled back.");
            }
            ex.printStackTrace();
        }
        Scenerixx.registered = false;
        LOG.info("Finished reset of registration.");
        LOG.info("Resetted person: " + updatedRowsPerson);
        LOG.info("Resetted movies: " + updatedRowsMovies);
        LOG.info("Resetted mediums: " + updatedRowsMedium);
        LOG.info("Resetted studios: " + updatedRowsStudio);
        AbstractTopComponent.notifyInfo("Registration successfully resetted!");
    }

    @Override
    public boolean isEnabled() {
        return Scenerixx.registered;
    }
}

