/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ImageResizer;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.search.SearchTopComponent;

public final class ShowPicturesAction
extends BooleanStateAction
implements ActionListener,
Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(ShowPicturesAction.class.getName());
    private static JFrame frame = new JFrame();
    private static ShowPicturesAction instance = null;
    private final DB db = DB.getInstance();
    private Map<String, List<String>> picturesToShow = new HashMap<String, List<String>>();
    private final List<File> files = new ArrayList<File>();
    private Point location = new Point();

    public ShowPicturesAction() {
        this.setBooleanState(false);
        instance = this;
    }

    public static ShowPicturesAction getInstance() {
        if (instance == null) {
            LOG.info("Create new instance for ShowPicturesAction");
            instance = new ShowPicturesAction();
        }
        return instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TopComponent movieListTopComponent;
        Person selectedPerson;
        boolean showAll = false;
        LOG.info("action event: " + String.valueOf(e));
        if (this.getBooleanState() && frame != null) {
            frame.dispose();
        } else {
            this.setBooleanState(true);
        }
        LOG.fine("boolean state: " + this.getBooleanState());
        ArrayList<Person> persons = new ArrayList<Person>();
        TopComponent personListTopComponent = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
        if (personListTopComponent != null) {
            LOG.info("is showing: " + personListTopComponent.isShowing());
            showAll = true;
        }
        if (personListTopComponent != null && personListTopComponent.isShowing() && (selectedPerson = ((PersonListTopComponent)personListTopComponent).getSelectedPerson()) != null) {
            persons.add(selectedPerson);
        }
        if (persons.isEmpty()) {
            TopComponent searchTopComponent = WindowManager.getDefault().findTopComponent("SearchTopComponent");
            if (searchTopComponent != null) {
                LOG.info("search is showing: " + searchTopComponent.isShowing());
            }
            if (searchTopComponent != null && searchTopComponent.isShowing()) {
                showAll = true;
                List<Person> selectedPerson2 = ((SearchTopComponent)searchTopComponent).getSelectedPersons();
                if (selectedPerson2 != null) {
                    persons.addAll(selectedPerson2);
                }
            }
        }
        if (persons.isEmpty() && (movieListTopComponent = WindowManager.getDefault().findTopComponent("MovieListTopComponent")) != null) {
            Bookmark bookmark;
            IPlayable selectedPlayable = ((MovieListTopComponent)movieListTopComponent).getSelectedPlayable();
            if (selectedPlayable instanceof Movie) {
                Movie movieAssociated = selectedPlayable.getMovieAssociated();
                if (movieAssociated != null) {
                    for (Scene s : movieAssociated.getScenes()) {
                        persons.addAll(s.getPersons(Scenerixx.unlocked));
                    }
                }
            } else if (selectedPlayable instanceof Scene) {
                Scene scene = (Scene)selectedPlayable;
                if (scene != null) {
                    persons.addAll(scene.getPersons(Scenerixx.unlocked));
                }
            } else if (selectedPlayable instanceof Bookmark && (bookmark = (Bookmark)selectedPlayable) != null) {
                if (bookmark.getPrimaryPerson() != null) {
                    persons.add(bookmark.getPrimaryPerson());
                }
                if (bookmark.getPrimaryPerson2() != null) {
                    persons.add(bookmark.getPrimaryPerson2());
                }
                if (bookmark.getPrimaryPerson3() != null) {
                    persons.add(bookmark.getPrimaryPerson3());
                }
                if (bookmark.getPassivePerson1() != null) {
                    persons.add(bookmark.getPassivePerson1());
                }
                if (bookmark.getPassivePerson2() != null) {
                    persons.add(bookmark.getPassivePerson2());
                }
                if (bookmark.getPassivePerson3() != null) {
                    persons.add(bookmark.getPassivePerson3());
                }
            }
        }
        if (persons.isEmpty()) {
            Person p1 = new Person();
            p1.setName("Please select a node");
            persons.add(p1);
        }
        LOG.fine("show pictures: " + persons.size() + " - all: " + showAll);
        this.showAllPersonPictures(persons, showAll);
    }

    public String getName() {
        return "Show Pictures";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.CheckboxMenuItem((BooleanStateAction)this, false);
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        LOG.fine("--cols: " + table.getColumnCount());
        columnModel.getColumn(0).setResizable(false);
        columnModel.getColumn(0).setPreferredWidth(50);
        for (int column = 0; column < table.getColumnCount(); ++column) {
            LOG.info("Resizeable " + columnModel.getColumn(column).getResizable());
            columnModel.getColumn(column).setResizable(true);
            LOG.fine("--rows: " + table.getRowCount());
            for (int row = 0; row < table.getRowCount() - 1; ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                int width = 15;
                if ((width = Math.max(table.prepareRenderer((TableCellRenderer)renderer, (int)row, (int)column).getPreferredSize().width + 1, width)) > 500) {
                    width = 500;
                }
                LOG.info("for width: " + width);
                int height = 300;
                LOG.info("files size: " + this.files.size());
                if (frame != null) {
                    height = frame.getHeight();
                    width = frame.getWidth() / 2;
                }
                if (width == 0 || height == 0) {
                    LOG.warning("height or width is 0. Skip.");
                    continue;
                }
                if (this.files.size() > row && column == 1) {
                    LOG.info("h/w: " + height + " / " + width);
                    table.getModel().setValueAt(ImageResizer.rescaleImage(this.files.get(row), height, width), row, 1);
                }
                columnModel.getColumn(column).setPreferredWidth(width);
            }
        }
    }

    public void showAllPersonPictures(List<Person> persons, boolean showAll) {
        LocalDateTime now = LocalDateTime.now();
        ArrayList<IPlayablePlaylistItems> tmpList = new ArrayList<IPlayablePlaylistItems>();
        for (Person p : persons) {
            tmpList.add((IPlayablePlaylistItems)p);
        }
        this.showPersonPictures(tmpList, showAll);
        LOG.fine("finished show all pictures - " + Duration.between(LocalDateTime.now(), now).toString());
    }

    public void showPersonPictures(List<Person> persons) {
        ArrayList<IPlayablePlaylistItems> tmpList = new ArrayList<IPlayablePlaylistItems>();
        for (Person p : persons) {
            tmpList.add((IPlayablePlaylistItems)p);
        }
        this.showPersonPictures(tmpList, false);
    }

    public void showPersonPictures(List<IPlayablePlaylistItems> persons, boolean showAllPix) {
        if (this.getBooleanState()) {
            Person person;
            LOG.info("show person pictures. Frame: " + String.valueOf(frame) + " - showAllPix " + showAllPix + " - persons: " + persons.size());
            ArrayList<IPlayablePlaylistItems> tmpPersons = new ArrayList<IPlayablePlaylistItems>();
            for (IPlayablePlaylistItems p : persons) {
                if (!(p instanceof Movie)) continue;
                tmpPersons.add(p);
            }
            for (IPlayablePlaylistItems p : persons) {
                if (!(p instanceof Person) || !Gender.FEMALE.equals((Object)(person = (Person)p).getGender())) continue;
                tmpPersons.add(p);
                LOG.info("added " + person.getName());
            }
            for (IPlayablePlaylistItems p : persons) {
                if (!(p instanceof Person) || !Gender.TS.equals((Object)(person = (Person)p).getGender())) continue;
                tmpPersons.add(p);
                LOG.info("added " + person.getName());
            }
            for (IPlayablePlaylistItems p : persons) {
                if (!(p instanceof Person) || !Gender.MALE.equals((Object)(person = (Person)p).getGender())) continue;
                tmpPersons.add(p);
                LOG.info("added " + person.getName());
            }
            persons.clear();
            persons.addAll(tmpPersons);
            EventQueue.invokeLater(() -> {
                this.files.clear();
                ArrayListValuedHashMap personPictures = new ArrayListValuedHashMap();
                if (persons.isEmpty()) {
                    Person dummyPerson = new Person();
                    dummyPerson.setName("No picture found");
                    persons.add((IPlayablePlaylistItems)dummyPerson);
                } else {
                    LOG.fine("iterate over " + persons.size() + " persons to find pictures");
                }
                int images = 0;
                for (IPlayablePlaylistItems p : persons) {
                    String profilePictureDirectory;
                    if (!(p instanceof Person)) continue;
                    Person person = (Person)p;
                    if (showAllPix) {
                        List<File> findAllProfileFiles = new ScenerixxCommon().findAllProfileFiles(person.getName());
                        if (findAllProfileFiles != null && !findAllProfileFiles.isEmpty()) {
                            for (File f : findAllProfileFiles) {
                                ++images;
                            }
                        } else {
                            ++images;
                        }
                    }
                    if ((profilePictureDirectory = this.db.getScenerixxSettings().getProfilePictureDirectory()) != null && !profilePictureDirectory.isEmpty()) {
                        File profileFile = new ScenerixxCommon().findProfileFile(person.getName(), new File(profilePictureDirectory));
                        if (profileFile != null) {
                            ++images;
                            continue;
                        }
                        ++images;
                        continue;
                    }
                    ++images;
                }
                int height = 1;
                if (images == 0 || frame == null || frame != null && frame.getHeight() == 0) {
                    height = 150;
                } else {
                    height = frame.getHeight() / images;
                    LOG.info("height : " + frame.getHeight());
                }
                if (height < 100) {
                    height = 100;
                }
                int width = 300;
                if (frame != null) {
                    width = frame.getWidth();
                }
                for (IPlayablePlaylistItems p : persons) {
                    String profilePictureDirectory;
                    if (!(p instanceof Person)) continue;
                    Person person = (Person)p;
                    boolean noPic = false;
                    if (showAllPix) {
                        List<File> findAllProfileFiles = new ScenerixxCommon().findAllProfileFiles(person.getName());
                        if (findAllProfileFiles != null && !findAllProfileFiles.isEmpty()) {
                            for (File f : findAllProfileFiles) {
                                this.files.add(f);
                                personPictures.put((Object)person.getName(), (Object)new ImageIcon(f.getAbsolutePath()));
                            }
                        } else {
                            noPic = true;
                        }
                    }
                    if ((profilePictureDirectory = this.db.getScenerixxSettings().getProfilePictureDirectory()) != null && !profilePictureDirectory.isEmpty()) {
                        File profileFile = new ScenerixxCommon().findProfileFile(person.getName(), new File(profilePictureDirectory));
                        if (profileFile != null) {
                            this.files.add(profileFile);
                            personPictures.put((Object)person.getName(), (Object)new ImageIcon(profileFile.getAbsolutePath()));
                        } else {
                            noPic = true;
                        }
                    } else {
                        noPic = true;
                    }
                    if (noPic) {
                        personPictures.put((Object)person.getName(), (Object)new ImageIcon(this.getClass().getResource("/icons.silk/camera_error.png")));
                    }
                    Object[][] data = new Object[personPictures.size()][2];
                    int i = 0;
                    Map asMap = personPictures.asMap();
                    TreeMap treemap = new TreeMap(asMap);
                    for (Map.Entry entry : treemap.entrySet()) {
                        for (ImageIcon icon : (Collection)entry.getValue()) {
                            LOG.info(i + ". person : " + (String)entry.getKey());
                            data[i][0] = entry.getKey();
                            data[i][1] = icon;
                            ++i;
                        }
                    }
                    Object[] column = new String[]{"Person", "Picture"};
                    JTable table = new JTable(data, column);
                    table.setRowHeight(250);
                    int imageViewIndex = table.convertColumnIndexToView(1);
                    table.getColumnModel().getColumn(imageViewIndex).setCellRenderer(new IconCellRenderer());
                    this.resizeColumnWidth(table);
                    this.showPictureTable(table);
                }
            });
        }
    }

    public void showPictureTable(final JTable table) {
        if (frame != null) {
            frame.setVisible(false);
            frame.dispose();
            this.setBooleanState(true);
        }
        frame = new JFrame(){

            @Override
            public void dispose() {
                LOG.fine("dispose frame");
                ShowPicturesAction.this.setBooleanState(false);
                if (frame != null) {
                    ShowPicturesAction.this.location = frame.getLocation();
                }
                frame = null;
                super.dispose();
            }
        };
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setSize(300, 4000);
        frame.add(scrollPane);
        frame.setSize(300, 250);
        LOG.info("size: " + frame.getWidth() + " - " + frame.getHeight());
        frame.setLocation(this.location);
        frame.setVisible(true);
        frame.setAlwaysOnTop(true);
        frame.setDefaultCloseOperation(2);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                LOG.info("resize frame: " + frame.getWidth() + " - " + frame.getHeight());
                new UpdateFrameAfterResizeWorker(table, frame.getWidth(), frame.getHeight(), ShowPicturesAction.this.files).execute();
            }
        });
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    public class IconCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JLabel)c).setIcon((ImageIcon)value);
            ((JLabel)c).setText("");
            return c;
        }
    }

    public class UpdateFrameAfterResizeWorker
    extends SwingWorker<String, String> {
        JTable table;
        int width;
        int height;
        List<File> icons;

        public UpdateFrameAfterResizeWorker(JTable table, int width, int height, List<File> icons) {
            this.table = table;
            this.width = width;
            this.height = height;
            this.icons = icons;
        }

        @Override
        protected String doInBackground() throws Exception {
            int orgWidth = frame.getWidth();
            int orgHeight = frame.getHeight();
            Thread.sleep(100L);
            if (frame.getWidth() == orgWidth && frame.getHeight() == orgHeight) {
                Thread.sleep(100L);
                if (frame.getWidth() == orgWidth && frame.getHeight() == orgHeight) {
                    SwingUtilities.invokeLater(() -> {
                        LOG.info("XXX height: " + frame.getHeight() + " - row count: " + this.table.getRowCount());
                        int height1 = frame.getHeight() / this.table.getRowCount();
                        if (height1 > 0) {
                            this.table.setRowHeight(height1 * this.table.getRowCount());
                        }
                        ShowPicturesAction.this.resizeColumnWidth(this.table);
                    });
                }
            } else {
                LOG.fine("still moving. org: " + orgWidth + "/" + orgHeight + " - current: " + frame.getWidth() + " / " + frame.getHeight());
            }
            return "";
        }
    }
}

