/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.playlist.QPlaylist;
import xxx.scenerixx.scenerixxlib.model.statistic.QScenerixxStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.ScenerixxStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.UploadStatistic;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.sync.WebServiceHelper;
import xxx.scenerixx.scenerixxmodule.windows.statistic.UsageStatisticService;
import xxx.scenerixx.scenerixxserver.ScenerixxServer;

public final class UploadUsageStatisticAction
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private DB db = DB.getInstance();
    public static final Logger LOG = Logger.getLogger(UploadUsageStatisticAction.class.getName());

    public UploadUsageStatisticAction() {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "Can we upload a usage statistic?", "Upload usage statistic?", 0, 1);
        if (showInternalConfirmDialog == 0) {
            UploadStatistic us = new UploadStatistic();
            ScenerixxStatistic scenerixxStat = (ScenerixxStatistic)this.db.getEntityService().find((EntityPathBase)QScenerixxStatistic.scenerixxStatistic).findFirst();
            us.setHowOftenStarted((long)scenerixxStat.getStarted().size());
            us.setRegistered(Scenerixx.registered);
            us.setPlaylists(this.db.getEntityService().find((EntityPathBase)QPlaylist.playlist).count());
            us.setPlaylistsBookmarkEntries((long)this.db.getPlaylistBookmarkIds(false).size());
            us.setPlaylistsSceneEntries((long)this.db.getPlaylistSceneIds(false).size());
            us.setPlaylistsMovieEntries((long)this.db.getPlaylistMovieIds(false).size());
            LOG.info(us.toString());
            LOG.info(UsageStatisticService.getUsageStatistic().toString());
            LOG.info(Scenerixx.statisticInternal.toString());
            String stat = us.toString() + " - " + UsageStatisticService.getUsageStatistic().toString() + " " + Scenerixx.statisticInternal.toString();
            WebServiceHelper.uploadUsageStatistic(stat);
        }
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }

    @Override
    public boolean isEnabled() {
        return ScenerixxServer.getServer().isStopped() || ScenerixxServer.getServer().isFailed();
    }
}

