/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.actions.scenerixxhub;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.statistic.UsageStatisticService;
import xxx.scenerixx.scenerixxserver.ScenerixxServer;

public final class StreamingServerAction
extends AbstractAction
implements ActionListener,
Presenter.Popup {
    private DB db = DB.getInstance();
    public static final Logger LOG = Logger.getLogger(StreamingServerAction.class.getName());

    public StreamingServerAction() {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UsageStatisticService.incScenerixxHub();
        try {
            LOG.info("Trying to start server with path:" + Scenerixx.scenerixxServerPath);
            new ScenerixxServer().startServer(Scenerixx.scenerixxServerPath, this.db.getScenerixxSettings().getPort());
            Object ip = "I don't know";
            try (DatagramSocket socket = new DatagramSocket();){
                socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
                ip = "      http://" + socket.getLocalAddress().getHostAddress() + ":" + this.db.getScenerixxSettings().getPort() + "\n or: ";
            }
            catch (SocketException ex) {
                ip = "";
                LOG.info("Could not determine IP-address. Propably no internet connection:" + ex.getMessage());
            }
            int showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "Scenerixx Hub is running!\n\nYou can reach it via your browser under: \n" + (String)ip + String.valueOf(ScenerixxServer.getServer().getURI()) + "\n or: http://localhost:" + this.db.getScenerixxSettings().getPort() + "\n\nPress Yes to open browser. Press no to close this dialog.", "This is an alpha feature. Don't expect too much.", 0, 1);
            if (showInternalConfirmDialog == 0) {
                UsageStatisticService.incScenerixxHubOpenBrowser();
                ScenerixxCommon.openExternalBrowser("http://localhost:" + this.db.getScenerixxSettings().getPort(), this.db.getScenerixxSettings().getPathToDefaultBrowserBinary());
            }
        }
        catch (Exception ex) {
            String cause = ex.getCause() != null ? " - " + ex.getCause().getMessage() : "";
            String errorMessage = "Server could not be started: \n" + ex.getMessage() + "\n" + cause;
            if (ex.getMessage().contains("Failed to bind")) {
                errorMessage = errorMessage + "\nSeems like another application is running already on the port " + this.db.getScenerixxSettings().getPort();
            }
            JOptionPane.showMessageDialog(null, errorMessage, "Server Error", 0, ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"icons/Error.png")));
        }
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem(this);
    }

    @Override
    public boolean isEnabled() {
        return ScenerixxServer.getServer().isStopped() || ScenerixxServer.getServer().isFailed();
    }
}

