/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.bookmark.action;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxmodule.childfactories.bookmark.BookmarkChildFactory;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class CreateGifAction
extends NodeAction
implements Presenter.Popup {
    private DB db = DB.getInstance();

    public CreateGifAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/clip_splitter.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length == 1 && activatedNodes[0].getValue("bookmark") != null) {
            Bookmark bookmark = (Bookmark)activatedNodes[0].getValue("bookmark");
            ScenerixxSettings scenerixxSettings = this.db.getScenerixxSettings();
            if (scenerixxSettings.getGifDirectory() == null || scenerixxSettings.getGifDirectory() != null && scenerixxSettings.getGifDirectory().isEmpty()) {
                AbstractTopComponent.notifyError("Specify a destination directory for GIFs in the settings first.");
            } else if (bookmark.getStartMedium() == null || bookmark.getStartMedium() != null && !(bookmark.getStartMedium() instanceof MediumFile)) {
                JOptionPane.showMessageDialog(null, "Bookmark is not associated to a medium file");
            } else {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("ffmpeg");
                cmd.add("-ss");
                cmd.add("" + bookmark.getStartTime());
                cmd.add("-t");
                cmd.add("" + bookmark.getEndTime());
                cmd.add("-i");
                cmd.add(((MediumFile)bookmark.getStartMedium()).getFileCompletePath());
                cmd.add("-filter_complex");
                cmd.add("[0:v] fps=" + scenerixxSettings.getGifFps() + ",scale=" + scenerixxSettings.getGifWidth() + ":-1,split [a][b];[a] palettegen [p];[b][p] paletteuse");
                String filename = bookmark.getNameOfPlayable() + ".gif";
                String destDir = scenerixxSettings.getGifDirectory();
                Object tmpdest = destDir + filename;
                Object dest = tmpdest = ((String)tmpdest).replaceAll("\"", "");
                cmd.add((String)dest);
                BookmarkChildFactory.LOG.fine("Parameters to create GIF: " + cmd.stream().map(x -> x).collect(Collectors.joining(" ")));
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command(cmd);
                builder.redirectErrorStream(true);
                SwingUtilities.invokeLater(() -> CreateGifAction.lambda$performAction$1(builder, (String)dest));
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1;
    }

    public String getName() {
        return "Create GIF";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    private static /* synthetic */ void lambda$performAction$1(ProcessBuilder builder, String dest) {
        try {
            AbstractTopComponent.notifyInfo("Start creating GIF");
            Process process = builder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    BookmarkChildFactory.LOG.info(line);
                }
            }
            process.waitFor();
            AbstractTopComponent.notifyInfo("Finished creating GIF: " + dest + ". In case something went wrong check the IDE Log.");
            BookmarkChildFactory.LOG.fine("Finished: " + process.exitValue());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

