/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.panel.PersonSelectionPanel;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;

public class AddPersonsAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(AddPersonsAction.class.getName());
    private final DB db = DB.getInstance();
    private final ScenerixxCommon common = new ScenerixxCommon();

    public AddPersonsAction() {
        Image image = ImageUtilities.loadImage((String)"icons/persons.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        final PersonSelectionPanel panel = new PersonSelectionPanel();
        JOptionPane op = new JOptionPane(panel, 3, 2){

            @Override
            public void selectInitialValue() {
                panel.getComboPerson();
            }
        };
        int selectedMovies = 0;
        for (Node n : activatedNodes) {
            if ((n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) && (n.getValue("scene") == null || !(n.getValue("scene") instanceof Scene))) continue;
            ++selectedMovies;
        }
        JDialog dlg = op.createDialog("Set person for " + selectedMovies + " scenes");
        dlg.setVisible(true);
        dlg.addWindowFocusListener(new WindowAdapter(this){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                panel.gainedFocus();
            }
        });
        if (op.getValue() != null && op.getValue().equals(0)) {
            int cntScenes = 0;
            for (Node n : activatedNodes) {
                Iterator iterator;
                if (n.getValue("movie") != null && (iterator = n.getValue("movie")) instanceof Movie) {
                    Movie m = (Movie)iterator;
                    m = (Movie)this.db.getEntityService().load(Movie.class, m.getId().longValue());
                    if (m.getScenes().size() != 1) continue;
                    this.addPerson(panel.getPerson(), m);
                    this.addPerson(panel.getPerson2(), m);
                    this.addPerson(panel.getPerson3(), m);
                    this.addPerson(panel.getPerson4(), m);
                    if (panel.getPerson().getId() == null && panel.getPerson2().getId() == null && panel.getPerson3().getId() == null && panel.getPerson4().getId() == null) continue;
                    ++cntScenes;
                    continue;
                }
                if (n.getValue("scene") == null || !((iterator = n.getValue("scene")) instanceof Scene)) continue;
                Scene s = (Scene)iterator;
                s = (Scene)this.db.getEntityService().load(Scene.class, s.getId().longValue());
                iterator = s.getMovie().getScenes().iterator();
                while (iterator.hasNext()) {
                    Scene tmpScene = (Scene)iterator.next();
                    if (!tmpScene.equals(s)) continue;
                    s = this.addPerson(panel.getPerson(), s);
                    s = this.addPerson(panel.getPerson2(), s);
                    s = this.addPerson(panel.getPerson3(), s);
                    s = this.addPerson(panel.getPerson4(), s);
                }
                LOG.fine(s.getTitle() + " - Added - Person 1: " + panel.getPerson().getName() + " Person 2: " + panel.getPerson2().getName() + " Person 3: " + panel.getPerson3().getName() + " Person 4: " + panel.getPerson4().getName());
                if (panel.getPerson().getId() == null && panel.getPerson2().getId() == null && panel.getPerson3().getId() == null && panel.getPerson4().getId() == null) continue;
                ++cntScenes;
            }
            SwingUtilities.invokeLater(() -> {
                DetailsTopComponent detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (detailTC != null) {
                    detailTC.updateDisplayNameOfSelectedNode(false, false);
                }
                AbstractTopComponent.dirtyPersonList();
            });
        }
    }

    private Scene addPerson(Person person, Scene s) {
        if (person.getId() != null) {
            s = (Scene)this.db.getEntityService().load(Scene.class, s.getId().longValue());
            s.getPersons(Scenerixx.unlocked).add(person);
            boolean added = this.db.addPersonToScene(person, s);
            if (!added) {
                AbstractTopComponent.notifyWarning(String.valueOf(person) + " is already added to this scene");
                this.common.askToAddDuplicatePerson(person, s);
            } else {
                AbstractTopComponent.notifyInfo("Added '" + person.getName() + "' to " + s.getNameOfPlayable() + ".");
            }
        }
        return s;
    }

    private void addPerson(Person person, Movie m) {
        if (person.getId() != null) {
            m = (Movie)this.db.getEntityService().load(Movie.class, m.getId().longValue());
            ((Scene)m.getScenes().get(0)).getPersons(Scenerixx.unlocked).add(person);
            LOG.fine(m.getTitle() + " - Added: " + person.getName());
            boolean added = this.db.addPersonToScene(person, (Scene)m.getScenes().get(0));
            if (!added) {
                AbstractTopComponent.notifyWarning(String.valueOf(person) + " is already added to this scene");
                this.common.askToAddDuplicatePerson(person, (Scene)m.getScenes().get(0));
            } else {
                AbstractTopComponent.notifyInfo("Added '" + person.getName() + "' to " + ((Scene)m.getScenes().get(0)).getNameOfPlayable() + ".");
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.finer("Check if AddPersonsAction is enabled");
        boolean enable = false;
        for (Node n : activatedNodes) {
            if ((n.getValue("scene") == null || !(n.getValue("scene") instanceof Scene)) && (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie))) continue;
            LOG.finer("it's a scene or a movie");
            enable = true;
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie) || ((Movie)n.getValue("movie")).getScenes().size() == 1) continue;
            LOG.finer("One movie has more than one scene");
            enable = false;
            break;
        }
        return enable;
    }

    public String getName() {
        return "Add Person(s)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

