/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.CompareMoviesPanel;
import xxx.scenerixx.scenerixxmodule.windows.statistic.UsageStatisticService;

public class CompareMoviesAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(CompareMoviesAction.class.getName());

    public CompareMoviesAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, 0));
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/compare.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        UsageStatisticService.incCompareMovies();
        EventQueue.invokeLater(() -> {
            JDialog frame = new JDialog((Frame)null, "Compare movies", true);
            JScrollPane scrollPane = new JScrollPane(new CompareMoviesPanel(activatedNodes[0], activatedNodes[1]));
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(20);
            frame.add(scrollPane);
            frame.getContentPane().add(scrollPane);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.finer("Check if CompareMoviesAction is enabled");
        boolean enable = false;
        if (activatedNodes.length == 2) {
            for (Node n : activatedNodes) {
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) {
                    enable = false;
                    break;
                }
                LOG.fine("it's a movie");
                enable = true;
            }
        } else {
            LOG.finer("Exactly two movies needs to be selected. Selected: " + activatedNodes.length);
        }
        return enable;
    }

    public String getName() {
        return "Compare Movies";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    protected boolean asynchronous() {
        return false;
    }
}

