/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.mediumfile.MediumFileListTopComponent;

public class DeleteMediumFileAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(DeleteMediumFileAction.class.getName());
    private final DB db = DB.getInstance();
    private final ScenerixxCommon common = new ScenerixxCommon();

    public DeleteMediumFileAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        Image image = ImageUtilities.loadImage((String)"icons/Database.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedMediumfiles = 0;
        for (Node node : activatedNodes) {
            if (node.getValue("mediumFile") == null || !(node.getValue("mediumFile") instanceof MediumFile)) continue;
            ++selectedMediumfiles;
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Should " + ScenerixxCommon.singularPlural(selectedMediumfiles, "mediumfile", "mediumfiles", true) + " really get deleted?", "Delete " + ScenerixxCommon.singularPlural(selectedMediumfiles, "mediumfile", "mediumfiles", false) + " from the database?", 0)) {
            TopComponent mediumfileList = WindowManager.getDefault().findTopComponent("MediumFileListTopComponent");
            MediumFile nextMediumfile = this.readInNextNode(mediumfileList);
            MediumFile nextNextMediumFile = this.readInNextNode(mediumfileList, 1);
            for (Node n : activatedNodes) {
                if (n.getValue("mediumFile") == null || !(n.getValue("mediumFile") instanceof MediumFile)) continue;
                LOG.fine("Deleting mediumfiles " + ((MediumFile)n.getValue("mediumFile")).getNameOfPlayable());
                boolean bl = this.db.deleteMediumFile((MediumFile)n.getValue("mediumFile"), false);
            }
            int n = selectedMediumfiles;
            SwingUtilities.invokeLater(() -> {
                AbstractTopComponent.notifyInfo(ScenerixxCommon.singularPlural(tmpSelectedMediumFiles, "mediumfile", "mediumfiles", true) + " deleted");
                ((MediumFileListTopComponent)mediumfileList).reloadList(Node.EMPTY);
                Node setNextNode = this.setNextNode(mediumfileList, nextMediumfile);
                if (setNextNode == null) {
                    this.setNextNode(mediumfileList, nextNextMediumFile);
                }
            });
        }
    }

    private Node setNextNode(TopComponent mediumFileList, MediumFile nextMediumFile) {
        Node result = null;
        if (mediumFileList != null) {
            result = ((MediumFileListTopComponent)mediumFileList).selectMediumFileNode(nextMediumFile);
        }
        return result;
    }

    private MediumFile readInNextNode(TopComponent mediumFileList) {
        return this.readInNextNode(mediumFileList, 0);
    }

    private MediumFile readInNextNode(TopComponent mediumFileList, int offset) {
        MediumFile nextMediumFile = null;
        if (mediumFileList != null) {
            Node nextNode = Node.EMPTY;
            nextNode = ((MediumFileListTopComponent)mediumFileList).getNextNode(offset);
            if (nextNode != null && nextNode.getValue("mediumFile") != null && nextNode.getValue("mediumFile") instanceof MediumFile) {
                nextMediumFile = (MediumFile)nextNode.getValue("mediumFile");
            }
        }
        return nextMediumFile;
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Remove mediumfile(s) from database";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

