/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.io.File;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.medium.DeletedMedium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.mediumfile.MediumFileListTopComponent;

public class DeleteMediumFileFromDiscAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(DeleteMediumFileFromDiscAction.class.getName());
    private DB db = DB.getInstance();
    private ScenerixxCommon common = new ScenerixxCommon();

    public DeleteMediumFileFromDiscAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 64));
        Image image = ImageUtilities.loadImage((String)"icons/harddisk.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedMediumFiles = 0;
        Long fileSize = 0L;
        for (Node node : activatedNodes) {
            if (node.getValue("mediumFile") == null || !(node.getValue("mediumFile") instanceof MediumFile)) continue;
            ++selectedMediumFiles;
            fileSize = fileSize + ((MediumFile)node.getValue("mediumFile")).getFileSize();
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Do you really want to delete " + ScenerixxCommon.singularPlural(activatedNodes.length, "selected file", "selected files", true) + " [" + ScenerixxCommon.readableFileSize(fileSize) + "] from disc?", "Are you sure?", 0)) {
            TopComponent mediumfileList = WindowManager.getDefault().findTopComponent("MediumFileListTopComponent");
            MediumFile nextMediumFile = this.readInNextNode(mediumfileList);
            MediumFile nextNextMediumFile = this.readInNextNode(mediumfileList, 1);
            for (Node n : activatedNodes) {
                if (n.getValue("mediumFile") == null || !(n.getValue("mediumFile") instanceof MediumFile)) continue;
                LOG.fine("Deleting mediumfiles " + ((MediumFile)n.getValue("mediumFile")).getNameOfPlayable());
                MediumFile mediumFile = (MediumFile)n.getValue("mediumFile");
                if (mediumFile.getMovie() != null) {
                    JOptionPane.showMessageDialog(null, "File '" + mediumFile.getFileCompletePath() + "' could not be deleted from disc! It's still associated to a movie.", "Error", 0);
                    --selectedMediumFiles;
                    continue;
                }
                this.db.deleteMediumFile(mediumFile, false);
                File f = new File(mediumFile.getFileCompletePath());
                long fSize = f.length();
                boolean deleted = f.delete();
                if (!deleted) {
                    --selectedMediumFiles;
                    JOptionPane.showMessageDialog(null, "File '" + mediumFile.getFileCompletePath() + "' could not be deleted from disc! File was not found. We just removed it from the database.", "Error", 0);
                } else {
                    DeletedMedium dm = new DeletedMedium();
                    dm.setHashValue(mediumFile.getHashValue());
                    this.db.getEntityService().save((AbstractEntity)dm);
                    StatisticInternal stats = (StatisticInternal)this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{g -> g.dateOfCreation.desc()}).findFirst();
                    if (stats == null) {
                        stats = new StatisticInternal();
                    }
                    stats.setSavedBytes(stats.getSavedBytes() + fSize);
                    this.db.getEntityService().save((AbstractEntity)stats);
                    this.common.checkEmptyDirectoryAndDeleteIfWanted(mediumFile);
                }
                nextMediumFile = this.readInNextNode(mediumfileList);
                nextNextMediumFile = this.readInNextNode(mediumfileList, 1);
            }
            MediumFile mediumFile = nextMediumFile;
            MediumFile finalNextNextMediumFile = nextNextMediumFile;
            int tmpSelectedMediumFiles = selectedMediumFiles;
            SwingUtilities.invokeLater(() -> {
                AbstractTopComponent.notifyInfo(ScenerixxCommon.singularPlural(tmpSelectedMediumFiles, "mediumfile", "mediumfiles", true) + " deleted");
                ((MediumFileListTopComponent)mediumfileList).reloadList(Node.EMPTY);
                Node setNextNode = this.setNextNode(mediumfileList, finalNextMediumFile);
                if (setNextNode == null) {
                    this.setNextNode(mediumfileList, finalNextNextMediumFile);
                }
            });
        }
    }

    private Node setNextNode(TopComponent mediumFileList, MediumFile nextMediumFile) {
        Node result = null;
        if (mediumFileList != null) {
            result = ((MediumFileListTopComponent)mediumFileList).selectMediumFileNode(nextMediumFile);
        }
        return result;
    }

    private MediumFile readInNextNode(TopComponent mediumFileList) {
        return this.readInNextNode(mediumFileList, 0);
    }

    private MediumFile readInNextNode(TopComponent mediumFileList, int offset) {
        MediumFile nextMediumFile = null;
        if (mediumFileList != null) {
            Node nextNode = Node.EMPTY;
            nextNode = ((MediumFileListTopComponent)mediumFileList).getNextNode(offset);
            if (nextNode != null && nextNode.getValue("mediumFile") != null && nextNode.getValue("mediumFile") instanceof MediumFile) {
                nextMediumFile = (MediumFile)nextNode.getValue("mediumFile");
            }
        }
        return nextMediumFile;
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Delete mediumfile(s) from disc";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

